/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.collections.graphdb.BijectiveConnectionMode;
import org.neo4j.collections.graphdb.ConnectionMode;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.Property;
import org.neo4j.collections.graphdb.PropertyComparator;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.impl.ConnectorTypeImpl;
import org.neo4j.collections.graphdb.impl.EdgeTypeImpl;
import org.neo4j.collections.graphdb.impl.PropertyImpl;
import org.neo4j.collections.graphdb.impl.VertexTypeImpl;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;

public abstract class PropertyType<T>
extends EdgeTypeImpl {
    public static final String PROPERTYCONNECTORNAME = "PropertyConnector";

    private PropertyType(DatabaseService db, Long id) {
        super(db, id);
    }

    public boolean hasProperty(Vertex vertex) {
        return vertex.getPropertyContainer().hasProperty(this.getName());
    }

    public T getPropertyValue(Vertex vertex) {
        return (T)vertex.getPropertyContainer().getProperty(this.getName());
    }

    public Property<T> getProperty(Vertex vertex) {
        return new PropertyImpl(this.getDb(), vertex, this);
    }

    public Property<T> setProperty(Vertex vertex, T value) {
        vertex.getPropertyContainer().setProperty(this.getName(), value);
        return this.getProperty(vertex);
    }

    public T removeProperty(Vertex vertex) {
        return (T)vertex.getPropertyContainer().removeProperty(this.getName());
    }

    @Override
    public PropertyContainer getPropertyContainer() {
        return this.getNode();
    }

    public ConnectorType<BijectiveConnectionMode> getPropertyConnectorType() {
        return ConnectorTypeImpl.getOrCreateInstance(this.getDb(), PROPERTYCONNECTORNAME, this.getNode(), ConnectionMode.BIJECTIVE);
    }

    @Override
    public Set<ConnectorType<?>> getConnectorTypes() {
        HashSet roles = new HashSet();
        roles.add(this.getPropertyConnectorType());
        return roles;
    }

    public static PropertyType<?> getPropertyTypeByName(DatabaseService db, String name) {
        return (PropertyType)VertexTypeImpl.getByName(db, name);
    }

    public static class VertexPropertyType
    extends PropertyType<Vertex> {
        public VertexPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$VertexPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static VertexPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, VertexPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, VertexPropertyType.getImplementationClass())).getId());
            return new VertexPropertyType(db, vertexType.getNode().getId());
        }

        @Override
        public boolean hasProperty(Vertex vertex) {
            return vertex.getPropertyContainer().hasProperty(this.getName());
        }

        @Override
        public Vertex getPropertyValue(Vertex vertex) {
            return this.getDb().getVertex(this.getDb().getNodeById((Long)vertex.getPropertyContainer().getProperty(this.getName())));
        }

        @Override
        public Property<Vertex> getProperty(Vertex vertex) {
            return new PropertyImpl<Vertex>(this.getDb(), vertex, this);
        }

        @Override
        public Property<Vertex> setProperty(Vertex vertex, Vertex value) {
            vertex.getPropertyContainer().setProperty(this.getName(), (Object)value.getNode().getId());
            return this.getProperty(vertex);
        }

        @Override
        public Vertex removeProperty(Vertex vertex) {
            return this.getDb().getVertex(this.getDb().getNodeById((Long)vertex.getPropertyContainer().removeProperty(this.getName())));
        }
    }

    public static class StringPropertyType
    extends ComparablePropertyType<String> {
        public StringPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        public static StringPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, StringPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, StringPropertyType.getImplementationClass())).getId());
            return new StringPropertyType(db, vertexType.getNode().getId());
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$StringPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        @Override
        public int compare(String value, Node node) {
            if (node.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            String propertyValue = (String)node.getProperty(this.getName());
            return value.compareTo(propertyValue);
        }

        @Override
        public int compare(Node node1, Node node2) {
            if (node1.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            String propertyValue1 = (String)node1.getProperty(this.getName());
            if (node2.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            String propertyValue2 = (String)node2.getProperty(this.getName());
            return propertyValue1.compareTo(propertyValue2);
        }
    }

    public static class StringArrayPropertyType
    extends PropertyType<String[]> {
        public StringArrayPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$StringArrayPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static StringArrayPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, StringArrayPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, StringArrayPropertyType.getImplementationClass())).getId());
            return new StringArrayPropertyType(db, vertexType.getNode().getId());
        }
    }

    public static class ShortPropertyType
    extends ComparablePropertyType<Short> {
        public ShortPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        public static ShortPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, ShortPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, ShortPropertyType.getImplementationClass())).getId());
            return new ShortPropertyType(db, vertexType.getNode().getId());
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$ShortPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        @Override
        public int compare(Short value, Node node) {
            if (node.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Short propertyValue = (Short)node.getProperty(this.getName());
            return value.compareTo(propertyValue);
        }

        @Override
        public int compare(Node node1, Node node2) {
            if (node1.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Short propertyValue1 = (Short)node1.getProperty(this.getName());
            if (node2.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Short propertyValue2 = (Short)node2.getProperty(this.getName());
            return propertyValue1.compareTo(propertyValue2);
        }
    }

    public static class ShortArrayPropertyType
    extends PropertyType<Short[]> {
        public ShortArrayPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$ShortArrayPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static ShortArrayPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, ShortArrayPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, ShortArrayPropertyType.getImplementationClass())).getId());
            return new ShortArrayPropertyType(db, vertexType.getNode().getId());
        }
    }

    public static class LongPropertyType
    extends ComparablePropertyType<Long> {
        public LongPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        public static LongPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, LongPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, LongPropertyType.getImplementationClass())).getId());
            return new LongPropertyType(db, vertexType.getNode().getId());
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$LongPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        @Override
        public int compare(Long value, Node node) {
            if (node.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Long propertyValue = (Long)node.getProperty(this.getName());
            return value.compareTo(propertyValue);
        }

        @Override
        public int compare(Node node1, Node node2) {
            if (node1.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Long propertyValue1 = (Long)node1.getProperty(this.getName());
            if (node2.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Long propertyValue2 = (Long)node2.getProperty(this.getName());
            return propertyValue1.compareTo(propertyValue2);
        }
    }

    public static class LongArrayPropertyType
    extends PropertyType<Long[]> {
        public LongArrayPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$LongArrayPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static LongArrayPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, LongArrayPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, LongArrayPropertyType.getImplementationClass())).getId());
            return new LongArrayPropertyType(db, vertexType.getNode().getId());
        }
    }

    public static class IntegerPropertyType
    extends ComparablePropertyType<Integer> {
        public IntegerPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$IntegerPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static IntegerPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, IntegerPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, IntegerPropertyType.getImplementationClass())).getId());
            return new IntegerPropertyType(db, vertexType.getNode().getId());
        }

        @Override
        public int compare(Integer value, Node node) {
            if (node.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Integer propertyValue = (Integer)node.getProperty(this.getName());
            return value.compareTo(propertyValue);
        }

        @Override
        public int compare(Node node1, Node node2) {
            if (node1.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Integer propertyValue1 = (Integer)node1.getProperty(this.getName());
            if (node2.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Integer propertyValue2 = (Integer)node2.getProperty(this.getName());
            return propertyValue1.compareTo(propertyValue2);
        }
    }

    public static class IntegerArrayPropertyType
    extends PropertyType<Integer[]> {
        public IntegerArrayPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$IntegerArrayPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static IntegerArrayPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, IntegerArrayPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, IntegerArrayPropertyType.getImplementationClass())).getId());
            return new IntegerArrayPropertyType(db, vertexType.getNode().getId());
        }
    }

    public static class FloatPropertyType
    extends ComparablePropertyType<Float> {
        public FloatPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$FloatPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static FloatPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, FloatPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, FloatPropertyType.getImplementationClass())).getId());
            return new FloatPropertyType(db, vertexType.getNode().getId());
        }

        @Override
        public int compare(Float value, Node node) {
            if (node.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Float propertyValue = (Float)node.getProperty(this.getName());
            return value.compareTo(propertyValue);
        }

        @Override
        public int compare(Node node1, Node node2) {
            if (node1.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Float propertyValue1 = (Float)node1.getProperty(this.getName());
            if (node2.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Float propertyValue2 = (Float)node2.getProperty(this.getName());
            return propertyValue1.compareTo(propertyValue2);
        }
    }

    public static class FloatArrayPropertyType
    extends PropertyType<Float[]> {
        public FloatArrayPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$FloatArrayPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static FloatArrayPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, FloatArrayPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, FloatArrayPropertyType.getImplementationClass())).getId());
            return new FloatArrayPropertyType(db, vertexType.getNode().getId());
        }
    }

    public static class DoublePropertyType
    extends ComparablePropertyType<Double> {
        public DoublePropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$DoublePropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static DoublePropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, DoublePropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, DoublePropertyType.getImplementationClass())).getId());
            return new DoublePropertyType(db, vertexType.getNode().getId());
        }

        @Override
        public int compare(Double value, Node node) {
            if (node.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Double propertyValue = (Double)node.getProperty(this.getName());
            return value.compareTo(propertyValue);
        }

        @Override
        public int compare(Node node1, Node node2) {
            if (node1.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Double propertyValue1 = (Double)node1.getProperty(this.getName());
            if (node2.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Double propertyValue2 = (Double)node2.getProperty(this.getName());
            return propertyValue1.compareTo(propertyValue2);
        }
    }

    public static class DoubleArrayPropertyType
    extends PropertyType<Double[]> {
        public DoubleArrayPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$DoubleArrayPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static DoubleArrayPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, DoubleArrayPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, DoubleArrayPropertyType.getImplementationClass())).getId());
            return new DoubleArrayPropertyType(db, vertexType.getNode().getId());
        }
    }

    public static class BytePropertyType
    extends ComparablePropertyType<Byte> {
        public BytePropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$BytePropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static BytePropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, BytePropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, BytePropertyType.getImplementationClass())).getId());
            return new BytePropertyType(db, vertexType.getNode().getId());
        }

        @Override
        public int compare(Byte value, Node node) {
            if (node.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Byte propertyValue = (Byte)node.getProperty(this.getName());
            return value.compareTo(propertyValue);
        }

        @Override
        public int compare(Node node1, Node node2) {
            if (node1.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Byte propertyValue1 = (Byte)node1.getProperty(this.getName());
            if (node2.hasProperty(this.getName())) {
                throw new RuntimeException("Node does not have property " + this.getName());
            }
            Byte propertyValue2 = (Byte)node2.getProperty(this.getName());
            return propertyValue1.compareTo(propertyValue2);
        }
    }

    public static class ByteArrayPropertyType
    extends PropertyType<Byte[]> {
        public ByteArrayPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$ByteArrayPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static ByteArrayPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, ByteArrayPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, ByteArrayPropertyType.getImplementationClass())).getId());
            return new ByteArrayPropertyType(db, vertexType.getNode().getId());
        }
    }

    public static class BooleanPropertyType
    extends PropertyType<Boolean> {
        public BooleanPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$BooleanPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static BooleanPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, BooleanPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, BooleanPropertyType.getImplementationClass())).getId());
            return new BooleanPropertyType(db, vertexType.getNode().getId());
        }
    }

    public static class BooleanArrayPropertyType
    extends PropertyType<Boolean[]> {
        public BooleanArrayPropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        private static Class<?> getImplementationClass() {
            try {
                return Class.forName("org.neo4j.collections.graphdb.PropertyType$BooleanArrayPropertyType");
            }
            catch (ClassNotFoundException cce) {
                throw new RuntimeException(cce);
            }
        }

        public static BooleanArrayPropertyType getOrCreateInstance(DatabaseService db, String name) {
            VertexTypeImpl vertexType = new VertexTypeImpl(db, BooleanArrayPropertyType.getOrCreateByDescriptor(new VertexTypeImpl.TypeNodeDescriptor(db, name, BooleanArrayPropertyType.getImplementationClass())).getId());
            return new BooleanArrayPropertyType(db, vertexType.getNode().getId());
        }
    }

    public static abstract class ComparablePropertyType<T>
    extends PropertyType<T>
    implements Comparator<Node>,
    PropertyComparator<T> {
        ComparablePropertyType(DatabaseService db, Long id) {
            super(db, id);
        }

        @Override
        public abstract int compare(Node var1, Node var2);

        @Override
        public abstract int compare(T var1, Node var2);
    }
}

