/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import org.neo4j.collections.graphdb.ConnectionMode;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.collections.graphdb.impl.VertexImpl;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class ConnectorTypeImpl<T extends ConnectionMode>
extends VertexImpl
implements ConnectorType<T> {
    public static final String CONNECTOR_TYPE_NAME = "org.neo4j.collections.graphdb.connector_type_name";
    public static final String CONNECTOR_MODE = "org.neo4j.collections.graphdb.connector_mode";

    public ConnectorTypeImpl(DatabaseService db, Long id) {
        super(db, id);
    }

    private static <U extends ConnectionMode> ConnectorType<U> create(DatabaseService db, String name, Node edgeTypeNode, U connectionMode, VertexType domain) {
        Node n = db.createNode();
        edgeTypeNode.createRelationshipTo(n, (RelationshipType)RelTypes.ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_TYPE);
        n.setProperty(CONNECTOR_TYPE_NAME, (Object)name);
        n.setProperty(CONNECTOR_MODE, (Object)connectionMode.getName());
        if (domain == null) {
            n.createRelationshipTo(db.getRootType().getNode(), (RelationshipType)RelTypes.ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_DOMAIN);
        } else {
            n.createRelationshipTo(domain.getNode(), (RelationshipType)RelTypes.ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_DOMAIN);
        }
        return new ConnectorTypeImpl(db, n.getId());
    }

    public static <U extends ConnectionMode> ConnectorType<U> getOrCreateInstance(DatabaseService db, String name, Node edgeTypeNode, U connectionMode) {
        return ConnectorTypeImpl.getOrCreateInstance(db, name, edgeTypeNode, connectionMode, db.getRootType());
    }

    public static <U extends ConnectionMode> ConnectorType<U> getOrCreateInstance(DatabaseService db, String name, Node edgeTypeNode, U connectionMode, VertexType domain) {
        if (edgeTypeNode.hasRelationship((RelationshipType)RelTypes.ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_TYPE, Direction.OUTGOING)) {
            for (Relationship rel : edgeTypeNode.getRelationships((RelationshipType)RelTypes.ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_TYPE, Direction.OUTGOING)) {
                if (!rel.getEndNode().getProperty(CONNECTOR_TYPE_NAME).equals(name)) continue;
                return new ConnectorTypeImpl(db, rel.getEndNode().getId());
            }
            return ConnectorTypeImpl.create(db, name, edgeTypeNode, connectionMode, domain);
        }
        return ConnectorTypeImpl.create(db, name, edgeTypeNode, connectionMode, domain);
    }

    @Override
    public String getName() {
        return (String)this.getNode().getProperty(CONNECTOR_TYPE_NAME);
    }

    public static ConnectionMode getConnectionMode(String name) {
        if (name.equals(ConnectionMode.UNRESTRICTED.getName())) {
            return ConnectionMode.UNRESTRICTED;
        }
        if (name.equals(ConnectionMode.INJECTIVE.getName())) {
            return ConnectionMode.INJECTIVE;
        }
        if (name.equals(ConnectionMode.SURJECTIVE.getName())) {
            return ConnectionMode.SURJECTIVE;
        }
        if (name.equals(ConnectionMode.BIJECTIVE.getName())) {
            return ConnectionMode.BIJECTIVE;
        }
        throw new RuntimeException("Unknown connection mode " + name);
    }

    @Override
    public ConnectionMode getConnectionMode() {
        String connectionModeName = (String)this.getNode().getProperty(CONNECTOR_MODE);
        return ConnectorTypeImpl.getConnectionMode(connectionModeName);
    }

    @Override
    public EdgeType getEdgeType() {
        return (EdgeType)this.db.getVertex(this.getNode().getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)this.getName()), Direction.INCOMING).getStartNode());
    }

    @Override
    public VertexType getDomain() {
        return (VertexType)this.db.getVertex(this.getNode().getSingleRelationship((RelationshipType)RelTypes.ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_DOMAIN, Direction.OUTGOING).getEndNode());
    }

    public static enum RelTypes implements RelationshipType
    {
        ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_TYPE,
        ORG_NEO4J_COLLECTIONS_GRAPHDB_CONNECTOR_DOMAIN;

    }
}

