/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import java.util.ArrayList;
import org.neo4j.collections.graphdb.BinaryEdge;
import org.neo4j.collections.graphdb.ConnectionMode;
import org.neo4j.collections.graphdb.Connector;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.LeftRestrictedConnectionMode;
import org.neo4j.collections.graphdb.Property;
import org.neo4j.collections.graphdb.PropertyType;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.collections.graphdb.impl.ConnectorTypeImpl;
import org.neo4j.collections.graphdb.impl.EdgeImpl;
import org.neo4j.collections.graphdb.impl.VertexImpl;
import org.neo4j.collections.graphdb.impl.VertexTypeImpl;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;

public class PropertyImpl<T>
extends EdgeImpl
implements Property<T> {
    public static final String PROPERTYCONTAINER_ID = "org.neo4j.collections.graphdb.propertycontainer_id";
    public static final String PROPERTYCONTAINER_TYPE = "org.neo4j.collections.graphdb.propertycontainer_type";
    public static final String PROPERTY_NAME = "org.neo4j.collections.graphdb.property_name";
    private final Vertex vertex;
    private final PropertyType<T> propertyType;
    private Node node;

    public PropertyImpl(DatabaseService db, Vertex vertex, PropertyType<T> propertyType) {
        super(db, 0L);
        this.vertex = vertex;
        this.propertyType = propertyType;
    }

    public long getId() {
        return this.getNode().getId();
    }

    @Override
    public T getValue() {
        return this.vertex.getPropertyValue(this.propertyType);
    }

    @Override
    public PropertyType<T> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public PropertyContainer getPropertyContainer() {
        return this.getNode();
    }

    @Override
    public Iterable<PropertyType<?>> getPropertyTypes() {
        return null;
    }

    @Override
    public Node getNode() {
        if (this.node != null) {
            return this.node;
        }
        if (this.vertex.getPropertyContainer().hasProperty(this.propertyType.getName() + ".node_id")) {
            return this.getDb().getGraphDatabaseService().getNodeById(((Long)this.vertex.getPropertyContainer().getProperty(this.propertyType.getName() + ".node_id")).longValue());
        }
        Node n = this.db.createNode();
        n.setProperty(PROPERTYCONTAINER_ID, (Object)this.vertex.getNode().getId());
        n.setProperty(PROPERTY_NAME, (Object)this.propertyType.getName());
        if (this.vertex instanceof BinaryEdge) {
            n.setProperty(PROPERTYCONTAINER_TYPE, (Object)PropertyContainerType.RELATIONSHIP.name());
        } else {
            n.setProperty(PROPERTYCONTAINER_TYPE, (Object)PropertyContainerType.NODE.name());
        }
        this.vertex.getPropertyContainer().setProperty(this.propertyType.getName() + ".node_id", (Object)n.getId());
        return n;
    }

    @Override
    public Vertex getVertex() {
        return new VertexImpl(this.db, this.getNode().getId());
    }

    @Override
    public void delete() {
        this.node.removeProperty(((VertexTypeImpl)((Object)this.getType())).getName());
    }

    @Override
    protected VertexType getSpecialVertexType() {
        return this.getType();
    }

    @Override
    public PropertyType<T> getType() {
        return this.propertyType;
    }

    @Override
    public boolean isType(EdgeType relType) {
        return this.propertyType.getNode().getId() == relType.getNode().getId();
    }

    @Override
    public Iterable<Connector<?>> getConnectors() {
        ArrayList connectors = new ArrayList();
        connectors.add(Connector.getInstance(((PropertyType)this.getType()).getPropertyConnectorType(), this));
        return connectors;
    }

    @Override
    public <U extends LeftRestrictedConnectionMode> Vertex getVertex(ConnectorType<U> connectorType) {
        if (connectorType.getName().equals("PropertyConnector")) {
            return this.getVertex();
        }
        return null;
    }

    @Override
    public Iterable<Connector<?>> getConnectors(ConnectorType<?> ... connectorTypes) {
        ArrayList connectors = new ArrayList();
        for (ConnectorType<?> connectorType : connectorTypes) {
            if (!connectorType.getName().equals("PropertyConnector")) continue;
            connectors.add(Connector.getInstance(ConnectorTypeImpl.getOrCreateInstance(this.db, "NullaryConnector", ((VertexImpl)((Object)this.getType())).getNode(), ConnectionMode.BIJECTIVE), this));
        }
        return connectors;
    }

    public <U extends ConnectionMode> Iterable<Vertex> getVertices(ConnectorType<U> connectorType) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        vertices.add(this.getVertex());
        return vertices;
    }

    public static enum PropertyContainerType {
        NODE,
        RELATIONSHIP;

    }
}

