/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import org.neo4j.collections.graphdb.BinaryEdgeType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.SortableBinaryEdge;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.collections.graphdb.impl.BinaryEdgeImpl;
import org.neo4j.collections.graphdb.impl.SortableBinaryEdgeTypeImpl;
import org.neo4j.collections.indexedrelationship.IndexedRelationship;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;

public class SortableBinaryEdgeImpl<T>
extends BinaryEdgeImpl
implements SortableBinaryEdge<T> {
    private IndexedRelationship relIdx;

    SortableBinaryEdgeImpl(DatabaseService db, Long id, IndexedRelationship relIdx) {
        super(db, id);
        this.relIdx = relIdx;
    }

    public IndexedRelationship getRelIdx() {
        return this.relIdx;
    }

    public Node getRootNode() {
        return this.relIdx.getIndexedNode();
    }

    @Override
    public Vertex getEndVertex() {
        return this.getDb().getVertex(this.getRelationship().getEndNode());
    }

    @Override
    public Vertex getOtherVertex(Vertex element) {
        return this.getDb().getVertex(this.getRelationship().getOtherNode(element.getNode()));
    }

    @Override
    public Vertex getStartVertex() {
        return this.getDb().getVertex(this.getRootNode());
    }

    @Override
    public void delete() {
        this.getRelIdx().removeRelationshipTo(this.getEndVertex().getNode());
    }

    @Override
    protected VertexType getSpecialVertexType() {
        return this.getType();
    }

    @Override
    public BinaryEdgeType getType() {
        return SortableBinaryEdgeTypeImpl.getOrCreateInstance(this.getDb(), this.getRelationship().getType());
    }

    @Override
    public boolean isType(EdgeType relType) {
        return this.getRelationship().isType((RelationshipType)DynamicRelationshipType.withName((String)relType.getName()));
    }

    @Override
    public PropertyContainer getPropertyContainer() {
        return this.getNode();
    }
}

