/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.VertexType;
import org.neo4j.collections.graphdb.impl.VertexImpl;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public class VertexTypeImpl
extends VertexImpl
implements VertexType {
    public static String TYPE_NAME = "org.neo4j.collections.graphdb.TYPE_NAME";
    public static String CLASS_NAME = "org.neo4j.collections.graphdb.CLASS_NAME";

    public static VertexType getByName(DatabaseService db, String name) {
        return (VertexType)db.getVertex(VertexTypeImpl.getNodeByName(db, name));
    }

    private static Class<?> getImplementationClass() {
        try {
            return Class.forName("org.neo4j.collections.graphdb.impl.VertexTypeImpl");
        }
        catch (ClassNotFoundException cce) {
            throw new RuntimeException(cce);
        }
    }

    private static Node getNodeByName(DatabaseService db, String name) {
        DynamicRelationshipType relType;
        Node typeSubRef = VertexTypeImpl.getOrCreateTypeSubRef(db);
        if (typeSubRef.hasRelationship((RelationshipType)(relType = DynamicRelationshipType.withName((String)name)), Direction.OUTGOING)) {
            return typeSubRef.getSingleRelationship((RelationshipType)relType, Direction.OUTGOING).getEndNode();
        }
        return null;
    }

    public static Node getOrCreateByDescriptor(TypeNodeDescriptor tnd) {
        Node typeSubRef = VertexTypeImpl.getOrCreateTypeSubRef(tnd.db);
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)tnd.name);
        Node foundNode = VertexTypeImpl.getNodeByName(tnd.db, tnd.name);
        if (foundNode != null) {
            if (tnd.claz.getName().equals(foundNode.getProperty(CLASS_NAME))) {
                return foundNode;
            }
            throw new RuntimeException("A type already exists with than name");
        }
        Node newNode = tnd.db.createNode();
        tnd.initialize(newNode);
        typeSubRef.createRelationshipTo(newNode, (RelationshipType)relType);
        return newNode;
    }

    public static VertexTypeImpl getOrCreateInstance(DatabaseService db, String name) {
        return new VertexTypeImpl(db, VertexTypeImpl.getOrCreateByDescriptor(new TypeNodeDescriptor(db, name, VertexTypeImpl.getImplementationClass())).getId());
    }

    private static Node getOrCreateTypeSubRef(DatabaseService db) {
        RelTypes relType;
        Node refNode = db.getReferenceNode();
        if (refNode.hasRelationship((RelationshipType)(relType = RelTypes.ORG_NEO4J_COLLECTIONS_GRAPHDB_TYPE_SUBREF), Direction.OUTGOING)) {
            return refNode.getSingleRelationship((RelationshipType)relType, Direction.OUTGOING).getEndNode();
        }
        Node n = db.createNode();
        refNode.createRelationshipTo(n, (RelationshipType)relType);
        return n;
    }

    public VertexTypeImpl(DatabaseService db, Long id) {
        super(db, id);
    }

    @Override
    public String getName() {
        return (String)this.getNode().getProperty(TYPE_NAME);
    }

    public static class TypeNodeDescriptor {
        public final DatabaseService db;
        public final String name;
        public final Class<?> claz;

        public TypeNodeDescriptor(DatabaseService db, String name, Class<?> claz) {
            this.db = db;
            this.name = name;
            this.claz = claz;
        }

        public void initialize(Node n) {
            if (this.name.startsWith("org.neo4j.collections.graphdb") || this.name.startsWith("ORG_NEO4J_COLLECTIONS_GRAPHDB")) {
                throw new RuntimeException("Type names should never start with org.neo4j.collections.graphdb or with ORG_NEO4J_COLLECTIONS_GRAPHDB");
            }
            n.setProperty(TYPE_NAME, (Object)this.name);
            n.setProperty(CLASS_NAME, (Object)this.claz.getName());
        }
    }

    public static enum RelTypes implements RelationshipType
    {
        ORG_NEO4J_COLLECTIONS_GRAPHDB_TYPE_SUBREF,
        ORG_NEO4J_COLLECTIONS_GRAPHDB_TYPE;

    }
}

