/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.indexedrelationship;

import java.util.Iterator;
import org.neo4j.collections.NodeCollection;
import org.neo4j.collections.NodeCollectionLoader;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class IndexedRelationship
implements Iterable<Relationship> {
    public static final String RELATIONSHIP_DIRECTION = "relationship_direction";
    public static final String RELATIONSHIP_TYPE = "relationship_type";
    private final Node indexedNode;
    private final RelationshipType relType;
    private final Direction direction;
    private NodeCollection nodeCollection;

    public IndexedRelationship(Node indexedNode, RelationshipType relType, Direction direction) {
        this.indexedNode = indexedNode;
        this.relType = relType;
        this.direction = direction;
        this.nodeCollection = this.getNodeCollection();
    }

    public IndexedRelationship(Node indexedNode, RelationshipType relType, Direction direction, NodeCollection nodeCollection) {
        this.indexedNode = indexedNode;
        this.relType = relType;
        this.direction = direction;
        this.create(nodeCollection);
    }

    public boolean exists() {
        return this.nodeCollection != null;
    }

    public void create(NodeCollection nodeCollection) {
        Relationship indexRelationship = this.indexedNode.createRelationshipTo(nodeCollection.getBaseNode(), (RelationshipType)RelationshipTypes.NODE_COLLECTION);
        indexRelationship.setProperty(RELATIONSHIP_TYPE, (Object)this.relType.name());
        indexRelationship.setProperty(RELATIONSHIP_DIRECTION, (Object)this.direction.name());
        this.nodeCollection = nodeCollection;
    }

    public Relationship createRelationshipTo(Node node) {
        Relationship keyValueRelationship = this.nodeCollection.addNode(node);
        if (!keyValueRelationship.hasProperty(RELATIONSHIP_DIRECTION)) {
            keyValueRelationship.setProperty(RELATIONSHIP_DIRECTION, (Object)this.direction.name());
        }
        if (!keyValueRelationship.hasProperty(RELATIONSHIP_TYPE)) {
            keyValueRelationship.setProperty(RELATIONSHIP_TYPE, (Object)this.relType.name());
        }
        return this.getRelationship(keyValueRelationship);
    }

    public Relationship getRelationship(Relationship relationship) {
        return new DirectRelationship(this.indexedNode, relationship);
    }

    public boolean removeRelationshipTo(Node node) {
        return this.nodeCollection.remove(node);
    }

    public Node getIndexedNode() {
        return this.indexedNode;
    }

    public RelationshipType getRelationshipType() {
        return this.relType;
    }

    @Override
    public Iterator<Relationship> iterator() {
        return new RelationshipIterator();
    }

    private NodeCollection getNodeCollection() {
        Relationship indexRelationship = null;
        for (Relationship candidateRelationship : this.indexedNode.getRelationships((RelationshipType)RelationshipTypes.NODE_COLLECTION, Direction.OUTGOING)) {
            String relName = (String)candidateRelationship.getProperty(RELATIONSHIP_TYPE, null);
            if (!this.relType.name().equals(relName)) continue;
            String dir = (String)candidateRelationship.getProperty(RELATIONSHIP_DIRECTION, null);
            if (!this.direction.name().equals(dir)) continue;
            if (indexRelationship != null) {
                throw new IllegalStateException("Multiple IndexedRelationship's on the given node with relationship type: " + this.relType.name() + " and direction: " + this.direction.name());
            }
            indexRelationship = candidateRelationship;
        }
        if (indexRelationship != null) {
            return NodeCollectionLoader.load(indexRelationship.getEndNode());
        }
        return null;
    }

    private class DirectRelationship
    implements Relationship {
        private final Node indexedNode;
        private final Relationship keyValueRelationship;

        DirectRelationship(Node indexedNode, Relationship keyValueRelationship) {
            this.indexedNode = indexedNode;
            this.keyValueRelationship = keyValueRelationship;
        }

        public GraphDatabaseService getGraphDatabase() {
            return this.indexedNode.getGraphDatabase();
        }

        public Object getProperty(String key) {
            return this.keyValueRelationship.getProperty(key);
        }

        public Object getProperty(String key, Object defaultValue) {
            return this.keyValueRelationship.getProperty(key, defaultValue);
        }

        public Iterable<String> getPropertyKeys() {
            return this.keyValueRelationship.getPropertyKeys();
        }

        @Deprecated
        public Iterable<Object> getPropertyValues() {
            return this.keyValueRelationship.getPropertyValues();
        }

        public boolean hasProperty(String key) {
            return this.keyValueRelationship.hasProperty(key);
        }

        public Object removeProperty(String key) {
            return this.keyValueRelationship.removeProperty(key);
        }

        public void setProperty(String key, Object value) {
            this.keyValueRelationship.setProperty(key, value);
        }

        public void delete() {
            IndexedRelationship.this.removeRelationshipTo(this.keyValueRelationship.getEndNode());
        }

        public Node getEndNode() {
            return IndexedRelationship.this.direction.equals((Object)Direction.OUTGOING) ? this.keyValueRelationship.getEndNode() : this.indexedNode;
        }

        public long getId() {
            throw new UnsupportedOperationException("Indexed relationships don't have an ID");
        }

        public Node[] getNodes() {
            Node[] nodes = new Node[]{this.getStartNode(), this.getEndNode()};
            return nodes;
        }

        public Node getOtherNode(Node node) {
            if (node.equals(this.indexedNode)) {
                return this.keyValueRelationship.getEndNode();
            }
            if (node.equals(this.keyValueRelationship.getEndNode())) {
                return this.indexedNode;
            }
            throw new RuntimeException("Node is neither the start nor the end node");
        }

        public Node getStartNode() {
            return IndexedRelationship.this.direction.equals((Object)Direction.OUTGOING) ? this.indexedNode : this.keyValueRelationship.getEndNode();
        }

        public RelationshipType getType() {
            return IndexedRelationship.this.relType;
        }

        public boolean isType(RelationshipType relType) {
            return relType.equals(IndexedRelationship.this.relType);
        }
    }

    private class RelationshipIterator
    implements Iterator<Relationship> {
        Iterator<Relationship> it;
        Relationship currentRelationship;

        private RelationshipIterator() {
            this.it = IndexedRelationship.this.nodeCollection.getValueRelationships().iterator();
            this.currentRelationship = null;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Relationship next() {
            this.currentRelationship = this.it.next();
            return IndexedRelationship.this.getRelationship(this.currentRelationship);
        }

        @Override
        public void remove() {
            if (this.currentRelationship != null) {
                IndexedRelationship.this.removeRelationshipTo(this.currentRelationship.getEndNode());
            }
        }
    }

    public static enum RelationshipTypes implements RelationshipType
    {
        NODE_COLLECTION;

    }
}

