/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.collections.GraphCollection;
import org.neo4j.collections.NodeCollection;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.transaction.LockType;

public class UnrolledLinkedList
implements NodeCollection {
    public static final String COMPARATOR_CLASS = "comparator_class";
    public static final String PAGE_SIZE = "page_size";
    public static final String MARGIN = "margin";
    public static final String ITEM_COUNT = "item_count";
    private final Node baseNode;
    private final Comparator<Node> nodeComparator;
    private final Comparator<Relationship> relationshipComparator;
    private final int pageSize;
    private final int margin;

    public UnrolledLinkedList(Node baseNode) {
        this.baseNode = baseNode;
        try {
            String comparatorClass = (String)baseNode.getProperty(COMPARATOR_CLASS);
            this.nodeComparator = (Comparator)Class.forName(comparatorClass).newInstance();
            this.relationshipComparator = new Comparator<Relationship>(){

                @Override
                public int compare(Relationship o1, Relationship o2) {
                    return UnrolledLinkedList.this.nodeComparator.compare(o1.getEndNode(), o2.getEndNode());
                }
            };
            this.pageSize = (Integer)baseNode.getProperty(PAGE_SIZE);
            this.margin = (Integer)baseNode.getProperty(MARGIN);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to re-instantiate UnrolledLinkedList from graph data structure.", e);
        }
    }

    public UnrolledLinkedList(GraphDatabaseService graphDb, Comparator<Node> nodeComparator, int pageSize) {
        this(graphDb, nodeComparator, pageSize, pageSize / 2);
    }

    public UnrolledLinkedList(GraphDatabaseService graphDb, final Comparator<Node> nodeComparator, int pageSize, int margin) {
        if (3 * margin < pageSize) {
            throw new IllegalArgumentException("Margin must be greater than a third of the page size.");
        }
        this.baseNode = graphDb.createNode();
        this.baseNode.setProperty("graph_collection_class", (Object)UnrolledLinkedList.class.getName());
        this.baseNode.setProperty(COMPARATOR_CLASS, (Object)nodeComparator.getClass().getName());
        this.baseNode.setProperty(PAGE_SIZE, (Object)pageSize);
        this.baseNode.setProperty(MARGIN, (Object)margin);
        this.nodeComparator = nodeComparator;
        this.relationshipComparator = new Comparator<Relationship>(){

            @Override
            public int compare(Relationship o1, Relationship o2) {
                return nodeComparator.compare(o1.getEndNode(), o2.getEndNode());
            }
        };
        this.pageSize = pageSize;
        this.margin = margin;
    }

    @Override
    public Relationship addNode(Node node) {
        this.acquireLock(LockType.WRITE);
        Node page = this.checkSplitNode(this.getPage(node), node);
        Relationship relationship = page.createRelationshipTo(node, (RelationshipType)GraphCollection.RelationshipTypes.VALUE);
        page.setProperty(ITEM_COUNT, (Object)((Integer)page.getProperty(ITEM_COUNT) + 1));
        return relationship;
    }

    @Override
    public Node getBaseNode() {
        return this.baseNode;
    }

    @Override
    public boolean remove(Node node) {
        Relationship nextPageRelationship;
        this.acquireLock(LockType.WRITE);
        Node page = this.getPage(node);
        do {
            for (Relationship relationship : page.getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
                Node candidate = relationship.getEndNode();
                if (!candidate.equals(node)) continue;
                relationship.delete();
                page.setProperty(ITEM_COUNT, (Object)((Integer)page.getProperty(ITEM_COUNT) - 1));
                this.checkJoinNode(page);
                return true;
            }
            nextPageRelationship = page.getSingleRelationship((RelationshipType)RelationshipTypes.NEXT_PAGE, Direction.OUTGOING);
            if (nextPageRelationship != null) continue;
            return false;
        } while (this.shouldContainNode(page = nextPageRelationship.getEndNode(), node));
        return false;
    }

    @Override
    public Iterator<Node> iterator() {
        this.acquireLock(LockType.READ);
        return new NodeIterator(this.getHead(false), this.nodeComparator);
    }

    @Override
    public Iterable<Relationship> getValueRelationships() {
        this.acquireLock(LockType.READ);
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return new RelationshipIterator(UnrolledLinkedList.this.getHead(false), UnrolledLinkedList.this.relationshipComparator);
            }
        };
    }

    private Node getHead(boolean createMissing) {
        Node head = null;
        Relationship relationship = this.baseNode.getSingleRelationship((RelationshipType)RelationshipTypes.HEAD, Direction.OUTGOING);
        if (relationship != null) {
            head = relationship.getEndNode();
        } else if (createMissing) {
            head = this.baseNode.getGraphDatabase().createNode();
            head.setProperty(ITEM_COUNT, (Object)0);
            this.baseNode.createRelationshipTo(head, (RelationshipType)RelationshipTypes.HEAD);
        }
        return head;
    }

    private Node getPage(Node node) {
        Node pageNode = this.getHead(true);
        while (!this.shouldContainNode(pageNode, node)) {
            Relationship nextPageRelationship = pageNode.getSingleRelationship((RelationshipType)RelationshipTypes.NEXT_PAGE, Direction.OUTGOING);
            if (nextPageRelationship == null) {
                return pageNode;
            }
            pageNode = nextPageRelationship.getEndNode();
        }
        return pageNode;
    }

    private boolean shouldContainNode(Node pageNode, Node node) {
        for (Relationship relationship : pageNode.getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
            Node valueNode = relationship.getEndNode();
            if (this.nodeComparator.compare(node, valueNode) > 0) continue;
            return true;
        }
        return false;
    }

    private Node checkSplitNode(Node candidatePage, Node node) {
        Relationship head;
        int count = (Integer)candidatePage.getProperty(ITEM_COUNT);
        if (count + 1 > this.pageSize + this.margin) {
            ArrayList<Relationship> relationships = this.getSortedRelationships(candidatePage);
            Node newPage = this.baseNode.getGraphDatabase().createNode();
            int moveCount = count / 2;
            this.moveFirstRelationships(relationships, newPage, moveCount);
            newPage.setProperty(ITEM_COUNT, (Object)moveCount);
            candidatePage.setProperty(ITEM_COUNT, (Object)(count - moveCount));
            Relationship previous = candidatePage.getSingleRelationship((RelationshipType)RelationshipTypes.NEXT_PAGE, Direction.INCOMING);
            if (previous != null) {
                Node previousNode = previous.getStartNode();
                previous.delete();
                previousNode.createRelationshipTo(newPage, (RelationshipType)RelationshipTypes.NEXT_PAGE);
            } else {
                Relationship head2 = candidatePage.getSingleRelationship((RelationshipType)RelationshipTypes.HEAD, Direction.INCOMING);
                if (head2 != null) {
                    head2.delete();
                    this.baseNode.createRelationshipTo(newPage, (RelationshipType)RelationshipTypes.HEAD);
                } else {
                    throw new IllegalStateException("Candidate node does not have incoming next page or head relationships");
                }
            }
            newPage.createRelationshipTo(candidatePage, (RelationshipType)RelationshipTypes.NEXT_PAGE);
            if (this.shouldContainNode(newPage, node)) {
                return newPage;
            }
        } else if (count + 1 > this.pageSize && (head = candidatePage.getSingleRelationship((RelationshipType)RelationshipTypes.HEAD, Direction.INCOMING)) != null) {
            boolean first = true;
            for (Relationship relationship : candidatePage.getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
                Node valueNode = relationship.getEndNode();
                if (this.nodeComparator.compare(node, valueNode) <= 0) continue;
                first = false;
                break;
            }
            if (first) {
                Node newHead = this.baseNode.getGraphDatabase().createNode();
                newHead.setProperty(ITEM_COUNT, (Object)0);
                head.delete();
                this.baseNode.createRelationshipTo(newHead, (RelationshipType)RelationshipTypes.HEAD);
                newHead.createRelationshipTo(candidatePage, (RelationshipType)RelationshipTypes.NEXT_PAGE);
                return newHead;
            }
        }
        return candidatePage;
    }

    private void checkJoinNode(Node candidatePage) {
        int count = (Integer)candidatePage.getProperty(ITEM_COUNT);
        Relationship head = candidatePage.getSingleRelationship((RelationshipType)RelationshipTypes.HEAD, Direction.INCOMING);
        if (head != null) {
            Relationship next;
            if (count == 0 && (next = candidatePage.getSingleRelationship((RelationshipType)RelationshipTypes.NEXT_PAGE, Direction.OUTGOING)) != null) {
                head.delete();
                candidatePage.delete();
                this.baseNode.createRelationshipTo(next.getEndNode(), (RelationshipType)RelationshipTypes.HEAD);
                next.delete();
            }
        } else if (count < this.pageSize - this.margin) {
            int nextCount;
            Relationship previousRelationship = candidatePage.getSingleRelationship((RelationshipType)RelationshipTypes.NEXT_PAGE, Direction.INCOMING);
            Relationship nextRelationship = candidatePage.getSingleRelationship((RelationshipType)RelationshipTypes.NEXT_PAGE, Direction.OUTGOING);
            Node previous = previousRelationship.getStartNode();
            Node next = nextRelationship != null ? nextRelationship.getEndNode() : null;
            int previousCount = (Integer)previous.getProperty(ITEM_COUNT);
            int n = nextCount = next != null ? (Integer)next.getProperty(ITEM_COUNT) : -1;
            if (count + previousCount <= this.pageSize + this.margin) {
                this.moveValueRelationships(candidatePage, previous);
                previous.setProperty(ITEM_COUNT, (Object)(previousCount + count));
                previousRelationship.delete();
                if (next != null) {
                    nextRelationship.delete();
                    previous.createRelationshipTo(next, (RelationshipType)RelationshipTypes.NEXT_PAGE);
                }
                candidatePage.delete();
            } else if (nextCount != -1 && count + nextCount <= this.pageSize + this.margin) {
                this.moveValueRelationships(candidatePage, next);
                next.setProperty(ITEM_COUNT, (Object)(nextCount + count));
                previousRelationship.delete();
                nextRelationship.delete();
                previous.createRelationshipTo(next, (RelationshipType)RelationshipTypes.NEXT_PAGE);
                candidatePage.delete();
            } else if (previousCount > nextCount) {
                ArrayList<Relationship> relationships = this.getSortedRelationships(previous);
                Collections.reverse(relationships);
                int moveCount = (previousCount + count) / 2 - count;
                this.moveFirstRelationships(relationships, candidatePage, moveCount);
                previous.setProperty(ITEM_COUNT, (Object)(previousCount - moveCount));
                candidatePage.setProperty(ITEM_COUNT, (Object)(count + moveCount));
            } else if (nextCount != -1) {
                ArrayList<Relationship> relationships = this.getSortedRelationships(next);
                int moveCount = (nextCount + count) / 2 - count;
                this.moveFirstRelationships(relationships, candidatePage, moveCount);
                next.setProperty(ITEM_COUNT, (Object)(nextCount - moveCount));
                candidatePage.setProperty(ITEM_COUNT, (Object)(count + moveCount));
            }
        }
    }

    private ArrayList<Relationship> getSortedRelationships(Node candidatePage) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (Relationship relationship : candidatePage.getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
            relationships.add(relationship);
        }
        Collections.sort(relationships, this.relationshipComparator);
        return relationships;
    }

    private void moveValueRelationships(Node candidatePage, Node previous) {
        for (Relationship valueRelationship : candidatePage.getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
            this.moveValueRelationship(valueRelationship, previous);
        }
    }

    private void moveFirstRelationships(ArrayList<Relationship> relationships, Node targetPage, int moveCount) {
        for (Relationship relationship : relationships) {
            this.moveValueRelationship(relationship, targetPage);
            if (--moveCount != 0) continue;
            break;
        }
    }

    private void moveValueRelationship(Relationship valueRelationship, Node targetPage) {
        Relationship newRelationship = targetPage.createRelationshipTo(valueRelationship.getEndNode(), (RelationshipType)GraphCollection.RelationshipTypes.VALUE);
        for (String key : valueRelationship.getPropertyKeys()) {
            newRelationship.setProperty(key, valueRelationship.getProperty(key));
        }
        valueRelationship.delete();
    }

    private void acquireLock(LockType lockType) {
        GraphDatabaseService graphDb = this.baseNode.getGraphDatabase();
        if (lockType == LockType.READ && graphDb instanceof AbstractGraphDatabase) {
            AbstractGraphDatabase graphDatabase = (AbstractGraphDatabase)this.baseNode.getGraphDatabase();
            graphDatabase.getLockManager().getReadLock((Object)this.baseNode);
            graphDatabase.getLockReleaser().addLockToTransaction((Object)this.baseNode, LockType.READ);
        } else {
            this.baseNode.removeProperty("___dummy_property_to_acquire_lock___");
        }
    }

    private static class RelationshipIterator
    extends ItemIterator<Relationship> {
        public RelationshipIterator(Node head, Comparator<Relationship> comparator) {
            super(head, comparator);
        }

        @Override
        protected Relationship getItem(Relationship relationship) {
            return relationship;
        }
    }

    private static class NodeIterator
    extends ItemIterator<Node> {
        public NodeIterator(Node head, Comparator<Node> comparator) {
            super(head, comparator);
        }

        @Override
        protected Node getItem(Relationship relationship) {
            return relationship.getEndNode();
        }
    }

    private static abstract class ItemIterator<T>
    implements Iterator<T> {
        private Node currentPage;
        private Comparator<T> itemComparator;
        private ArrayList<T> currentItems;
        private int position;
        private boolean hasNext;

        public ItemIterator(Node head, Comparator<T> comparator) {
            this.currentPage = head;
            this.itemComparator = comparator;
            boolean bl = this.hasNext = this.currentPage != null;
            if (this.hasNext) {
                this.populate();
                this.checkNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            T item = this.currentItems.get(this.position++);
            this.checkNext();
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void checkNext() {
            while (this.position == this.currentItems.size()) {
                Relationship nextPageRelationship = this.currentPage.getSingleRelationship((RelationshipType)RelationshipTypes.NEXT_PAGE, Direction.OUTGOING);
                if (nextPageRelationship != null) {
                    this.currentPage = nextPageRelationship.getEndNode();
                    this.populate();
                    continue;
                }
                this.hasNext = false;
                break;
            }
        }

        private void populate() {
            this.currentItems = new ArrayList();
            this.position = 0;
            for (Relationship relationship : this.currentPage.getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
                this.currentItems.add(this.getItem(relationship));
            }
            Collections.sort(this.currentItems, this.itemComparator);
        }

        protected abstract T getItem(Relationship var1);
    }

    private static enum RelationshipTypes implements RelationshipType
    {
        NEXT_PAGE,
        HEAD;

    }
}

