/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.rtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.collections.rtree.Envelope;
import org.neo4j.collections.rtree.EnvelopeDecoder;
import org.neo4j.collections.rtree.Listener;
import org.neo4j.collections.rtree.NullListener;
import org.neo4j.collections.rtree.RTreeRelationshipTypes;
import org.neo4j.collections.rtree.SpatialIndexRecordCounter;
import org.neo4j.collections.rtree.SpatialIndexVisitor;
import org.neo4j.collections.rtree.SpatialIndexWriter;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.collections.rtree.filter.SearchResults;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;

public class RTreeIndex
implements SpatialIndexWriter {
    private GraphDatabaseService database;
    private Node rootNode;
    private EnvelopeDecoder envelopeDecoder;
    private int maxNodeReferences;
    private Node metadataNode;
    private int totalGeometryCount = 0;
    private boolean countSaved = false;
    public static final String PROP_BBOX = "bbox";

    public RTreeIndex(GraphDatabaseService database, Node rootNode, EnvelopeDecoder envelopeEncoder) {
        this(database, rootNode, envelopeEncoder, 100);
    }

    public RTreeIndex(GraphDatabaseService database, Node rootNode, EnvelopeDecoder envelopeDecoder, int maxNodeReferences) {
        this.database = database;
        this.rootNode = rootNode;
        this.envelopeDecoder = envelopeDecoder;
        this.maxNodeReferences = maxNodeReferences;
        if (envelopeDecoder == null) {
            throw new NullPointerException("envelopeDecoder is NULL");
        }
        this.initIndexRoot();
        this.initIndexMetadata();
    }

    @Override
    public EnvelopeDecoder getEnvelopeDecoder() {
        return this.envelopeDecoder;
    }

    @Override
    public void add(Node geomNode) {
        Node parent = this.getIndexRoot();
        while (!this.nodeIsLeaf(parent)) {
            parent = this.chooseSubTree(parent, geomNode);
        }
        if (this.countChildren(parent, RTreeRelationshipTypes.RTREE_REFERENCE) == this.maxNodeReferences) {
            this.insertInLeaf(parent, geomNode);
            this.splitAndAdjustPathBoundingBox(parent);
        } else if (this.insertInLeaf(parent, geomNode)) {
            this.adjustPathBoundingBox(parent);
        }
        this.countSaved = false;
        ++this.totalGeometryCount;
    }

    @Override
    public void remove(long geomNodeId, boolean deleteGeomNode) {
        this.remove(geomNodeId, deleteGeomNode, true);
    }

    public void remove(long geomNodeId, boolean deleteGeomNode, boolean throwExceptionIfNotFound) {
        Node geomNode = this.database.getNodeById(geomNodeId);
        if (geomNode == null && !throwExceptionIfNotFound) {
            return;
        }
        Node indexNode = this.findLeafContainingGeometryNode(geomNode, throwExceptionIfNotFound);
        Relationship geometryRtreeReference = geomNode.getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.INCOMING);
        if (geometryRtreeReference != null) {
            geometryRtreeReference.delete();
        }
        if (deleteGeomNode) {
            this.deleteNode(geomNode);
        }
        if (this.countChildren(indexNode, RTreeRelationshipTypes.RTREE_REFERENCE) == 0) {
            indexNode = this.deleteEmptyTreeNodes(indexNode, RTreeRelationshipTypes.RTREE_REFERENCE);
            this.adjustParentBoundingBox(indexNode, RTreeRelationshipTypes.RTREE_CHILD);
        } else {
            this.adjustParentBoundingBox(indexNode, RTreeRelationshipTypes.RTREE_REFERENCE);
        }
        this.adjustPathBoundingBox(indexNode);
        this.countSaved = false;
        --this.totalGeometryCount;
    }

    private Node deleteEmptyTreeNodes(Node indexNode, RelationshipType relType) {
        if (this.countChildren(indexNode, relType) == 0) {
            Node parent = this.getIndexNodeParent(indexNode);
            if (parent != null) {
                indexNode.getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.INCOMING).delete();
                indexNode.delete();
                return this.deleteEmptyTreeNodes(parent, RTreeRelationshipTypes.RTREE_CHILD);
            }
            return indexNode;
        }
        return indexNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(final boolean deleteGeomNodes, final Listener monitor) {
        Node indexRoot = this.getIndexRoot();
        monitor.begin(this.count());
        try {
            this.visitInTx(new SpatialIndexVisitor(){

                @Override
                public boolean needsToVisit(Envelope indexNodeEnvelope) {
                    return true;
                }

                @Override
                public void onIndexReference(Node geomNode) {
                    geomNode.getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.INCOMING).delete();
                    if (deleteGeomNodes) {
                        RTreeIndex.this.deleteNode(geomNode);
                    }
                    monitor.worked(1);
                }
            }, indexRoot.getId());
        }
        finally {
            monitor.done();
        }
        Transaction tx = this.database.beginTx();
        try {
            indexRoot.getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_ROOT, Direction.INCOMING).delete();
            this.deleteRecursivelySubtree(indexRoot);
            Relationship metadataNodeRelationship = this.getRootNode().getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_METADATA, Direction.OUTGOING);
            Node metadataNode = metadataNodeRelationship.getEndNode();
            metadataNodeRelationship.delete();
            metadataNode.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
        this.countSaved = false;
        this.totalGeometryCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(Listener monitor) {
        this.removeAll(false, new NullListener());
        Transaction tx = this.database.beginTx();
        try {
            this.initIndexRoot();
            this.initIndexMetadata();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public Envelope getBoundingBox() {
        return this.getIndexNodeEnvelope(this.getIndexRoot());
    }

    @Override
    public int count() {
        this.saveCount();
        return this.totalGeometryCount;
    }

    @Override
    public boolean isEmpty() {
        Node indexRoot = this.getIndexRoot();
        return !indexRoot.hasProperty(PROP_BBOX);
    }

    @Override
    public boolean isNodeIndexed(Long geomNodeId) {
        Node geomNode = this.database.getNodeById(geomNodeId.longValue());
        return this.findLeafContainingGeometryNode(geomNode, false) != null;
    }

    public void warmUp() {
        this.visit(new WarmUpVisitor(), this.getIndexRoot());
    }

    public Iterable<Node> getAllIndexInternalNodes() {
        return this.getIndexRoot().traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING);
    }

    @Override
    public Iterable<Node> getAllIndexedNodes() {
        return new IndexNodeToGeometryNodeIterable(this.getAllIndexInternalNodes());
    }

    @Override
    public SearchResults searchIndex(SearchFilter filter) {
        SearchEvaluator searchEvaluator = new SearchEvaluator(filter);
        return new SearchResults((Iterable<Node>)this.getIndexRoot().traverse(Traverser.Order.DEPTH_FIRST, (StopEvaluator)searchEvaluator, (ReturnableEvaluator)searchEvaluator, (RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING, (RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.OUTGOING));
    }

    public void visit(SpatialIndexVisitor visitor, Node indexNode) {
        block4: {
            block3: {
                if (!visitor.needsToVisit(this.getIndexNodeEnvelope(indexNode))) {
                    return;
                }
                if (!indexNode.hasRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING)) break block3;
                for (Relationship rel : indexNode.getRelationships((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING)) {
                    Node child = rel.getEndNode();
                    this.visit(visitor, child);
                }
                break block4;
            }
            if (!indexNode.hasRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.OUTGOING)) break block4;
            for (Relationship rel : indexNode.getRelationships((RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.OUTGOING)) {
                visitor.onIndexReference(rel.getEndNode());
            }
        }
    }

    public Node getIndexRoot() {
        return this.getRootNode().getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_ROOT, Direction.OUTGOING).getEndNode();
    }

    private Envelope getChildNodeEnvelope(Node child, RelationshipType relType) {
        if (relType == RTreeRelationshipTypes.RTREE_REFERENCE) {
            return this.getLeafNodeEnvelope(child);
        }
        return this.getIndexNodeEnvelope(child);
    }

    private Envelope getLeafNodeEnvelope(Node geomNode) {
        return this.envelopeDecoder.decodeEnvelope((PropertyContainer)geomNode);
    }

    protected Envelope getIndexNodeEnvelope(Node indexNode) {
        if (indexNode == null) {
            indexNode = this.getIndexRoot();
        }
        if (!indexNode.hasProperty(PROP_BBOX)) {
            return null;
        }
        double[] bbox = (double[])indexNode.getProperty(PROP_BBOX);
        return new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitInTx(SpatialIndexVisitor visitor, Long indexNodeId) {
        Node indexNode = this.database.getNodeById(indexNodeId.longValue());
        if (!visitor.needsToVisit(this.getIndexNodeEnvelope(indexNode))) {
            return;
        }
        if (indexNode.hasRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING)) {
            ArrayList<Long> children = new ArrayList<Long>();
            for (Relationship rel : indexNode.getRelationships((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING)) {
                children.add(rel.getEndNode().getId());
            }
            for (Long child : children) {
                this.visitInTx(visitor, child);
            }
        } else if (indexNode.hasRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.OUTGOING)) {
            Transaction tx = this.database.beginTx();
            try {
                for (Relationship rel : indexNode.getRelationships((RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.OUTGOING)) {
                    visitor.onIndexReference(rel.getEndNode());
                }
                tx.success();
            }
            finally {
                tx.finish();
            }
        }
    }

    private void initIndexMetadata() {
        Node layerNode = this.getRootNode();
        if (layerNode.hasRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_METADATA, Direction.OUTGOING)) {
            this.metadataNode = layerNode.getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_METADATA, Direction.OUTGOING).getEndNode();
            this.maxNodeReferences = (Integer)this.metadataNode.getProperty("maxNodeReferences");
        } else {
            this.metadataNode = this.database.createNode();
            layerNode.createRelationshipTo(this.metadataNode, (RelationshipType)RTreeRelationshipTypes.RTREE_METADATA);
            this.metadataNode.setProperty("maxNodeReferences", (Object)this.maxNodeReferences);
        }
        this.saveCount();
    }

    private void initIndexRoot() {
        Node layerNode = this.getRootNode();
        if (!layerNode.hasRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_ROOT, Direction.OUTGOING)) {
            Node root = this.database.createNode();
            layerNode.createRelationshipTo(root, (RelationshipType)RTreeRelationshipTypes.RTREE_ROOT);
        }
    }

    private Node getMetadataNode() {
        if (this.metadataNode == null) {
            this.metadataNode = this.getRootNode().getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_METADATA, Direction.OUTGOING).getEndNode();
        }
        return this.metadataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCount() {
        if (this.totalGeometryCount == 0) {
            SpatialIndexRecordCounter counter = new SpatialIndexRecordCounter();
            this.visit(counter, this.getIndexRoot());
            this.totalGeometryCount = counter.getResult();
            this.countSaved = false;
        }
        if (!this.countSaved) {
            Transaction tx = this.database.beginTx();
            try {
                this.getMetadataNode().setProperty("totalGeometryCount", (Object)this.totalGeometryCount);
                this.countSaved = true;
                tx.success();
            }
            finally {
                tx.finish();
            }
        }
    }

    private boolean nodeIsLeaf(Node node) {
        return !node.hasRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING);
    }

    private Node chooseSubTree(Node parentIndexNode, Node geomRootNode) {
        ArrayList<Node> indexNodes = new ArrayList<Node>();
        Iterable relationships = parentIndexNode.getRelationships((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING);
        for (Relationship relation : relationships) {
            Node indexNode = relation.getEndNode();
            if (!this.getIndexNodeEnvelope(indexNode).contains(this.getLeafNodeEnvelope(geomRootNode))) continue;
            indexNodes.add(indexNode);
        }
        if (indexNodes.size() > 1) {
            return this.chooseIndexNodeWithSmallestArea(indexNodes);
        }
        if (indexNodes.size() == 1) {
            return (Node)indexNodes.get(0);
        }
        double minimumEnlargement = Double.POSITIVE_INFINITY;
        relationships = parentIndexNode.getRelationships((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING);
        for (Relationship relation : relationships) {
            Node indexNode = relation.getEndNode();
            double enlargementNeeded = this.getAreaEnlargement(indexNode, geomRootNode);
            if (enlargementNeeded < minimumEnlargement) {
                indexNodes.clear();
                indexNodes.add(indexNode);
                minimumEnlargement = enlargementNeeded;
                continue;
            }
            if (enlargementNeeded != minimumEnlargement) continue;
            indexNodes.add(indexNode);
        }
        if (indexNodes.size() > 1) {
            return this.chooseIndexNodeWithSmallestArea(indexNodes);
        }
        if (indexNodes.size() == 1) {
            return (Node)indexNodes.get(0);
        }
        throw new RuntimeException("No IndexNode found for new geometry");
    }

    private double getAreaEnlargement(Node indexNode, Node geomRootNode) {
        Envelope before = this.getIndexNodeEnvelope(indexNode);
        Envelope after = this.getLeafNodeEnvelope(geomRootNode);
        after.expandToInclude(before);
        return this.getArea(after) - this.getArea(before);
    }

    private Node chooseIndexNodeWithSmallestArea(List<Node> indexNodes) {
        Node result = null;
        double smallestArea = -1.0;
        for (Node indexNode : indexNodes) {
            double area = this.getArea(this.getIndexNodeEnvelope(indexNode));
            if (result != null && !(area < smallestArea)) continue;
            result = indexNode;
            smallestArea = area;
        }
        return result;
    }

    private int countChildren(Node indexNode, RelationshipType relationshipType) {
        int counter = 0;
        Iterator iterator = indexNode.getRelationships(relationshipType, Direction.OUTGOING).iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++counter;
        }
        return counter;
    }

    private boolean insertInLeaf(Node indexNode, Node geomRootNode) {
        return this.addChild(indexNode, RTreeRelationshipTypes.RTREE_REFERENCE, geomRootNode);
    }

    private void splitAndAdjustPathBoundingBox(Node indexNode) {
        Node newIndexNode = this.quadraticSplit(indexNode);
        Node parent = this.getIndexNodeParent(indexNode);
        if (parent == null) {
            this.createNewRoot(indexNode, newIndexNode);
        } else {
            this.expandParentBoundingBoxAfterNewChild(parent, (double[])indexNode.getProperty(PROP_BBOX));
            this.addChild(parent, RTreeRelationshipTypes.RTREE_CHILD, newIndexNode);
            if (this.countChildren(parent, RTreeRelationshipTypes.RTREE_CHILD) > this.maxNodeReferences) {
                this.splitAndAdjustPathBoundingBox(parent);
            } else {
                this.adjustPathBoundingBox(parent);
            }
        }
    }

    private Node quadraticSplit(Node indexNode) {
        if (this.nodeIsLeaf(indexNode)) {
            return this.quadraticSplit(indexNode, RTreeRelationshipTypes.RTREE_REFERENCE);
        }
        return this.quadraticSplit(indexNode, RTreeRelationshipTypes.RTREE_CHILD);
    }

    private Node quadraticSplit(Node indexNode, RelationshipType relationshipType) {
        ArrayList<Node> entries = new ArrayList<Node>();
        Iterable relationships = indexNode.getRelationships(relationshipType, Direction.OUTGOING);
        for (Relationship relationship : relationships) {
            entries.add(relationship.getEndNode());
            relationship.delete();
        }
        Node seed1 = null;
        Node seed2 = null;
        double worst = Double.NEGATIVE_INFINITY;
        for (Node e : entries) {
            Envelope eEnvelope = this.getChildNodeEnvelope(e, relationshipType);
            for (Node e1 : entries) {
                Envelope e1Envelope = this.getChildNodeEnvelope(e1, relationshipType);
                double deadSpace = this.getArea(RTreeIndex.createEnvelope(eEnvelope, e1Envelope)) - this.getArea(eEnvelope) - this.getArea(e1Envelope);
                if (!(deadSpace > worst)) continue;
                worst = deadSpace;
                seed1 = e;
                seed2 = e1;
            }
        }
        ArrayList<Node> group1 = new ArrayList<Node>();
        group1.add(seed1);
        Envelope group1envelope = this.getChildNodeEnvelope(seed1, relationshipType);
        ArrayList<Node> group2 = new ArrayList<Node>();
        group2.add(seed2);
        Envelope group2envelope = this.getChildNodeEnvelope(seed2, relationshipType);
        entries.remove(seed1);
        entries.remove(seed2);
        while (entries.size() > 0) {
            ArrayList<Node> bestGroup = null;
            Envelope bestGroupEnvelope = null;
            Node bestEntry = null;
            double expansionMin = Double.POSITIVE_INFINITY;
            for (Node e : entries) {
                double expansion2;
                Envelope nodeEnvelope = this.getChildNodeEnvelope(e, relationshipType);
                double expansion1 = this.getArea(RTreeIndex.createEnvelope(nodeEnvelope, group1envelope)) - this.getArea(group1envelope);
                if (expansion1 < (expansion2 = this.getArea(RTreeIndex.createEnvelope(nodeEnvelope, group2envelope)) - this.getArea(group2envelope)) && expansion1 < expansionMin) {
                    bestGroup = group1;
                    bestGroupEnvelope = group1envelope;
                    bestEntry = e;
                    expansionMin = expansion1;
                    continue;
                }
                if (expansion2 < expansion1 && expansion2 < expansionMin) {
                    bestGroup = group2;
                    bestGroupEnvelope = group2envelope;
                    bestEntry = e;
                    expansionMin = expansion2;
                    continue;
                }
                if (expansion1 != expansion2 || !(expansion1 < expansionMin)) continue;
                if (this.getArea(group1envelope) < this.getArea(group2envelope)) {
                    bestGroup = group1;
                    bestGroupEnvelope = group1envelope;
                } else {
                    bestGroup = group2;
                    bestGroupEnvelope = group2envelope;
                }
                bestEntry = e;
                expansionMin = expansion1;
            }
            bestGroup.add(bestEntry);
            bestGroupEnvelope.expandToInclude(this.getChildNodeEnvelope(bestEntry, relationshipType));
            entries.remove(bestEntry);
        }
        indexNode.removeProperty(PROP_BBOX);
        for (Node node : group1) {
            this.addChild(indexNode, relationshipType, node);
        }
        Node newIndexNode = this.database.createNode();
        for (Node node : group2) {
            this.addChild(newIndexNode, relationshipType, node);
        }
        return newIndexNode;
    }

    private void createNewRoot(Node oldRoot, Node newIndexNode) {
        Node newRoot = this.database.createNode();
        this.addChild(newRoot, RTreeRelationshipTypes.RTREE_CHILD, oldRoot);
        this.addChild(newRoot, RTreeRelationshipTypes.RTREE_CHILD, newIndexNode);
        Node layerNode = this.getRootNode();
        layerNode.getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_ROOT, Direction.OUTGOING).delete();
        layerNode.createRelationshipTo(newRoot, (RelationshipType)RTreeRelationshipTypes.RTREE_ROOT);
    }

    private boolean addChild(Node parent, RelationshipType type, Node newChild) {
        Envelope childEnvelope = this.getChildNodeEnvelope(newChild, type);
        double[] childBBox = new double[]{childEnvelope.getMinX(), childEnvelope.getMinY(), childEnvelope.getMaxX(), childEnvelope.getMaxY()};
        parent.createRelationshipTo(newChild, type);
        return this.expandParentBoundingBoxAfterNewChild(parent, childBBox);
    }

    private void adjustPathBoundingBox(Node indexNode) {
        Node parent = this.getIndexNodeParent(indexNode);
        if (parent != null && this.adjustParentBoundingBox(parent, RTreeRelationshipTypes.RTREE_CHILD)) {
            this.adjustPathBoundingBox(parent);
        }
    }

    private boolean adjustParentBoundingBox(Node indexNode, RelationshipType relationshipType) {
        double[] old = null;
        if (indexNode.hasProperty(PROP_BBOX)) {
            old = (double[])indexNode.getProperty(PROP_BBOX);
        }
        Envelope bbox = null;
        Iterator iterator = indexNode.getRelationships(relationshipType, Direction.OUTGOING).iterator();
        while (iterator.hasNext()) {
            Node childNode = ((Relationship)iterator.next()).getEndNode();
            if (bbox == null) {
                bbox = new Envelope(this.getChildNodeEnvelope(childNode, relationshipType));
                continue;
            }
            bbox.expandToInclude(this.getChildNodeEnvelope(childNode, relationshipType));
        }
        if (bbox == null) {
            bbox = new Envelope(0.0, 0.0, 0.0, 0.0);
        }
        if (old.length != 4 || bbox.getMinX() != old[0] || bbox.getMinY() != old[1] || bbox.getMaxX() != old[2] || bbox.getMaxY() != old[3]) {
            indexNode.setProperty(PROP_BBOX, (Object)new double[]{bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY()});
            return true;
        }
        return false;
    }

    private boolean expandParentBoundingBoxAfterNewChild(Node parent, double[] childBBox) {
        if (!parent.hasProperty(PROP_BBOX)) {
            parent.setProperty(PROP_BBOX, (Object)new double[]{childBBox[0], childBBox[1], childBBox[2], childBBox[3]});
            return true;
        }
        double[] parentBBox = (double[])parent.getProperty(PROP_BBOX);
        boolean valueChanged = this.setMin(parentBBox, childBBox, 0);
        valueChanged = this.setMin(parentBBox, childBBox, 1) || valueChanged;
        valueChanged = this.setMax(parentBBox, childBBox, 2) || valueChanged;
        boolean bl = valueChanged = this.setMax(parentBBox, childBBox, 3) || valueChanged;
        if (valueChanged) {
            parent.setProperty(PROP_BBOX, (Object)parentBBox);
        }
        return valueChanged;
    }

    private boolean setMin(double[] parent, double[] child, int index) {
        if (parent[index] > child[index]) {
            parent[index] = child[index];
            return true;
        }
        return false;
    }

    private boolean setMax(double[] parent, double[] child, int index) {
        if (parent[index] < child[index]) {
            parent[index] = child[index];
            return true;
        }
        return false;
    }

    private Node getIndexNodeParent(Node indexNode) {
        Relationship relationship = indexNode.getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.INCOMING);
        if (relationship == null) {
            return null;
        }
        return relationship.getStartNode();
    }

    private double getArea(Envelope e) {
        return e.getWidth() * e.getHeight();
    }

    private void deleteRecursivelySubtree(Node indexNode) {
        for (Relationship relationship : indexNode.getRelationships((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.OUTGOING)) {
            this.deleteRecursivelySubtree(relationship.getEndNode());
        }
        Relationship relationshipWithFather = indexNode.getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_CHILD, Direction.INCOMING);
        if (relationshipWithFather != null) {
            relationshipWithFather.delete();
        }
        indexNode.delete();
    }

    protected Node findLeafContainingGeometryNode(Node geomNode, boolean throwExceptionIfNotFound) {
        if (!geomNode.hasRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.INCOMING)) {
            if (throwExceptionIfNotFound) {
                throw new RuntimeException("GeometryNode not indexed with an RTree: " + geomNode.getId());
            }
            return null;
        }
        Node indexNodeLeaf = geomNode.getSingleRelationship((RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.INCOMING).getStartNode();
        Node root = null;
        Node child = indexNodeLeaf;
        while (root == null) {
            Node parent = this.getIndexNodeParent(child);
            if (parent == null) {
                root = child;
                continue;
            }
            child = parent;
        }
        if (root.getId() != this.getIndexRoot().getId()) {
            if (throwExceptionIfNotFound) {
                throw new RuntimeException("GeometryNode not indexed in this RTree: " + geomNode.getId());
            }
            return null;
        }
        return indexNodeLeaf;
    }

    private void deleteNode(Node node) {
        for (Relationship r : node.getRelationships()) {
            r.delete();
        }
        node.delete();
    }

    private Node getRootNode() {
        return this.rootNode;
    }

    private static Envelope createEnvelope(Envelope e, Envelope e1) {
        Envelope result = new Envelope(e);
        result.expandToInclude(e1);
        return result;
    }

    private class IndexNodeToGeometryNodeIterable
    implements Iterable<Node> {
        private Iterator<Node> allIndexNodeIterator;

        public IndexNodeToGeometryNodeIterable(Iterable<Node> allIndexNodes) {
            this.allIndexNodeIterator = allIndexNodes.iterator();
        }

        @Override
        public Iterator<Node> iterator() {
            return new GeometryNodeIterator();
        }

        private class GeometryNodeIterator
        implements Iterator<Node> {
            Iterator<Node> geometryNodeIterator = null;

            private GeometryNodeIterator() {
            }

            @Override
            public boolean hasNext() {
                this.checkGeometryNodeIterator();
                return this.geometryNodeIterator != null && this.geometryNodeIterator.hasNext();
            }

            @Override
            public Node next() {
                this.checkGeometryNodeIterator();
                return this.geometryNodeIterator == null ? null : this.geometryNodeIterator.next();
            }

            private void checkGeometryNodeIterator() {
                while ((this.geometryNodeIterator == null || !this.geometryNodeIterator.hasNext()) && IndexNodeToGeometryNodeIterable.this.allIndexNodeIterator.hasNext()) {
                    this.geometryNodeIterator = ((Node)IndexNodeToGeometryNodeIterable.this.allIndexNodeIterator.next()).traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.DEPTH_ONE, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)RTreeRelationshipTypes.RTREE_REFERENCE, Direction.OUTGOING).iterator();
                }
            }

            @Override
            public void remove() {
            }
        }
    }

    private class WarmUpVisitor
    implements SpatialIndexVisitor {
        private WarmUpVisitor() {
        }

        @Override
        public boolean needsToVisit(Envelope indexNodeEnvelope) {
            return true;
        }

        @Override
        public void onIndexReference(Node geomNode) {
        }
    }

    private class SearchEvaluator
    implements ReturnableEvaluator,
    StopEvaluator {
        private SearchFilter filter;
        private boolean isReturnableNode;
        private boolean isStopNode;

        public SearchEvaluator(SearchFilter filter) {
            this.filter = filter;
        }

        void checkPosition(TraversalPosition position) {
            Relationship rel = position.lastRelationshipTraversed();
            Node node = position.currentNode();
            if (rel == null) {
                this.isStopNode = false;
                this.isReturnableNode = false;
            } else if (rel.getType().equals((Object)RTreeRelationshipTypes.RTREE_CHILD)) {
                this.isReturnableNode = false;
                this.isStopNode = !this.filter.needsToVisit(RTreeIndex.this.getIndexNodeEnvelope(node));
            } else if (rel.getType().equals((Object)RTreeRelationshipTypes.RTREE_REFERENCE)) {
                this.isReturnableNode = this.filter.geometryMatches(node);
                this.isStopNode = true;
            }
        }

        public boolean isReturnableNode(TraversalPosition position) {
            this.checkPosition(position);
            return this.isReturnableNode;
        }

        public boolean isStopNode(TraversalPosition position) {
            this.checkPosition(position);
            return this.isStopNode;
        }
    }
}

