/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.rtree.filter;

import org.neo4j.collections.rtree.Envelope;
import org.neo4j.collections.rtree.EnvelopeDecoder;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;

public abstract class AbstractSearchEnvelopeIntersection
implements SearchFilter {
    protected EnvelopeDecoder decoder;
    protected Envelope referenceEnvelope;

    public AbstractSearchEnvelopeIntersection(EnvelopeDecoder decoder, Envelope referenceEnvelope) {
        this.decoder = decoder;
        this.referenceEnvelope = referenceEnvelope;
    }

    @Override
    public boolean needsToVisit(Envelope indexNodeEnvelope) {
        return indexNodeEnvelope.intersects(this.referenceEnvelope);
    }

    @Override
    public final boolean geometryMatches(Node geomNode) {
        Envelope geomEnvelope = this.decoder.decodeEnvelope((PropertyContainer)geomNode);
        if (geomEnvelope.intersects(this.referenceEnvelope)) {
            return this.onEnvelopeIntersection(geomNode, geomEnvelope);
        }
        return false;
    }

    public String toString() {
        return "SearchEnvelopeIntersection[" + this.referenceEnvelope + "]";
    }

    protected abstract boolean onEnvelopeIntersection(Node var1, Envelope var2);
}

