/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.graphdb.impl;

import java.util.ArrayList;
import org.neo4j.collections.graphdb.Connection;
import org.neo4j.collections.graphdb.ConnectionMode;
import org.neo4j.collections.graphdb.Connector;
import org.neo4j.collections.graphdb.ConnectorType;
import org.neo4j.collections.graphdb.DatabaseService;
import org.neo4j.collections.graphdb.EdgeType;
import org.neo4j.collections.graphdb.LeftRestrictedConnectionMode;
import org.neo4j.collections.graphdb.NullaryEdge;
import org.neo4j.collections.graphdb.Vertex;
import org.neo4j.collections.graphdb.impl.ConnectorTypeImpl;
import org.neo4j.collections.graphdb.impl.NullaryEdgeTypeImpl;
import org.neo4j.collections.graphdb.impl.VertexImpl;

public class NullaryEdgeImpl
extends VertexImpl
implements NullaryEdge {
    public NullaryEdgeImpl(DatabaseService db, Long id) {
        super(db, id);
    }

    @Override
    public void delete() {
        this.getNode().delete();
    }

    @Override
    public EdgeType getType() {
        return NullaryEdgeTypeImpl.getOrCreateInstance(this.getDb());
    }

    @Override
    public boolean isType(EdgeType relType) {
        return relType.getName().equals(this.getType().getName());
    }

    @Override
    public Iterable<Connector<?>> getConnectors() {
        ArrayList connectors = new ArrayList();
        connectors.add(Connector.getInstance(ConnectorTypeImpl.getOrCreateInstance(this.db, "NullaryConnector", this.getType().getNode(), ConnectionMode.BIJECTIVE), this));
        return connectors;
    }

    @Override
    public Iterable<Connector<?>> getConnectors(ConnectorType<?> ... connectorTypes) {
        ArrayList connectors = new ArrayList();
        for (ConnectorType<?> connectorType : connectorTypes) {
            if (!connectorType.getName().equals("NullaryConnector")) continue;
            connectors.add(Connector.getInstance(ConnectorTypeImpl.getOrCreateInstance(this.db, "NullaryConnector", this.getType().getNode(), ConnectionMode.BIJECTIVE), this));
        }
        return connectors;
    }

    @Override
    public <T extends ConnectionMode> Iterable<Vertex> getVertices(ConnectorType<T> connectorType) {
        return null;
    }

    public <U extends LeftRestrictedConnectionMode> Vertex getVertex(ConnectorType<U> connectorType) {
        return null;
    }

    @Override
    public <T extends ConnectionMode> Connector<T> getConnector(ConnectorType<T> connectorType) {
        return null;
    }

    @Override
    public <T extends ConnectionMode> Iterable<Connection<T>> getConnections(ConnectorType<T> connectorType) {
        return null;
    }
}

