/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.indexprovider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.collections.indexprovider.TimelineNodeIndex;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.MapUtil;

public class TimelineIndexProvider
extends IndexProvider {
    public static final String SERVICE_NAME = "graph-collections-timeline";
    public static final Map<String, String> CONFIG = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{"provider", "graph-collections-timeline"}));

    public TimelineIndexProvider() {
        super(SERVICE_NAME);
    }

    public IndexImplementation load(DependencyResolver dependencyResolver) throws Exception {
        GraphDatabaseService gds = (GraphDatabaseService)dependencyResolver.resolveDependency(GraphDatabaseService.class);
        return new TimelineIndexImplementation(gds);
    }

    static class TimelineIndexImplementation
    implements IndexImplementation {
        private GraphDatabaseService db;
        private Map<String, TimelineNodeIndex> indexes = new HashMap<String, TimelineNodeIndex>();

        public TimelineIndexImplementation(GraphDatabaseService db) {
            this.db = db;
        }

        public String getDataSourceName() {
            return "nioneodb";
        }

        public Index<Node> nodeIndex(String indexName, Map<String, String> config) {
            TimelineNodeIndex index = this.indexes.get(indexName);
            if (index == null) {
                index = new TimelineNodeIndex(indexName, this.db, config);
                this.indexes.put(indexName, index);
            }
            return index;
        }

        public RelationshipIndex relationshipIndex(String indexName, Map<String, String> config) {
            throw new UnsupportedOperationException("timeline relationship indexing is not supported at the moment. Please use the node index.");
        }

        public Map<String, String> fillInDefaults(Map<String, String> config) {
            return config;
        }

        public boolean configMatches(Map<String, String> config1, Map<String, String> config2) {
            return ((Object)config1).equals(config2);
        }
    }
}

