/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.sortedtree;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.neo4j.collections.NodeCollection;
import org.neo4j.collections.graphdb.PropertyComparator;
import org.neo4j.collections.sortedtree.NodeEntry;
import org.neo4j.collections.sortedtree.TreeNode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

public class SortedTree
implements NodeCollection {
    public static final String TREE_NAME = "tree_name";
    public static final String IS_UNIQUE_INDEX = "is_unique_index";
    public static final String COMPARATOR_CLASS = "comparator_class";
    private final Node baseNode;
    private final Comparator<Node> nodeComparator;
    private final String treeName;
    private final boolean isUniqueIndex;
    private TreeNode treeRoot;

    public SortedTree(Node baseNode) {
        this.baseNode = baseNode;
        try {
            Relationship rel = baseNode.getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.OUTGOING);
            String comparatorClass = (String)rel.getProperty(COMPARATOR_CLASS);
            this.nodeComparator = (Comparator)Class.forName(comparatorClass).newInstance();
            this.treeName = (String)rel.getProperty(TREE_NAME);
            this.isUniqueIndex = (Boolean)rel.getProperty(IS_UNIQUE_INDEX);
            this.treeRoot = new TreeNode(this, rel.getEndNode());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to re-instantiate SortedTree from graph data structure.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedTree(GraphDatabaseService graphDb, Comparator<Node> nodeComparator, boolean isUniqueIndex, String treeName) {
        if (graphDb == null) {
            throw new IllegalArgumentException("Graph Database must be provided when creating new SortedTree");
        }
        this.baseNode = graphDb.createNode();
        Transaction tx = graphDb.beginTx();
        try {
            Node rootNode = graphDb.createNode();
            Relationship treeRootRelationship = this.baseNode.createRelationshipTo(rootNode, (RelationshipType)RelTypes.TREE_ROOT);
            this.treeRoot = new TreeNode(this, rootNode);
            this.baseNode.setProperty("graph_collection_class", (Object)SortedTree.class.getName());
            treeRootRelationship.setProperty(TREE_NAME, (Object)treeName);
            treeRootRelationship.setProperty(IS_UNIQUE_INDEX, (Object)isUniqueIndex);
            treeRootRelationship.setProperty(COMPARATOR_CLASS, (Object)nodeComparator.getClass().getName());
            this.treeName = treeName;
            this.isUniqueIndex = isUniqueIndex;
            this.nodeComparator = nodeComparator;
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private void acquireLock() {
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        rel.getStartNode().removeProperty("___dummy_property_to_acquire_lock_____");
    }

    void makeRoot(TreeNode newRoot) {
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        Node startNode = rel.getStartNode();
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String key : rel.getPropertyKeys()) {
            props.put(key, rel.getProperty(key));
        }
        rel.delete();
        Relationship newRel = startNode.createRelationshipTo(newRoot.getUnderlyingNode(), (RelationshipType)RelTypes.TREE_ROOT);
        for (String key : props.keySet()) {
            newRel.setProperty(key, props.get(key));
        }
        this.treeRoot = newRoot;
    }

    public void delete() {
        this.acquireLock();
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        this.treeRoot.delete();
        rel.delete();
    }

    public void delete(int commitInterval) {
        this.acquireLock();
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        this.treeRoot.delete(commitInterval, 0);
        rel.delete();
    }

    @Override
    public Node getBaseNode() {
        return this.baseNode;
    }

    @Override
    public Relationship addNode(Node node) {
        this.acquireLock();
        return this.treeRoot.addEntry(node, true);
    }

    public boolean containsNode(Node node) {
        return this.treeRoot.containsEntry(node);
    }

    protected <T> boolean containsValue(T val, PropertyComparator<T> comp) {
        return this.treeRoot.containsValue(val, comp);
    }

    protected <T> Iterable<Node> getWithValue(T val, PropertyComparator<T> comp) {
        return this.treeRoot.getWithValue(val, comp);
    }

    @Override
    public boolean remove(Node node) {
        this.acquireLock();
        return this.treeRoot.removeEntry(node);
    }

    int getOrder() {
        return 25;
    }

    GraphDatabaseService getGraphDb() {
        return this.baseNode.getGraphDatabase();
    }

    String getTreeName() {
        return this.treeName;
    }

    TreeNode getTreeRoot() {
        return this.treeRoot;
    }

    public Comparator<Node> getComparator() {
        return this.nodeComparator;
    }

    public boolean isUniqueIndex() {
        return this.isUniqueIndex;
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeIterator(this.treeRoot);
    }

    @Override
    public Iterable<Relationship> getValueRelationships() {
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return new RelationshipIterator(SortedTree.this.treeRoot);
            }
        };
    }

    class RelationshipIterator
    implements Iterator<Relationship> {
        private TreeNode currentNode;
        NodeEntry entry = null;
        Iterator<Relationship> ni = null;
        RelationshipIterator bi = null;
        RelationshipIterator ai = null;
        int step = 0;

        RelationshipIterator(TreeNode currentNode) {
            this.initTreeNode(currentNode);
        }

        private void initTreeNode(TreeNode currentNode) {
            NodeEntry entry;
            this.currentNode = currentNode;
            NodeEntry nodeEntry = entry = this.currentNode == null ? null : currentNode.getFirstEntry();
            if (entry != null) {
                this.initEntry(entry);
            }
        }

        private void initEntry(NodeEntry nodeEntry) {
            this.entry = nodeEntry;
            TreeNode beforeTree = this.entry.getBeforeSubTree();
            if (beforeTree != null) {
                this.bi = new RelationshipIterator(beforeTree);
            }
            this.ni = this.entry.getRelationships().iterator();
        }

        private void initAfterEntry(NodeEntry entry) {
            TreeNode afterTree = entry.getAfterSubTree();
            if (afterTree != null) {
                this.ai = new RelationshipIterator(afterTree);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                if (this.bi != null && this.bi.hasNext()) {
                    return true;
                }
                return this.ni.hasNext();
            }
            return this.ai != null && this.ai.hasNext();
        }

        @Override
        public Relationship next() {
            if (this.bi != null && this.bi.hasNext()) {
                return this.bi.next();
            }
            if (this.ni.hasNext()) {
                Relationship n = this.ni.next();
                if (!this.ni.hasNext()) {
                    this.initAfterEntry(this.entry);
                    this.entry = this.entry.getNextKey();
                    if (this.entry != null) {
                        this.initEntry(this.entry);
                    }
                }
                return n;
            }
            if (this.ai.hasNext()) {
                return this.ai.next();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NodeIterator
    implements Iterator<Node> {
        private TreeNode currentNode;
        NodeEntry entry = null;
        Iterator<Node> ni = null;
        NodeIterator bi = null;
        NodeIterator ai = null;
        int step = 0;

        NodeIterator(TreeNode currentNode) {
            this.initTreeNode(currentNode);
        }

        private void initTreeNode(TreeNode currentNode) {
            NodeEntry entry;
            this.currentNode = currentNode;
            NodeEntry nodeEntry = entry = this.currentNode == null ? null : currentNode.getFirstEntry();
            if (entry != null) {
                this.initEntry(entry);
            }
        }

        private void initEntry(NodeEntry nodeEntry) {
            this.entry = nodeEntry;
            TreeNode beforeTree = this.entry.getBeforeSubTree();
            if (beforeTree != null) {
                this.bi = new NodeIterator(beforeTree);
            }
            this.ni = this.entry.getNodes().iterator();
        }

        private void initAfterEntry(NodeEntry entry) {
            TreeNode afterTree = entry.getAfterSubTree();
            if (afterTree != null) {
                this.ai = new NodeIterator(afterTree);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                if (this.bi != null && this.bi.hasNext()) {
                    return true;
                }
                return this.ni.hasNext();
            }
            return this.ai != null && this.ai.hasNext();
        }

        @Override
        public Node next() {
            if (this.bi != null && this.bi.hasNext()) {
                return this.bi.next();
            }
            if (this.ni.hasNext()) {
                Node n = this.ni.next();
                if (!this.ni.hasNext()) {
                    this.initAfterEntry(this.entry);
                    this.entry = this.entry.getNextKey();
                    if (this.entry != null) {
                        this.initEntry(this.entry);
                    }
                }
                return n;
            }
            if (this.ai.hasNext()) {
                return this.ai.next();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum RelTypes implements RelationshipType
    {
        TREE_ROOT,
        SUB_TREE,
        KEY_ENTRY,
        KEY_VALUE;

    }
}

