/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.sortedtree;

import java.util.ArrayList;
import java.util.Iterator;
import javax.transaction.Transaction;
import org.neo4j.collections.GraphCollection;
import org.neo4j.collections.graphdb.PropertyComparator;
import org.neo4j.collections.sortedtree.NodeEntry;
import org.neo4j.collections.sortedtree.SortedTree;
import org.neo4j.collections.sortedtree.TempRelationship;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.AbstractGraphDatabase;

class TreeNode {
    private SortedTree bTree;
    private Node treeNode;

    TreeNode(SortedTree bTree, Node underlyingNode) {
        this.bTree = bTree;
        this.treeNode = underlyingNode;
    }

    Node getUnderlyingNode() {
        return this.treeNode;
    }

    TreeNode getParent() {
        Relationship toParentNode = this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.INCOMING);
        if (toParentNode != null) {
            Node parentNode = toParentNode.getStartNode();
            Relationship prevEntry = parentNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
            while (prevEntry != null) {
                parentNode = prevEntry.getStartNode();
                prevEntry = parentNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
            }
            return new TreeNode(this.bTree, parentNode);
        }
        return null;
    }

    private Node disconnectFromParent() {
        Relationship toParentNode = this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.INCOMING);
        Node parentNode = toParentNode.getStartNode();
        toParentNode.delete();
        return parentNode;
    }

    private void connectToParent(Node parent) {
        assert (this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.INCOMING) == null);
        parent.createRelationshipTo(this.treeNode, (RelationshipType)SortedTree.RelTypes.SUB_TREE);
    }

    void delete() {
        NodeEntry entry;
        if (!this.isRoot()) {
            this.disconnectFromParent();
        }
        if ((entry = this.getFirstEntry()) == null) {
            this.getUnderlyingNode().delete();
            return;
        }
        TreeNode subTree = entry.getBeforeSubTree();
        if (subTree != null) {
            subTree.delete();
        }
        Node lastNode = null;
        while (entry != null) {
            subTree = entry.getAfterSubTree();
            if (subTree != null) {
                subTree.delete();
            }
            NodeEntry nextEntry = entry.getNextKey();
            lastNode = entry.getEndNode();
            entry.getStartNode().delete();
            Iterable rels = entry.getEndNode().getRelationships(new RelationshipType[]{GraphCollection.RelationshipTypes.VALUE});
            for (Relationship rel : rels) {
                rel.delete();
            }
            entry.getUnderlyingRelationship().delete();
            entry = nextEntry;
        }
        if (lastNode != null) {
            lastNode.delete();
        }
    }

    int delete(int commitInterval, int count) {
        NodeEntry entry;
        if (!this.isRoot()) {
            this.disconnectFromParent();
            ++count;
        }
        if ((entry = this.getFirstEntry()) == null) {
            this.getUnderlyingNode().delete();
            return count++;
        }
        TreeNode subTree = entry.getBeforeSubTree();
        if (subTree != null) {
            subTree.delete(commitInterval, count);
        }
        Node lastNode = null;
        while (entry != null) {
            subTree = entry.getAfterSubTree();
            if (subTree != null) {
                subTree.delete(commitInterval, count);
            }
            NodeEntry nextEntry = entry.getNextKey();
            lastNode = entry.getEndNode();
            entry.getStartNode().delete();
            entry.getUnderlyingRelationship().delete();
            ++count;
            entry = nextEntry;
        }
        if (lastNode != null) {
            lastNode.delete();
            ++count;
        }
        if (count >= commitInterval) {
            AbstractGraphDatabase graphDb = (AbstractGraphDatabase)this.bTree.getGraphDb();
            try {
                Transaction tx = graphDb.getTxManager().getTransaction();
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            graphDb.beginTx();
            count = 0;
        }
        return count;
    }

    NodeEntry getFirstEntry() {
        Relationship keyEntryRel = this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        assert (this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.INCOMING) == null);
        if (keyEntryRel != null) {
            return new NodeEntry(this, keyEntryRel);
        }
        return null;
    }

    NodeEntry getLastEntry() {
        Relationship keyEntryRel = this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        NodeEntry last = null;
        while (keyEntryRel != null) {
            last = new NodeEntry(this, keyEntryRel);
            keyEntryRel = keyEntryRel.getEndNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        }
        return last;
    }

    private int getEntryCount() {
        int entryCount = 0;
        for (NodeEntry entry = this.getFirstEntry(); entry != null; entry = entry.getNextKey()) {
            ++entryCount;
        }
        return entryCount;
    }

    Relationship addEntry(Node theNode, boolean ignoreIfExist) {
        int entryCount = 0;
        for (NodeEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            Node currentNode = keyEntry.getANode();
            if (this.bTree.getComparator().compare(theNode, currentNode) == 0) {
                if (this.getBTree().isUniqueIndex()) {
                    throw new RuntimeException("Attempt to add duplicate entry to unique index");
                }
                for (Relationship relationship : keyEntry.getRelationships()) {
                    if (!relationship.getEndNode().equals(theNode)) continue;
                    if (ignoreIfExist) {
                        return relationship;
                    }
                    throw new RuntimeException("Node already exist:" + theNode);
                }
                return keyEntry.addNode(theNode);
            }
            ++entryCount;
            if (this.bTree.getComparator().compare(theNode, currentNode) < 0) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.addEntry(theNode, ignoreIfExist);
                }
                for (NodeEntry entry = keyEntry.getNextKey(); entry != null; entry = entry.getNextKey()) {
                    ++entryCount;
                }
                Node blankNode = this.bTree.getGraphDb().createNode();
                NodeEntry nodeEntry = this.createEntry(keyEntry.getStartNode(), blankNode);
                Relationship keyValueRelationship = nodeEntry.addNode(theNode);
                keyEntry.move(this, blankNode, keyEntry.getEndNode());
                assert (++entryCount <= this.bTree.getOrder());
                if (this.bTree.getOrder() == entryCount) {
                    this.moveMiddleUp();
                }
                return keyValueRelationship;
            }
            if (keyEntry.getNextKey() != null) continue;
            TreeNode subTree = keyEntry.getAfterSubTree();
            if (subTree != null) {
                return subTree.addEntry(theNode, ignoreIfExist);
            }
            Node blankNode = this.bTree.getGraphDb().createNode();
            NodeEntry nodeEntry = this.createEntry(keyEntry.getEndNode(), blankNode);
            Relationship keyValueRelationship = nodeEntry.addNode(theNode);
            assert (++entryCount <= this.bTree.getOrder());
            if (this.bTree.getOrder() == entryCount) {
                this.moveMiddleUp();
            }
            return keyValueRelationship;
        }
        assert (this.isRoot());
        assert (!this.treeNode.getRelationships(new RelationshipType[]{SortedTree.RelTypes.SUB_TREE}).iterator().hasNext());
        Node blankNode = this.bTree.getGraphDb().createNode();
        return this.createEntry(this.treeNode, blankNode).addNode(theNode);
    }

    <T> Iterable<Node> getWithValue(T val, PropertyComparator<T> comp) {
        int entryCount = 0;
        for (NodeEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            Node currentNode = keyEntry.getANode();
            if (comp.compare(val, currentNode) == 0) {
                return keyEntry.getNodes();
            }
            ++entryCount;
            if (comp.compare(val, currentNode) < 0) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.getWithValue(val, comp);
                }
                return new EmptyNodeIterable();
            }
            if (keyEntry.getNextKey() != null) continue;
            TreeNode subTree = keyEntry.getAfterSubTree();
            if (subTree != null) {
                return subTree.getWithValue(val, comp);
            }
            return new EmptyNodeIterable();
        }
        return new EmptyNodeIterable();
    }

    <T> boolean containsValue(T val, PropertyComparator<T> comp) {
        int entryCount = 0;
        for (NodeEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            Node currentNode = keyEntry.getANode();
            if (comp.compare(val, currentNode) == 0) {
                return true;
            }
            ++entryCount;
            if (comp.compare(val, currentNode) < 0) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.containsValue(val, comp);
                }
                return false;
            }
            if (keyEntry.getNextKey() != null) continue;
            TreeNode subTree = keyEntry.getAfterSubTree();
            if (subTree != null) {
                return subTree.containsValue(val, comp);
            }
            return false;
        }
        return false;
    }

    boolean containsEntry(Node theNode) {
        int entryCount = 0;
        for (NodeEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            Node currentNode = keyEntry.getANode();
            if (this.bTree.getComparator().compare(theNode, currentNode) == 0) {
                for (Node entry : keyEntry.getNodes()) {
                    if (!entry.equals(theNode)) continue;
                    return true;
                }
                return false;
            }
            ++entryCount;
            if (this.bTree.getComparator().compare(theNode, currentNode) < 0) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.containsEntry(theNode);
                }
                return false;
            }
            if (keyEntry.getNextKey() != null) continue;
            TreeNode subTree = keyEntry.getAfterSubTree();
            if (subTree != null) {
                return subTree.containsEntry(theNode);
            }
            return false;
        }
        return false;
    }

    private NodeEntry createEntry(Node startNode, Node endNode, Node theNode) {
        NodeEntry newEntry = this.createEntry(startNode, endNode);
        newEntry.addNode(theNode);
        return newEntry;
    }

    private NodeEntry createEntry(Node startNode, Node endNode) {
        return new NodeEntry(this, startNode.createRelationshipTo(endNode, (RelationshipType)SortedTree.RelTypes.KEY_ENTRY));
    }

    boolean isRoot() {
        return this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.TREE_ROOT, Direction.INCOMING) != null;
    }

    private NodeEntry insertEntry(Iterable<Node> theNodes) {
        assert (theNodes.iterator().hasNext());
        Node theNode = theNodes.iterator().next();
        for (NodeEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            Node currentNode = keyEntry.getANode();
            assert (!currentNode.equals(theNode));
            if (this.bTree.getComparator().compare(theNode, currentNode) < 0) {
                Node blankNode = this.bTree.getGraphDb().createNode();
                NodeEntry newEntry = this.createEntry(keyEntry.getStartNode(), blankNode);
                for (Node n : theNodes) {
                    newEntry.addNode(n);
                }
                keyEntry.move(this, blankNode, keyEntry.getEndNode());
                return newEntry;
            }
            if (keyEntry.getNextKey() != null) continue;
            Node blankNode = this.bTree.getGraphDb().createNode();
            return this.createEntry(keyEntry.getEndNode(), blankNode, theNode);
        }
        Node blankNode = this.bTree.getGraphDb().createNode();
        return this.createEntry(this.treeNode, blankNode, theNode);
    }

    private void moveMiddleUp() {
        TreeNode parent = this.getParent();
        if (parent == null) {
            assert (this.isRoot());
            parent = new TreeNode(this.bTree, this.bTree.getGraphDb().createNode());
            this.bTree.makeRoot(parent);
        } else {
            this.disconnectFromParent();
        }
        NodeEntry middleEntry = this.getFirstEntry();
        for (int i = 0; i < this.bTree.getOrder() / 2; ++i) {
            middleEntry = middleEntry.getNextKey();
        }
        TreeNode newTreeToTheRight = new TreeNode(this.bTree, middleEntry.getEndNode());
        NodeEntry movedMiddleEntry = parent.insertEntry(middleEntry.getNodes());
        Iterable valueRelations = middleEntry.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING);
        for (Relationship rel : valueRelations) {
            rel.delete();
        }
        middleEntry.getUnderlyingRelationship().delete();
        movedMiddleEntry.getStartNode().createRelationshipTo(this.getUnderlyingNode(), (RelationshipType)SortedTree.RelTypes.SUB_TREE);
        movedMiddleEntry.getEndNode().createRelationshipTo(newTreeToTheRight.getUnderlyingNode(), (RelationshipType)SortedTree.RelTypes.SUB_TREE);
        int parentEntryCount = parent.getEntryCount();
        if (parentEntryCount == this.bTree.getOrder()) {
            parent.moveMiddleUp();
        }
        assert (parent.getEntryCount() <= this.bTree.getOrder());
    }

    public boolean removeEntry(Node theNode) {
        NodeEntry entry = null;
        NodeEntry keyEntry = this.getFirstEntry();
        if (keyEntry == null) {
            return false;
        }
        int entryCount = 0;
        block0: while (keyEntry != null) {
            TreeNode subTree;
            ++entryCount;
            Node currentNode = keyEntry.getANode();
            if (this.bTree.getComparator().compare(theNode, currentNode) == 0) {
                for (Node lookupEntry : keyEntry.getNodes()) {
                    if (!lookupEntry.equals(theNode)) continue;
                    entry = keyEntry;
                    for (keyEntry = keyEntry.getNextKey(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
                        ++entryCount;
                    }
                    break block0;
                }
            }
            if (this.bTree.getComparator().compare(theNode, currentNode) < 0) {
                subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.removeEntry(theNode);
                }
                return false;
            }
            if (keyEntry.getNextKey() == null) {
                subTree = keyEntry.getAfterSubTree();
                if (subTree != null) {
                    return subTree.removeEntry(theNode);
                }
                return false;
            }
            keyEntry = keyEntry.getNextKey();
        }
        assert (entry != null);
        Iterable entryRels = entry.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING);
        for (Relationship entryRel : entryRels) {
            if (entryRel.getEndNode().getId() != theNode.getId()) continue;
            entryRel.delete();
        }
        if (!entry.getEndNode().hasRelationship((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
            if (entry.isLeaf()) {
                NodeEntry nextEntry = entry.getNextKey();
                if (nextEntry != null) {
                    nextEntry.move(this, entry.getStartNode(), nextEntry.getEndNode());
                }
                entry.getUnderlyingRelationship().delete();
                entry.getEndNode().delete();
                if (--entryCount < this.bTree.getOrder() / 2 && !this.isRoot()) {
                    this.tryBorrowFromSibling();
                }
            } else {
                NodeEntry successor = entry.getAfterSubTree().getFirstEntry();
                while (!successor.isLeaf()) {
                    successor = successor.getBeforeSubTree().getFirstEntry();
                }
                TreeNode leafTree = successor.getTreeNode();
                NodeEntry next = successor.getNextKey();
                next.move(leafTree, successor.getStartNode(), next.getEndNode());
                successor.move(this, entry.getStartNode(), entry.getEndNode());
                entry.getUnderlyingRelationship().delete();
                entryCount = leafTree.getEntryCount();
                if (entryCount < this.bTree.getOrder() / 2 && !leafTree.isRoot()) {
                    leafTree.tryBorrowFromSibling();
                }
            }
        }
        return true;
    }

    private void tryBorrowFromSibling() {
        TreeNode leftSibling = this.getLeftSibbling();
        TreeNode rightSibling = this.getRightSibbling();
        if (leftSibling != null && leftSibling.getEntryCount() > this.bTree.getOrder() / 2) {
            this.borrowFromLeftSibling(leftSibling);
        } else if (rightSibling != null && rightSibling.getEntryCount() > this.bTree.getOrder() / 2) {
            this.borrowFromRightSibling(rightSibling);
        } else if (leftSibling != null) {
            this.mergeWithLeftSibling(leftSibling);
        } else if (rightSibling != null) {
            this.mergeWithRightSibling(rightSibling);
        } else {
            throw new RuntimeException();
        }
    }

    private void borrowFromLeftSibling(TreeNode leftSibling) {
        TreeNode parentNode = this.getParent();
        NodeEntry entryToMoveDown = new NodeEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.INCOMING));
        NodeEntry entryToMoveUp = leftSibling.getLastEntry();
        TreeNode subTree = entryToMoveUp.getAfterSubTree();
        if (subTree != null) {
            subTree.disconnectFromParent();
        }
        entryToMoveUp.getEndNode().delete();
        ArrayList<TempRelationship> nl1 = new ArrayList<TempRelationship>();
        for (Relationship rel : entryToMoveDown.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
            nl1.add(new TempRelationship(rel));
            rel.delete();
        }
        entryToMoveUp.move(parentNode, entryToMoveDown.getStartNode(), entryToMoveDown.getEndNode());
        ArrayList<TempRelationship> nl2 = new ArrayList<TempRelationship>();
        for (Relationship rel : entryToMoveDown.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
            nl2.add(new TempRelationship(rel));
            rel.delete();
        }
        for (TempRelationship trl : nl1) {
            Relationship rel = entryToMoveDown.getEndNode().createRelationshipTo(trl.getEndNode(), (RelationshipType)GraphCollection.RelationshipTypes.VALUE);
            for (String key : trl.getProperties().keySet()) {
                rel.setProperty(key, trl.getProperties().get(key));
            }
        }
        Node newStartNode = this.bTree.getGraphDb().createNode();
        Node oetmd = entryToMoveDown.getEndNode();
        entryToMoveDown.move(this, newStartNode, this.treeNode);
        for (TempRelationship trl : nl2) {
            Relationship rel = oetmd.createRelationshipTo(trl.getEndNode(), (RelationshipType)GraphCollection.RelationshipTypes.VALUE);
            for (String key : trl.getProperties().keySet()) {
                rel.setProperty(key, trl.getProperties().get(key));
            }
        }
        Node parentToReAttachTo = this.disconnectFromParent();
        this.treeNode = newStartNode;
        this.connectToParent(parentToReAttachTo);
        if (subTree != null) {
            subTree.connectToParent(newStartNode);
        }
    }

    private void borrowFromRightSibling(TreeNode rightSibling) {
        TreeNode parentNode = this.getParent();
        NodeEntry entryToMoveDown = new NodeEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.OUTGOING));
        NodeEntry entryToMoveUp = rightSibling.getFirstEntry();
        TreeNode subTree = entryToMoveUp.getBeforeSubTree();
        if (subTree != null) {
            subTree.disconnectFromParent();
        }
        Node rightParentToReAttachTo = rightSibling.disconnectFromParent();
        rightSibling.treeNode = entryToMoveUp.getEndNode();
        rightSibling.connectToParent(rightParentToReAttachTo);
        entryToMoveUp.getStartNode().delete();
        ArrayList<TempRelationship> nl1 = new ArrayList<TempRelationship>();
        for (Relationship rel : entryToMoveDown.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
            nl1.add(new TempRelationship(rel));
            rel.delete();
        }
        entryToMoveUp.move(parentNode, entryToMoveDown.getStartNode(), entryToMoveDown.getEndNode());
        ArrayList<TempRelationship> nl2 = new ArrayList<TempRelationship>();
        for (Relationship rel : entryToMoveDown.getEndNode().getRelationships((RelationshipType)GraphCollection.RelationshipTypes.VALUE, Direction.OUTGOING)) {
            nl2.add(new TempRelationship(rel));
            rel.delete();
        }
        for (TempRelationship trl : nl1) {
            Relationship rel = entryToMoveDown.getEndNode().createRelationshipTo(trl.getEndNode(), (RelationshipType)GraphCollection.RelationshipTypes.VALUE);
            for (String key : trl.getProperties().keySet()) {
                rel.setProperty(key, trl.getProperties().get(key));
            }
        }
        Node newLastNode = this.bTree.getGraphDb().createNode();
        Node oetmd = entryToMoveDown.getEndNode();
        entryToMoveDown.move(this, this.getLastEntry().getEndNode(), newLastNode);
        for (TempRelationship trl : nl2) {
            Relationship rel = oetmd.createRelationshipTo(trl.getEndNode(), (RelationshipType)GraphCollection.RelationshipTypes.VALUE);
            for (String key : trl.getProperties().keySet()) {
                rel.setProperty(key, trl.getProperties().get(key));
            }
        }
        if (subTree != null) {
            subTree.connectToParent(newLastNode);
        }
    }

    private void mergeWithLeftSibling(TreeNode leftSibling) {
        int entryCount;
        NodeEntry entry;
        TreeNode subTree;
        TreeNode parentNode = this.getParent();
        NodeEntry entryToMoveDown = new NodeEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.INCOMING));
        NodeEntry nextParentEntry = entryToMoveDown.getNextKey();
        if (nextParentEntry != null) {
            nextParentEntry.move(parentNode, entryToMoveDown.getStartNode(), nextParentEntry.getEndNode());
        }
        if ((subTree = (entry = this.getFirstEntry()).getBeforeSubTree()) != null) {
            subTree.disconnectFromParent();
        }
        this.disconnectFromParent();
        entryToMoveDown.getEndNode().delete();
        Node blankNode = this.bTree.getGraphDb().createNode();
        entryToMoveDown.move(leftSibling, leftSibling.getLastEntry().getEndNode(), blankNode);
        entry.getStartNode().delete();
        entry.move(leftSibling, blankNode, entry.getEndNode());
        this.treeNode = leftSibling.treeNode;
        if (subTree != null) {
            subTree.connectToParent(blankNode);
        }
        if ((entryCount = parentNode.getEntryCount()) < this.bTree.getOrder() / 2 && !parentNode.isRoot()) {
            assert (entryCount > 0);
            parentNode.tryBorrowFromSibling();
        } else if (entryCount == 0) {
            assert (parentNode.isRoot());
            this.disconnectFromParent();
            this.bTree.makeRoot(this);
        }
    }

    private void mergeWithRightSibling(TreeNode rightSibling) {
        int entryCount;
        NodeEntry entry;
        TreeNode subTree;
        TreeNode parentNode = this.getParent();
        NodeEntry entryToMoveDown = new NodeEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.OUTGOING));
        NodeEntry nextInParent = entryToMoveDown.getNextKey();
        if (nextInParent != null) {
            nextInParent.move(parentNode, entryToMoveDown.getStartNode(), nextInParent.getEndNode());
        }
        if ((subTree = (entry = rightSibling.getFirstEntry()).getBeforeSubTree()) != null) {
            subTree.disconnectFromParent();
        }
        rightSibling.disconnectFromParent();
        entryToMoveDown.getEndNode().delete();
        Node blankNode = this.bTree.getGraphDb().createNode();
        entryToMoveDown.move(this, this.getLastEntry().getEndNode(), blankNode);
        entry.getStartNode().delete();
        entry.move(this, blankNode, entry.getEndNode());
        rightSibling.treeNode = this.treeNode;
        if (subTree != null) {
            subTree.connectToParent(blankNode);
        }
        if ((entryCount = parentNode.getEntryCount()) < this.bTree.getOrder() / 2 && !parentNode.isRoot()) {
            assert (entryCount > 0);
            parentNode.tryBorrowFromSibling();
        } else if (entryCount == 0) {
            assert (parentNode.isRoot());
            this.disconnectFromParent();
            this.bTree.makeRoot(this);
        }
    }

    TreeNode getLeftSibbling() {
        Relationship parent = this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.INCOMING);
        if (parent == null) {
            return null;
        }
        Relationship prevEntry = parent.getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
        if (prevEntry == null) {
            return null;
        }
        return new TreeNode(this.getBTree(), prevEntry.getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.OUTGOING).getEndNode());
    }

    TreeNode getRightSibbling() {
        Relationship parent = this.treeNode.getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.INCOMING);
        if (parent == null) {
            return null;
        }
        Relationship nextEntry = parent.getStartNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        if (nextEntry == null) {
            return null;
        }
        return new TreeNode(this.getBTree(), nextEntry.getEndNode().getSingleRelationship((RelationshipType)SortedTree.RelTypes.SUB_TREE, Direction.OUTGOING).getEndNode());
    }

    SortedTree getBTree() {
        return this.bTree;
    }

    private class EmptyNodeIterator
    implements Iterator<Node> {
        private EmptyNodeIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Node next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    private class EmptyNodeIterable
    implements Iterable<Node> {
        private EmptyNodeIterable() {
        }

        @Override
        public Iterator<Node> iterator() {
            return new EmptyNodeIterator();
        }
    }
}

