/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.impl.transaction.LockType;

public abstract class Locker {
    public static Locker getInstance(GraphDatabaseService graphDatabaseService) {
        try {
            return Locker.newLockerInstance("Neo4j19Locker", graphDatabaseService);
        }
        catch (Exception exception) {
            return Locker.newLockerInstance("Neo4j18Locker", graphDatabaseService);
        }
    }

    private static Locker newLockerInstance(String subClass, GraphDatabaseService graphDatabaseService) {
        try {
            return (Locker)Class.forName("org.neo4j.kernel.impl.transaction." + subClass).getConstructor(GraphDatabaseService.class).newInstance(graphDatabaseService);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Locker " + subClass, e);
        }
    }

    public abstract void acquireLock(LockType var1, PropertyContainer var2);
}

