/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;

@PublicApi
public interface Relationship
extends Entity {
    public Node getStartNode();

    public Node getEndNode();

    public Node getOtherNode(Node var1);

    public Node[] getNodes();

    public RelationshipType getType();

    public boolean isType(RelationshipType var1);

    @Deprecated(since="5.0", forRemoval=true)
    default public long getStartNodeId() {
        return this.getStartNode().getId();
    }

    @Deprecated(since="5.0", forRemoval=true)
    default public long getEndNodeId() {
        return this.getEndNode().getId();
    }

    @Deprecated(since="5.0", forRemoval=true)
    default public long getOtherNodeId(long id) {
        long start = this.getStartNodeId();
        long end = this.getEndNodeId();
        if (id == start) {
            return end;
        }
        if (id == end) {
            return start;
        }
        throw new NotFoundException("Node[" + id + "] not connected to this relationship[" + this.getId() + "]");
    }
}

