/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.api;

import java.util.List;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.dbms.api.DatabaseAliasExistsException;
import org.neo4j.dbms.api.DatabaseExistsException;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.TransactionEventListener;

@PublicApi
public interface DatabaseManagementService
extends AutoCloseable {
    public GraphDatabaseService database(String var1) throws DatabaseNotFoundException;

    default public void createDatabase(String databaseName) throws DatabaseExistsException {
        this.createDatabase(databaseName, Configuration.EMPTY);
    }

    public void createDatabase(String var1, Configuration var2) throws DatabaseExistsException;

    public void dropDatabase(String var1) throws DatabaseNotFoundException, DatabaseAliasExistsException;

    public void startDatabase(String var1) throws DatabaseNotFoundException;

    public void shutdownDatabase(String var1) throws DatabaseNotFoundException;

    public List<String> listDatabases();

    public void registerDatabaseEventListener(DatabaseEventListener var1);

    public void unregisterDatabaseEventListener(DatabaseEventListener var1);

    public void registerTransactionEventListener(String var1, TransactionEventListener<?> var2);

    public void unregisterTransactionEventListener(String var1, TransactionEventListener<?> var2);

    public void shutdown();

    @Override
    default public void close() {
        this.shutdown();
    }
}

