/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class WriteOperationsNotAllowedException
extends GqlRuntimeException
implements Status.HasStatus {
    private final Status statusCode;
    public static final String NOT_LEADER_ERROR_MSG = "No write operations are allowed directly on this database. Writes must pass through the leader. The role of this server is: %s";

    @Deprecated
    public WriteOperationsNotAllowedException(String message, Status statusCode) {
        super(message);
        this.statusCode = statusCode;
    }

    public WriteOperationsNotAllowedException(ErrorGqlStatusObject gqlStatusObject, String message, Status statusCode) {
        super(gqlStatusObject, message);
        this.statusCode = statusCode;
    }

    public static WriteOperationsNotAllowedException notALeader(String currentRole) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N07).build();
        return new WriteOperationsNotAllowedException(gql, String.format(NOT_LEADER_ERROR_MSG, currentRole), (Status)Status.Cluster.NotALeader);
    }

    public Status status() {
        return this.statusCode;
    }
}

