/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql;

import graphql.language.Description;
import graphql.language.VariableReference;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.GraphQLExtensionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a#\u0010\u0000\u001a\u00020\u00012\u0016\u0010\u0002\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0003\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0004\u001a1\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0016\u0010\u0002\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0003\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\t\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0001\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0001\u001a\u001d\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001a\u00a2\u0006\u0002\u0010\u001b\u001a\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a8\u0006!"}, d2={"normalizeName", "", "parts", "", "([Ljava/lang/String;)Ljava/lang/String;", "queryParameter", "Lorg/neo4j/cypherdsl/core/Parameter;", "value", "", "(Ljava/lang/Object;[Ljava/lang/String;)Lorg/neo4j/cypherdsl/core/Parameter;", "asDescription", "Lgraphql/language/Description;", "capitalize", "collect", "Lorg/neo4j/cypherdsl/core/Expression;", "type", "Lgraphql/schema/GraphQLOutputType;", "decapitalize", "id", "Lorg/neo4j/cypherdsl/core/FunctionInvocation;", "Lorg/neo4j/cypherdsl/core/PropertyContainer;", "toCamelCase", "toLowerCase", "toUpperCase", "unwrap", "T", "Ljava/util/Optional;", "(Ljava/util/Optional;)Ljava/lang/Object;", "withSubQueries", "Lorg/neo4j/cypherdsl/core/StatementBuilder$OngoingReading;", "subQueries", "", "Lorg/neo4j/cypherdsl/core/Statement;", "neo4j-graphql-java"})
@SourceDebugExtension(value={"SMAP\nExtensionFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionFunctions.kt\norg/neo4j/graphql/ExtensionFunctionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1789#2,3:41\n766#2:57\n857#2,2:58\n11383#3,9:44\n13309#3:53\n13310#3:55\n11392#3:56\n1#4:54\n1#4:60\n*S KotlinDebug\n*F\n+ 1 ExtensionFunctions.kt\norg/neo4j/graphql/ExtensionFunctionsKt\n*L\n20#1:41,3\n22#1:57\n22#1:58,2\n22#1:44,9\n22#1:53\n22#1:55\n22#1:56\n22#1:54\n*E\n"})
public final class ExtensionFunctionsKt {
    @NotNull
    public static final Parameter<?> queryParameter(@Nullable Object value, String ... parts) {
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        String name = value instanceof VariableReference ? ((VariableReference)value).getName() : ExtensionFunctionsKt.normalizeName(Arrays.copyOf(parts, parts.length));
        Object object = value;
        Parameter parameter = Cypher.parameter((String)name).withValue(object != null ? GraphQLExtensionsKt.toJavaValue(object) : null);
        Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"withValue(...)");
        return parameter;
    }

    @NotNull
    public static final Expression collect(@NotNull Expression $this$collect, @NotNull GraphQLOutputType type) {
        Expression expression;
        Intrinsics.checkNotNullParameter((Object)$this$collect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (GraphQLExtensionsKt.isList((GraphQLType)type)) {
            FunctionInvocation functionInvocation = Cypher.collect((Expression)$this$collect);
            Intrinsics.checkNotNullExpressionValue((Object)functionInvocation, (String)"collect(...)");
            expression = (Expression)functionInvocation;
        } else {
            expression = $this$collect;
        }
        return expression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final StatementBuilder.OngoingReading withSubQueries(@NotNull StatementBuilder.OngoingReading $this$withSubQueries, @NotNull List<? extends Statement> subQueries) {
        Intrinsics.checkNotNullParameter((Object)$this$withSubQueries, (String)"<this>");
        Intrinsics.checkNotNullParameter(subQueries, (String)"subQueries");
        Iterable $this$fold$iv = subQueries;
        boolean $i$f$fold = false;
        StatementBuilder.OngoingReading accumulator$iv = $this$withSubQueries;
        for (Object element$iv : $this$fold$iv) {
            void sub;
            Statement statement = (Statement)element$iv;
            StatementBuilder.OngoingReading it = accumulator$iv;
            boolean bl = false;
            StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere = it.call((Statement)sub);
            Intrinsics.checkNotNullExpressionValue((Object)ongoingReadingWithoutWhere, (String)"call(...)");
            accumulator$iv = (StatementBuilder.OngoingReading)ongoingReadingWithoutWhere;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String normalizeName(String ... parts) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        String[] $this$mapNotNull$iv = parts;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void v0 = it;
            if ((v0 != null ? ExtensionFunctionsKt.capitalize((String)v0) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl4 = !StringsKt.isBlank((CharSequence)it);
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ExtensionFunctionsKt.decapitalize(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
    }

    @NotNull
    public static final FunctionInvocation id(@NotNull PropertyContainer $this$id) {
        FunctionInvocation functionInvocation;
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        PropertyContainer propertyContainer = $this$id;
        if (propertyContainer instanceof Node) {
            FunctionInvocation functionInvocation2 = Cypher.elementId((Node)((Node)$this$id));
            functionInvocation = functionInvocation2;
            Intrinsics.checkNotNullExpressionValue((Object)functionInvocation2, (String)"elementId(...)");
        } else if (propertyContainer instanceof Relationship) {
            FunctionInvocation functionInvocation3 = Cypher.elementId((Relationship)((Relationship)$this$id));
            functionInvocation = functionInvocation3;
            Intrinsics.checkNotNullExpressionValue((Object)functionInvocation3, (String)"elementId(...)");
        } else {
            throw new IllegalArgumentException("Id can only be retrieved for Nodes or Relationships");
        }
        return functionInvocation;
    }

    @NotNull
    public static final String toCamelCase(@NotNull String $this$toCamelCase) {
        Intrinsics.checkNotNullParameter((Object)$this$toCamelCase, (String)"<this>");
        return new Regex("[\\W_]([a-z])").replace((CharSequence)$this$toCamelCase, (Function1)toCamelCase.1.INSTANCE);
    }

    @Nullable
    public static final <T> T unwrap(@NotNull Optional<T> $this$unwrap) {
        Intrinsics.checkNotNullParameter($this$unwrap, (String)"<this>");
        return $this$unwrap.orElse(null);
    }

    @NotNull
    public static final Description asDescription(@NotNull String $this$asDescription) {
        Intrinsics.checkNotNullParameter((Object)$this$asDescription, (String)"<this>");
        return new Description($this$asDescription, null, StringsKt.contains$default((CharSequence)$this$asDescription, (CharSequence)"\n", (boolean)false, (int)2, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String capitalize(@NotNull String $this$capitalize) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$capitalize, (String)"<this>");
        String string2 = $this$capitalize;
        if (((CharSequence)string2).length() > 0) {
            String string3;
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isLowerCase((char)it)) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                string3 = CharsKt.titlecase((char)it, (Locale)locale);
            } else {
                string3 = String.valueOf((char)it);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
            String string4 = string2;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decapitalize(@NotNull String $this$decapitalize) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$decapitalize, (String)"<this>");
        String string2 = $this$decapitalize;
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.lowercase((char)it, (Locale)locale));
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String toUpperCase(@NotNull String $this$toUpperCase) {
        Intrinsics.checkNotNullParameter((Object)$this$toUpperCase, (String)"<this>");
        String string = $this$toUpperCase;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }

    @NotNull
    public static final String toLowerCase(@NotNull String $this$toLowerCase) {
        Intrinsics.checkNotNullParameter((Object)$this$toLowerCase, (String)"<this>");
        String string = $this$toLowerCase;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }
}

