/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql;

import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.GraphQLExtensionsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003J(\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lorg/neo4j/graphql/RelationOperator;", "", "suffix", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSuffix", "()Ljava/lang/String;", "fieldName", "harmonize", "type", "Lgraphql/schema/GraphQLFieldsContainer;", "field", "Lgraphql/schema/GraphQLFieldDefinition;", "value", "", "queryFieldName", "SOME", "EVERY", "SINGLE", "NONE", "EQ_OR_NOT_EXISTS", "NOT", "Companion", "neo4j-graphql-java"})
public final class RelationOperator
extends Enum<RelationOperator> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String suffix;
    private static final Logger LOGGER;
    public static final /* enum */ RelationOperator SOME;
    public static final /* enum */ RelationOperator EVERY;
    public static final /* enum */ RelationOperator SINGLE;
    public static final /* enum */ RelationOperator NONE;
    public static final /* enum */ RelationOperator EQ_OR_NOT_EXISTS;
    public static final /* enum */ RelationOperator NOT;
    private static final /* synthetic */ RelationOperator[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private RelationOperator(String suffix) {
        this.suffix = suffix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    @NotNull
    public final String fieldName(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return fieldName + this.suffix;
    }

    @NotNull
    public final RelationOperator harmonize(@NotNull GraphQLFieldsContainer type, @NotNull GraphQLFieldDefinition field, @Nullable Object value, @NotNull String queryFieldName) {
        RelationOperator relationOperator;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)queryFieldName, (String)"queryFieldName");
        GraphQLOutputType graphQLOutputType = field.getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getType(...)");
        boolean bl = GraphQLExtensionsKt.isList((GraphQLType)graphQLOutputType);
        if (bl) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    if (value == null) {
                        relationOperator = NOT;
                        break;
                    }
                    relationOperator = NONE;
                    break;
                }
                case 2: {
                    if (value == null) {
                        relationOperator = EQ_OR_NOT_EXISTS;
                        break;
                    }
                    LOGGER.debug(queryFieldName + " on type " + type.getName() + " was used for filtering, consider using " + field.getName() + RelationOperator.EVERY.suffix + " instead");
                    relationOperator = EVERY;
                    break;
                }
                default: {
                    relationOperator = this;
                    break;
                }
            }
        } else if (!bl) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 3: {
                    LOGGER.debug("Using " + queryFieldName + " on type " + type.getName() + " is deprecated, use " + field.getName() + " directly");
                    relationOperator = SOME;
                    break;
                }
                case 4: {
                    LOGGER.debug("Using " + queryFieldName + " on type " + type.getName() + " is deprecated, use " + field.getName() + " directly");
                    relationOperator = SOME;
                    break;
                }
                case 5: {
                    LOGGER.debug("Using " + queryFieldName + " on type " + type.getName() + " is deprecated, use " + field.getName() + RelationOperator.NOT.suffix + " instead");
                    relationOperator = NONE;
                    break;
                }
                case 1: {
                    if (value == null) {
                        relationOperator = NOT;
                        break;
                    }
                    relationOperator = NONE;
                    break;
                }
                case 2: {
                    if (value == null) {
                        relationOperator = EQ_OR_NOT_EXISTS;
                        break;
                    }
                    relationOperator = SOME;
                    break;
                }
                default: {
                    relationOperator = this;
                    break;
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return relationOperator;
    }

    public static RelationOperator[] values() {
        return (RelationOperator[])$VALUES.clone();
    }

    public static RelationOperator valueOf(String value) {
        return Enum.valueOf(RelationOperator.class, value);
    }

    @NotNull
    public static EnumEntries<RelationOperator> getEntries() {
        return $ENTRIES;
    }

    static {
        SOME = new RelationOperator("_some");
        EVERY = new RelationOperator("_every");
        SINGLE = new RelationOperator("_single");
        NONE = new RelationOperator("_none");
        EQ_OR_NOT_EXISTS = new RelationOperator("");
        NOT = new RelationOperator("_not");
        $VALUES = relationOperatorArray = new RelationOperator[]{RelationOperator.SOME, RelationOperator.EVERY, RelationOperator.SINGLE, RelationOperator.NONE, RelationOperator.EQ_OR_NOT_EXISTS, RelationOperator.NOT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(RelationOperator.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/neo4j/graphql/RelationOperator$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createRelationFilterFields", "", "type", "Lgraphql/language/TypeDefinition;", "field", "Lgraphql/language/FieldDefinition;", "filterType", "", "builder", "Lgraphql/language/InputObjectTypeDefinition$Builder;", "neo4j-graphql-java"})
    public static final class Companion {
        private Companion() {
        }

        public final void createRelationFilterFields(@NotNull TypeDefinition<?> type, @NotNull FieldDefinition field, @NotNull String filterType, @NotNull InputObjectTypeDefinition.Builder builder) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)filterType, (String)"filterType");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Type type2 = field.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
            boolean list = GraphQLExtensionsKt.isList(type2);
            Function2 addFilterField2 = (Function2)new Function2<RelationOperator, String, Unit>(builder, field, filterType){
                final /* synthetic */ InputObjectTypeDefinition.Builder $builder;
                final /* synthetic */ FieldDefinition $field;
                final /* synthetic */ String $filterType;
                {
                    this.$builder = $builder;
                    this.$field = $field;
                    this.$filterType = $filterType;
                    super(2);
                }

                public final void invoke(@NotNull RelationOperator op, @NotNull String description) {
                    Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
                    Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                    String string = this.$field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    GraphQLExtensionsKt.addFilterField(this.$builder, op.fieldName(string), false, this.$filterType, ExtensionFunctionsKt.asDescription(description));
                }
            };
            addFilterField2.invoke((Object)EQ_OR_NOT_EXISTS, (Object)("Filters only those `" + type.getName() + "` for which " + (list ? "all" : "the") + " `" + field.getName() + "`-relationship matches this filter. If `null` is passed to this field, only those `" + type.getName() + "` will be filtered which has no `" + field.getName() + "`-relations"));
            addFilterField2.invoke((Object)NOT, (Object)("Filters only those `" + type.getName() + "` for which " + (list ? "all" : "the") + " `" + field.getName() + "`-relationship does not match this filter. If `null` is passed to this field, only those `" + type.getName() + "` will be filtered which has any `" + field.getName() + "`-relation"));
            if (list) {
                addFilterField2.invoke((Object)EVERY, (Object)("Filters only those `" + type.getName() + "` for which all `" + field.getName() + "`-relationships matches this filter"));
                addFilterField2.invoke((Object)SOME, (Object)("Filters only those `" + type.getName() + "` for which at least one `" + field.getName() + "`-relationship matches this filter"));
                addFilterField2.invoke((Object)SINGLE, (Object)("Filters only those `" + type.getName() + "` for which exactly one `" + field.getName() + "`-relationship matches this filter"));
                addFilterField2.invoke((Object)NONE, (Object)("Filters only those `" + type.getName() + "` for which none of the `" + field.getName() + "`-relationships matches this filter"));
            } else {
                addFilterField2.invoke((Object)SINGLE, (Object)("@deprecated Use the `" + field.getName() + "`-field directly (without any suffix)"));
                addFilterField2.invoke((Object)SOME, (Object)("@deprecated Use the `" + field.getName() + "`-field directly (without any suffix)"));
                addFilterField2.invoke((Object)NONE, (Object)("@deprecated Use the `" + field.getName() + NOT.getSuffix() + "`-field"));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelationOperator.values().length];
            try {
                nArray[RelationOperator.NOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationOperator.EQ_OR_NOT_EXISTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationOperator.SINGLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationOperator.SOME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationOperator.NONE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

