/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql;

import graphql.TypeResolutionEnvironment;
import graphql.language.Description;
import graphql.language.DirectiveDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactoryEnvironment;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.PropertyDataFetcherHelper;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphql.AugmentationHandler;
import org.neo4j.graphql.Cypher;
import org.neo4j.graphql.DataFetchingInterceptor;
import org.neo4j.graphql.DynamicProperties;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.GraphQLExtensionsKt;
import org.neo4j.graphql.Neo4jTypesKt;
import org.neo4j.graphql.NoOpCoercing;
import org.neo4j.graphql.SchemaBuilder;
import org.neo4j.graphql.SchemaConfig;
import org.neo4j.graphql.TypeDefinition;
import org.neo4j.graphql.handler.AugmentFieldHandler;
import org.neo4j.graphql.handler.CreateTypeHandler;
import org.neo4j.graphql.handler.CypherDirectiveHandler;
import org.neo4j.graphql.handler.DeleteHandler;
import org.neo4j.graphql.handler.MergeOrUpdateHandler;
import org.neo4j.graphql.handler.QueryHandler;
import org.neo4j.graphql.handler.relation.CreateRelationHandler;
import org.neo4j.graphql.handler.relation.CreateRelationTypeHandler;
import org.neo4j.graphql.handler.relation.DeleteRelationHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0002&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\bH\u0002J\u0006\u0010\u001d\u001a\u00020\u0010J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020\u0003H\u0002J$\u0010!\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0007J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lorg/neo4j/graphql/SchemaBuilder;", "", "typeDefinitionRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "schemaConfig", "Lorg/neo4j/graphql/SchemaConfig;", "(Lgraphql/schema/idl/TypeDefinitionRegistry;Lorg/neo4j/graphql/SchemaConfig;)V", "handler", "", "Lorg/neo4j/graphql/AugmentationHandler;", "neo4jTypeDefinitionRegistry", "getSchemaConfig", "()Lorg/neo4j/graphql/SchemaConfig;", "getTypeDefinitionRegistry", "()Lgraphql/schema/idl/TypeDefinitionRegistry;", "addDataFetcher", "", "parentType", "", "operationType", "Lorg/neo4j/graphql/AugmentationHandler$OperationType;", "dataFetchingInterceptor", "Lorg/neo4j/graphql/DataFetchingInterceptor;", "codeRegistryBuilder", "Lgraphql/schema/GraphQLCodeRegistry$Builder;", "addInputType", "inputName", "relevantFields", "Lgraphql/language/FieldDefinition;", "augmentTypes", "ensureRootQueryTypeExists", "enhancedRegistry", "getNeo4jEnhancements", "registerDataFetcher", "registerScalars", "builder", "Lgraphql/schema/idl/RuntimeWiring$Builder;", "registerTypeNameResolver", "AliasPropertyDataFetcher", "Companion", "neo4j-graphql-java"})
@SourceDebugExtension(value={"SMAP\nSchemaBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaBuilder.kt\norg/neo4j/graphql/SchemaBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,304:1\n800#2,11:305\n766#2:316\n857#2,2:317\n1855#2,2:319\n800#2,11:321\n766#2:332\n857#2,2:333\n1855#2,2:335\n819#2:337\n847#2,2:338\n1855#2:340\n1855#2,2:341\n1856#2:343\n1360#2:344\n1446#2,2:345\n1360#2:347\n1446#2,2:348\n1549#2:350\n1620#2,3:351\n1448#2,3:354\n1549#2:357\n1620#2,3:358\n1448#2,3:361\n1855#2,2:364\n1549#2:366\n1620#2,3:367\n819#2:370\n847#2,2:371\n1603#2,9:373\n1855#2:382\n1856#2:384\n1612#2:385\n1855#2,2:386\n800#2,11:396\n1855#2,2:410\n819#2:413\n847#2,2:414\n1855#2:416\n1855#2,2:417\n1856#2:419\n1855#2,2:420\n1549#2:422\n1620#2,3:423\n1#3:383\n1#3:412\n551#4:388\n536#4,6:389\n215#5:395\n216#5:409\n37#6,2:407\n*S KotlinDebug\n*F\n+ 1 SchemaBuilder.kt\norg/neo4j/graphql/SchemaBuilder\n*L\n111#1:305,11\n112#1:316\n112#1:317,2\n113#1:319,2\n117#1:321,11\n118#1:332\n118#1:333,2\n119#1:335,2\n123#1:337\n123#1:338,2\n124#1:340\n126#1:341,2\n124#1:343\n130#1:344\n130#1:345,2\n133#1:347\n133#1:348,2\n133#1:350\n133#1:351,3\n133#1:354,3\n135#1:357\n135#1:358,3\n130#1:361,3\n139#1:364,2\n141#1:366\n141#1:367,3\n142#1:370\n142#1:371,2\n143#1:373,9\n143#1:382\n143#1:384\n143#1:385\n144#1:386,2\n174#1:396,11\n190#1:410,2\n228#1:413\n228#1:414,2\n229#1:416\n230#1:417,2\n229#1:419\n270#1:420,2\n285#1:422\n285#1:423,3\n143#1:383\n167#1:388\n167#1:389,6\n168#1:395\n168#1:409\n174#1:407,2\n*E\n"})
public final class SchemaBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TypeDefinitionRegistry typeDefinitionRegistry;
    @NotNull
    private final SchemaConfig schemaConfig;
    @NotNull
    private final List<AugmentationHandler> handler;
    @NotNull
    private final TypeDefinitionRegistry neo4jTypeDefinitionRegistry;

    public SchemaBuilder(@NotNull TypeDefinitionRegistry typeDefinitionRegistry, @NotNull SchemaConfig schemaConfig) {
        Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        this.typeDefinitionRegistry = typeDefinitionRegistry;
        this.schemaConfig = schemaConfig;
        this.neo4jTypeDefinitionRegistry = this.getNeo4jEnhancements();
        this.ensureRootQueryTypeExists(this.typeDefinitionRegistry);
        Object object = new AugmentationHandler[]{new CypherDirectiveHandler.Factory(this.schemaConfig, this.typeDefinitionRegistry, this.neo4jTypeDefinitionRegistry), new AugmentFieldHandler(this.schemaConfig, this.typeDefinitionRegistry, this.neo4jTypeDefinitionRegistry)};
        this.handler = CollectionsKt.mutableListOf((Object[])object);
        if (this.schemaConfig.getQuery().getEnabled()) {
            this.handler.add(new QueryHandler.Factory(this.schemaConfig, this.typeDefinitionRegistry, this.neo4jTypeDefinitionRegistry));
        }
        if (this.schemaConfig.getMutation().getEnabled()) {
            object = this.handler;
            Object[] objectArray = new AugmentationHandler[]{new MergeOrUpdateHandler.Factory(this.schemaConfig, this.typeDefinitionRegistry, this.neo4jTypeDefinitionRegistry), new DeleteHandler.Factory(this.schemaConfig, this.typeDefinitionRegistry, this.neo4jTypeDefinitionRegistry), new CreateTypeHandler.Factory(this.schemaConfig, this.typeDefinitionRegistry, this.neo4jTypeDefinitionRegistry), new DeleteRelationHandler.Factory(this.schemaConfig, this.typeDefinitionRegistry, this.neo4jTypeDefinitionRegistry), new CreateRelationTypeHandler.Factory(this.schemaConfig, this.typeDefinitionRegistry, this.neo4jTypeDefinitionRegistry), new CreateRelationHandler.Factory(this.schemaConfig, this.typeDefinitionRegistry, this.neo4jTypeDefinitionRegistry)};
            CollectionsKt.addAll((Collection)object, (Iterable)CollectionsKt.listOf((Object[])objectArray));
        }
    }

    public /* synthetic */ SchemaBuilder(TypeDefinitionRegistry typeDefinitionRegistry, SchemaConfig schemaConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            schemaConfig = new SchemaConfig(null, null, false, false, null, false, false, 127, null);
        }
        this(typeDefinitionRegistry, schemaConfig);
    }

    @NotNull
    public final TypeDefinitionRegistry getTypeDefinitionRegistry() {
        return this.typeDefinitionRegistry;
    }

    @NotNull
    public final SchemaConfig getSchemaConfig() {
        return this.schemaConfig;
    }

    /*
     * WARNING - void declaration
     */
    public final void augmentTypes() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterator $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Iterable $this$forEach$iv;
        Iterator $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        AugmentationHandler h;
        Object element$iv;
        Object $this$forEach$iv2;
        Object element$iv22;
        Iterable $this$forEach$iv3;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object element$iv$iv2;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        String queryTypeName = GraphQLExtensionsKt.queryTypeName(this.typeDefinitionRegistry);
        String mutationTypeName = GraphQLExtensionsKt.mutationTypeName(this.typeDefinitionRegistry);
        String subscriptionTypeName = GraphQLExtensionsKt.subscriptionTypeName(this.typeDefinitionRegistry);
        Iterable iterable = this.typeDefinitionRegistry.types().values();
        boolean $i$f$filterIsInstance = false;
        void var6_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof ImplementingTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv2 = iterator.next();
            ImplementingTypeDefinition it = (ImplementingTypeDefinition)element$iv$iv2;
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)queryTypeName) && !Intrinsics.areEqual((Object)it.getName(), (Object)mutationTypeName) && !Intrinsics.areEqual((Object)it.getName(), (Object)subscriptionTypeName))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv22 : $this$forEach$iv3) {
            ImplementingTypeDefinition type = (ImplementingTypeDefinition)element$iv22;
            boolean bl = false;
            $this$forEach$iv2 = this.handler;
            boolean $i$f$forEach2 = false;
            Iterator bl2 = $this$forEach$iv2.iterator();
            while (bl2.hasNext()) {
                element$iv = bl2.next();
                h = (AugmentationHandler)element$iv;
                boolean bl3 = false;
                h.augmentType(type);
            }
        }
        $this$forEach$iv3 = this.typeDefinitionRegistry.types().values();
        $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof ImplementingTypeDefinition)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv2 = bl.next();
            ImplementingTypeDefinition it = (ImplementingTypeDefinition)element$iv$iv2;
            boolean bl4 = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)queryTypeName) || Intrinsics.areEqual((Object)it.getName(), (Object)mutationTypeName) || Intrinsics.areEqual((Object)it.getName(), (Object)subscriptionTypeName))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv22 : $this$forEach$iv3) {
            ImplementingTypeDefinition type = (ImplementingTypeDefinition)element$iv22;
            boolean bl5 = false;
            $this$forEach$iv2 = this.handler;
            boolean $i$f$forEach3 = false;
            Iterator bl4 = $this$forEach$iv2.iterator();
            while (bl4.hasNext()) {
                element$iv = bl4.next();
                h = (AugmentationHandler)element$iv;
                boolean bl6 = false;
                h.augmentType(type);
            }
        }
        List types = new ArrayList();
        Iterable $i$f$forEach2 = this.neo4jTypeDefinitionRegistry.getDirectiveDefinitions().values();
        boolean $i$f$filterNot = false;
        element$iv22 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        $this$forEach$iv2 = $this$filterNotTo$iv$iv.iterator();
        while ($this$forEach$iv2.hasNext()) {
            Object element$iv$iv3 = $this$forEach$iv2.next();
            DirectiveDefinition it = (DirectiveDefinition)element$iv$iv3;
            boolean bl7 = false;
            if (this.typeDefinitionRegistry.getDirectiveDefinition(it.getName()).isPresent()) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach4 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            DirectiveDefinition directiveDefinition = (DirectiveDefinition)element$iv3;
            boolean bl8 = false;
            this.typeDefinitionRegistry.add((SDLDefinition)directiveDefinition);
            List list = directiveDefinition.getInputValueDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInputValueDefinitions(...)");
            Iterable $this$forEach$iv4 = list;
            boolean $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv4) {
                InputValueDefinition it = (InputValueDefinition)element$iv4;
                boolean bl9 = false;
                Type type = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
                types.add(type);
            }
        }
        $this$forEach$iv = this.typeDefinitionRegistry.types().values();
        boolean $i$f$flatMap = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator bl8 = $this$flatMapTo$iv$iv.iterator();
        while (bl8.hasNext()) {
            List list;
            Object element$iv4;
            Object element$iv$iv4 = bl8.next();
            graphql.language.TypeDefinition typeDefinition = (graphql.language.TypeDefinition)element$iv$iv4;
            boolean bl10 = false;
            element$iv4 = typeDefinition;
            if (element$iv4 instanceof ImplementingTypeDefinition) {
                void $this$flatMap$iv2;
                List list2 = ((ImplementingTypeDefinition)typeDefinition).getFieldDefinitions();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFieldDefinitions(...)");
                Iterable it = list2;
                boolean $i$f$flatMap2 = false;
                void var17_63 = $this$flatMap$iv2;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv5 : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv2;
                    FieldDefinition fieldDefinition = (FieldDefinition)element$iv$iv5;
                    boolean bl11 = false;
                    List list3 = fieldDefinition.getInputValueDefinitions();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getInputValueDefinitions(...)");
                    Iterable $this$map$iv2 = list3;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it2;
                        InputValueDefinition inputValueDefinition = (InputValueDefinition)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl12 = false;
                        collection.add(it2.getType());
                    }
                    list$iv$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv3), (Object)fieldDefinition.getType());
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else if (element$iv4 instanceof InputObjectTypeDefinition) {
                void $this$mapTo$iv$iv3;
                List list4 = ((InputObjectTypeDefinition)typeDefinition).getInputValueDefinitions();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getInputValueDefinitions(...)");
                Iterable $this$map$iv3 = list4;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv3;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it;
                    list$iv$iv = (InputValueDefinition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl13 = false;
                    collection.add(it.getType());
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        $i$f$forEach4 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            Type it = (Type)element$iv3;
            boolean bl14 = false;
            Intrinsics.checkNotNull((Object)it);
            types.add(it);
        }
        $this$forEach$iv = types;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type list$iv$iv = (Type)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl15 = false;
            collection.add(new TypeName(GraphQLExtensionsKt.name(it)));
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterNotTo = false;
        Iterator bl14 = $this$filterNotTo$iv$iv.iterator();
        while (bl14.hasNext()) {
            Object element$iv$iv6 = bl14.next();
            TypeName it = (TypeName)element$iv$iv6;
            boolean bl16 = false;
            if (this.typeDefinitionRegistry.hasType(it)) continue;
            destination$iv$iv2.add(element$iv$iv6);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach6 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            graphql.language.TypeDefinition it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv7 = element$iv$iv$iv = iterator2.next();
            boolean bl17 = false;
            TypeName it = (TypeName)element$iv$iv7;
            boolean bl18 = false;
            Optional optional = this.neo4jTypeDefinitionRegistry.getType((Type)it);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getType(...)");
            if ((graphql.language.TypeDefinition)ExtensionFunctionsKt.unwrap(optional) == null) continue;
            boolean bl19 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        $i$f$forEach4 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            graphql.language.TypeDefinition it = (graphql.language.TypeDefinition)element$iv3;
            boolean bl20 = false;
            this.typeDefinitionRegistry.add((SDLDefinition)it);
        }
        if (this.typeDefinitionRegistry.getType(mutationTypeName).isPresent()) {
            this.typeDefinitionRegistry.schemaDefinition().ifPresent(arg_0 -> SchemaBuilder.augmentTypes$lambda$18((Function1)new Function1<SchemaDefinition, Unit>(this, mutationTypeName){
                final /* synthetic */ SchemaBuilder this$0;
                final /* synthetic */ String $mutationTypeName;
                {
                    this.this$0 = $receiver;
                    this.$mutationTypeName = $mutationTypeName;
                    super(1);
                }

                public final void invoke(@NotNull SchemaDefinition schemaDefinition) {
                    Intrinsics.checkNotNullParameter((Object)schemaDefinition, (String)"schemaDefinition");
                    this.this$0.getTypeDefinitionRegistry().remove((SDLDefinition)schemaDefinition);
                    this.this$0.getTypeDefinitionRegistry().add((SDLDefinition)schemaDefinition.transform(arg_0 -> augmentTypes.13.invoke$lambda$1(schemaDefinition, this.$mutationTypeName, arg_0)));
                }

                private static final void invoke$lambda$1(SchemaDefinition $schemaDefinition, String $mutationTypeName, SchemaDefinition.Builder it) {
                    Object v1;
                    List ops;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)$schemaDefinition, (String)"$schemaDefinition");
                        Intrinsics.checkNotNullParameter((Object)$mutationTypeName, (String)"$mutationTypeName");
                        List list = $schemaDefinition.getOperationTypeDefinitions();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOperationTypeDefinitions(...)");
                        ops = CollectionsKt.toMutableList((Collection)list);
                        Iterable iterable = ops;
                        for (T t : iterable) {
                            OperationTypeDefinition it2 = (OperationTypeDefinition)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it2.getName(), (Object)"mutation")) continue;
                            v1 = t;
                            break block2;
                        }
                        v1 = null;
                    }
                    if (v1 == null) {
                        ops.add(new OperationTypeDefinition("mutation", new TypeName($mutationTypeName)));
                    }
                    it.operationTypeDefinitions(ops);
                }
            }, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void registerScalars(@NotNull RuntimeWiring.Builder builder) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Map map = this.typeDefinitionRegistry.scalars();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"scalars(...)");
        Map $this$filterNot$iv = map;
        boolean $i$f$filterNot = false;
        Object object = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            if (ScalarInfo.GRAPHQL_SPECIFICATION_SCALARS_DEFINITIONS.containsKey(entry.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            GraphQLScalarType graphQLScalarType;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            ScalarTypeDefinition definition = (ScalarTypeDefinition)entry.getValue();
            if (Intrinsics.areEqual((Object)name, (Object)"DynamicProperties")) {
                graphQLScalarType = DynamicProperties.INSTANCE.getINSTANCE();
            } else {
                void $this$toTypedArray$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Collection $this$filterIsInstance$iv;
                Object object2;
                GraphQLDirective[] graphQLDirectiveArray;
                GraphQLScalarType.Builder builder2 = GraphQLScalarType.newScalar().name(name);
                Description description = definition.getDescription();
                Object object3 = description != null ? description.getContent() : null;
                if (graphQLDirectiveArray == null) {
                    object2 = "Scalar " + name;
                } else {
                    graphQLDirectiveArray = object3;
                    Intrinsics.checkNotNull((Object)graphQLDirectiveArray);
                    object2 = graphQLDirectiveArray;
                }
                GraphQLScalarType.Builder builder3 = builder2.description((String)object2);
                List list = definition.getDirectives();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDirectives(...)");
                Iterable iterable = list;
                GraphQLScalarType.Builder builder4 = builder3;
                boolean $i$f$filterIsInstance = false;
                void var14_17 = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof GraphQLDirective)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                graphQLDirectiveArray = thisCollection$iv.toArray(new GraphQLDirective[0]);
                graphQLScalarType = builder4.withDirectives(Arrays.copyOf(graphQLDirectiveArray, graphQLDirectiveArray.length)).definition(definition).coercing((Coercing)NoOpCoercing.INSTANCE).build();
            }
            GraphQLScalarType scalar = graphQLScalarType;
            builder.scalar(scalar);
        }
    }

    public final void registerTypeNameResolver(@NotNull RuntimeWiring.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        List list = this.typeDefinitionRegistry.getTypes(InterfaceTypeDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InterfaceTypeDefinition typeDefinition = (InterfaceTypeDefinition)element$iv;
            boolean bl = false;
            builder.type(typeDefinition.getName(), SchemaBuilder::registerTypeNameResolver$lambda$25$lambda$24);
        }
    }

    @JvmOverloads
    public final void registerDataFetcher(@NotNull GraphQLCodeRegistry.Builder codeRegistryBuilder, @Nullable DataFetchingInterceptor dataFetchingInterceptor, @NotNull TypeDefinitionRegistry typeDefinitionRegistry) {
        Intrinsics.checkNotNullParameter((Object)codeRegistryBuilder, (String)"codeRegistryBuilder");
        Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
        if (dataFetchingInterceptor != null) {
            codeRegistryBuilder.defaultDataFetcher(SchemaBuilder::registerDataFetcher$lambda$26);
        }
        this.addDataFetcher(GraphQLExtensionsKt.queryTypeName(typeDefinitionRegistry), AugmentationHandler.OperationType.QUERY, dataFetchingInterceptor, codeRegistryBuilder);
        this.addDataFetcher(GraphQLExtensionsKt.mutationTypeName(typeDefinitionRegistry), AugmentationHandler.OperationType.MUTATION, dataFetchingInterceptor, codeRegistryBuilder);
    }

    public static /* synthetic */ void registerDataFetcher$default(SchemaBuilder schemaBuilder, GraphQLCodeRegistry.Builder builder, DataFetchingInterceptor dataFetchingInterceptor, TypeDefinitionRegistry typeDefinitionRegistry, int n, Object object) {
        if ((n & 4) != 0) {
            typeDefinitionRegistry = schemaBuilder.typeDefinitionRegistry;
        }
        schemaBuilder.registerDataFetcher(builder, dataFetchingInterceptor, typeDefinitionRegistry);
    }

    /*
     * WARNING - void declaration
     */
    private final void addDataFetcher(String parentType, AugmentationHandler.OperationType operationType, DataFetchingInterceptor dataFetchingInterceptor, GraphQLCodeRegistry.Builder codeRegistryBuilder) {
        block6: {
            void $this$forEach$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            List list;
            graphql.language.TypeDefinition typeDefinition;
            Optional optional = this.typeDefinitionRegistry.getType(parentType);
            if (optional == null || (typeDefinition = (graphql.language.TypeDefinition)ExtensionFunctionsKt.unwrap(optional)) == null) break block6;
            graphql.language.TypeDefinition it = typeDefinition;
            boolean $i$a$-let-SchemaBuilder$addDataFetcher$22 = false;
            ObjectTypeDefinition objectTypeDefinition = it instanceof ObjectTypeDefinition ? (ObjectTypeDefinition)it : null;
            if (objectTypeDefinition == null || (list = objectTypeDefinition.getFieldDefinitions()) == null) break block6;
            Iterable $i$a$-let-SchemaBuilder$addDataFetcher$22 = list;
            boolean $i$f$filterNot = false;
            Iterator iterator = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FieldDefinition it2 = (FieldDefinition)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                if (GraphQLExtensionsKt.isIgnored(it2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FieldDefinition field = (FieldDefinition)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = this.handler;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    DataFetcher dataFetcher;
                    block8: {
                        DataFetcher dataFetcher2;
                        block7: {
                            AugmentationHandler h = (AugmentationHandler)element$iv2;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)field);
                            if (h.createDataFetcher(operationType, field) == null) continue;
                            boolean bl3 = false;
                            dataFetcher = dataFetchingInterceptor;
                            if (dataFetcher == null) break block7;
                            DataFetcher it3 = dataFetcher;
                            boolean bl4 = false;
                            DataFetcher dataFetcher3 = arg_0 -> SchemaBuilder.addDataFetcher$lambda$33$lambda$32$lambda$31$lambda$30$lambda$29(dataFetchingInterceptor, dataFetcher2, arg_0);
                            dataFetcher = dataFetcher3;
                            if (dataFetcher3 != null) break block8;
                        }
                        dataFetcher = dataFetcher2;
                    }
                    DataFetcher interceptedDataFetcher = dataFetcher;
                    codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)parentType, (String)field.getName()), interceptedDataFetcher);
                }
            }
        }
    }

    private final void ensureRootQueryTypeExists(TypeDefinitionRegistry enhancedRegistry) {
        OperationTypeDefinition operationTypeDefinition;
        SchemaDefinition schemaDefinition = enhancedRegistry.schemaDefinition().orElse(null);
        Object object = schemaDefinition;
        if (object != null && (object = object.getOperationTypeDefinitions()) != null) {
            Object v1;
            block6: {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    OperationTypeDefinition it = (OperationTypeDefinition)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"query")) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            operationTypeDefinition = v1;
        } else {
            operationTypeDefinition = null;
        }
        if (operationTypeDefinition != null) {
            return;
        }
        enhancedRegistry.add((SDLDefinition)ObjectTypeDefinition.newObjectTypeDefinition().name("Query").build());
        if (schemaDefinition != null) {
            enhancedRegistry.remove((SDLDefinition)schemaDefinition);
        } else {
            schemaDefinition = SchemaDefinition.newSchemaDefinition().build();
        }
        enhancedRegistry.add((SDLDefinition)schemaDefinition.transform(SchemaBuilder::ensureRootQueryTypeExists$lambda$35));
    }

    private final TypeDefinitionRegistry getNeo4jEnhancements() {
        String string;
        String string2;
        Object object;
        Charset charset;
        URL uRL;
        URL uRL2 = this.getClass().getResource("/neo4j_types.graphql");
        if (uRL2 != null) {
            uRL = uRL2;
            charset = Charsets.UTF_8;
            object = TextStreamsKt.readBytes((URL)uRL);
            string2 = new String((byte[])object, charset);
        } else {
            string2 = null;
        }
        URL uRL3 = this.getClass().getResource("/lib_directives.graphql");
        if (uRL3 != null) {
            uRL = uRL3;
            charset = Charsets.UTF_8;
            object = TextStreamsKt.readBytes((URL)uRL);
            string = new String((byte[])object, charset);
        } else {
            string = null;
        }
        String directivesSdl = string2 + string;
        TypeDefinitionRegistry typeDefinitionRegistry = new SchemaParser().parse(directivesSdl);
        Iterable $this$forEach$iv = Neo4jTypesKt.getNeo4jTypeDefinitions();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            TypeDefinition it = (TypeDefinition)element$iv;
            boolean bl = false;
            Object t = typeDefinitionRegistry.getType(it.getTypeDefinition()).orElseThrow(() -> SchemaBuilder.getNeo4jEnhancements$lambda$37$lambda$36(it));
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type graphql.language.ObjectTypeDefinition");
            ObjectTypeDefinition type = (ObjectTypeDefinition)t;
            Intrinsics.checkNotNull((Object)typeDefinitionRegistry);
            String string3 = it.getInputDefinition();
            List list = type.getFieldDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFieldDefinitions(...)");
            this.addInputType(typeDefinitionRegistry, string3, list);
        }
        Intrinsics.checkNotNull((Object)typeDefinitionRegistry);
        return typeDefinitionRegistry;
    }

    /*
     * WARNING - void declaration
     */
    private final String addInputType(TypeDefinitionRegistry typeDefinitionRegistry, String inputName, List<? extends FieldDefinition> relevantFields) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (typeDefinitionRegistry.getType(inputName).isPresent()) {
            return inputName;
        }
        Iterable iterable = relevantFields;
        InputObjectTypeDefinition.Builder builder = InputObjectTypeDefinition.newInputObjectDefinition().name(inputName);
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FieldDefinition fieldDefinition = (FieldDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InputValueDefinition.newInputValueDefinition().name(it.getName()).type(it.getType()).build());
        }
        InputObjectTypeDefinition inputType = builder.inputValueDefinitions((List)destination$iv$iv).build();
        typeDefinitionRegistry.add((SDLDefinition)inputType);
        return inputName;
    }

    @JvmOverloads
    public final void registerDataFetcher(@NotNull GraphQLCodeRegistry.Builder codeRegistryBuilder, @Nullable DataFetchingInterceptor dataFetchingInterceptor) {
        Intrinsics.checkNotNullParameter((Object)codeRegistryBuilder, (String)"codeRegistryBuilder");
        SchemaBuilder.registerDataFetcher$default(this, codeRegistryBuilder, dataFetchingInterceptor, null, 4, null);
    }

    private static final void augmentTypes$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final GraphQLObjectType registerTypeNameResolver$lambda$25$lambda$24$lambda$23(TypeResolutionEnvironment env) {
        Object object = env.getObject();
        if (!(object instanceof Map)) return null;
        Map map = (Map)object;
        Map map2 = map;
        if (map2 == null) return null;
        Map data = map2;
        boolean bl = false;
        Object v = data.get("__typename");
        if (!(v instanceof String)) return null;
        String string = (String)v;
        object = string;
        if (object == null) return null;
        Object typeName = object;
        boolean bl2 = false;
        GraphQLObjectType graphQLObjectType = env.getSchema().getObjectType((String)typeName);
        return graphQLObjectType;
    }

    private static final TypeRuntimeWiring.Builder registerTypeNameResolver$lambda$25$lambda$24(TypeRuntimeWiring.Builder it) {
        return it.typeResolver(SchemaBuilder::registerTypeNameResolver$lambda$25$lambda$24$lambda$23);
    }

    private static final DataFetcher registerDataFetcher$lambda$26(DataFetcherFactoryEnvironment it) {
        return new AliasPropertyDataFetcher();
    }

    private static final Object addDataFetcher$lambda$33$lambda$32$lambda$31$lambda$30$lambda$29(DataFetchingInterceptor $dataFetchingInterceptor, DataFetcher $dataFetcher, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)$dataFetcher, (String)"$dataFetcher");
        Intrinsics.checkNotNull((Object)env);
        return $dataFetchingInterceptor.fetchData(env, (DataFetcher<Cypher>)$dataFetcher);
    }

    private static final void ensureRootQueryTypeExists$lambda$35(SchemaDefinition.Builder it) {
        it.operationTypeDefinition(OperationTypeDefinition.newOperationTypeDefinition().name("query").typeName(new TypeName("Query")).build());
    }

    private static final IllegalStateException getNeo4jEnhancements$lambda$37$lambda$36(TypeDefinition $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return new IllegalStateException("type " + $it.getTypeDefinition() + " not found");
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final GraphQLSchema buildSchema(@NotNull String sdl, @NotNull SchemaConfig config, @Nullable DataFetchingInterceptor dataFetchingInterceptor) {
        return Companion.buildSchema(sdl, config, dataFetchingInterceptor);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final GraphQLSchema buildSchema(@NotNull TypeDefinitionRegistry typeDefinitionRegistry, @NotNull SchemaConfig config, @Nullable DataFetchingInterceptor dataFetchingInterceptor) {
        return Companion.buildSchema(typeDefinitionRegistry, config, dataFetchingInterceptor);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final GraphQLSchema buildSchema(@NotNull String sdl, @NotNull SchemaConfig config) {
        return Companion.buildSchema(sdl, config);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final GraphQLSchema buildSchema(@NotNull String sdl) {
        return Companion.buildSchema(sdl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final GraphQLSchema buildSchema(@NotNull TypeDefinitionRegistry typeDefinitionRegistry, @NotNull SchemaConfig config) {
        return Companion.buildSchema(typeDefinitionRegistry, config);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final GraphQLSchema buildSchema(@NotNull TypeDefinitionRegistry typeDefinitionRegistry) {
        return Companion.buildSchema(typeDefinitionRegistry);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002\u00a8\u0006\u0007"}, d2={"Lorg/neo4j/graphql/SchemaBuilder$AliasPropertyDataFetcher;", "Lgraphql/schema/DataFetcher;", "", "()V", "get", "env", "Lgraphql/schema/DataFetchingEnvironment;", "neo4j-graphql-java"})
    public static final class AliasPropertyDataFetcher
    implements DataFetcher<Object> {
        @Nullable
        public Object get(@NotNull DataFetchingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Object object = env.getSource();
            if (object == null) {
                return null;
            }
            Object source = object;
            String string = env.getMergedField().getSingleField().getAlias();
            if (string == null) {
                string = env.getMergedField().getSingleField().getName();
            }
            String propertyName = string;
            return PropertyDataFetcherHelper.getPropertyValue((String)propertyName, (Object)source, (GraphQLType)((GraphQLType)env.getFieldType()), () -> AliasPropertyDataFetcher.get$lambda$0(env));
        }

        private static final DataFetchingEnvironment get$lambda$0(DataFetchingEnvironment $env) {
            Intrinsics.checkNotNullParameter((Object)$env, (String)"$env");
            return $env;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u00a8\u0006\r"}, d2={"Lorg/neo4j/graphql/SchemaBuilder$Companion;", "", "()V", "buildSchema", "Lgraphql/schema/GraphQLSchema;", "typeDefinitionRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "config", "Lorg/neo4j/graphql/SchemaConfig;", "dataFetchingInterceptor", "Lorg/neo4j/graphql/DataFetchingInterceptor;", "sdl", "", "neo4j-graphql-java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final GraphQLSchema buildSchema(@NotNull String sdl, @NotNull SchemaConfig config, @Nullable DataFetchingInterceptor dataFetchingInterceptor) {
            Intrinsics.checkNotNullParameter((Object)sdl, (String)"sdl");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            SchemaParser schemaParser = new SchemaParser();
            TypeDefinitionRegistry typeDefinitionRegistry = schemaParser.parse(sdl);
            Intrinsics.checkNotNull((Object)typeDefinitionRegistry);
            return this.buildSchema(typeDefinitionRegistry, config, dataFetchingInterceptor);
        }

        public static /* synthetic */ GraphQLSchema buildSchema$default(Companion companion, String string, SchemaConfig schemaConfig, DataFetchingInterceptor dataFetchingInterceptor, int n, Object object) {
            if ((n & 2) != 0) {
                schemaConfig = new SchemaConfig(null, null, false, false, null, false, false, 127, null);
            }
            if ((n & 4) != 0) {
                dataFetchingInterceptor = null;
            }
            return companion.buildSchema(string, schemaConfig, dataFetchingInterceptor);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final GraphQLSchema buildSchema(@NotNull TypeDefinitionRegistry typeDefinitionRegistry, @NotNull SchemaConfig config, @Nullable DataFetchingInterceptor dataFetchingInterceptor) {
            Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
            GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
            SchemaBuilder schemaBuilder = new SchemaBuilder(typeDefinitionRegistry, config);
            schemaBuilder.augmentTypes();
            Intrinsics.checkNotNull((Object)builder);
            schemaBuilder.registerScalars(builder);
            schemaBuilder.registerTypeNameResolver(builder);
            Intrinsics.checkNotNull((Object)codeRegistryBuilder);
            SchemaBuilder.registerDataFetcher$default(schemaBuilder, codeRegistryBuilder, dataFetchingInterceptor, null, 4, null);
            GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(typeDefinitionRegistry, builder.codeRegistry(codeRegistryBuilder).build());
            Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema, (String)"makeExecutableSchema(...)");
            return graphQLSchema;
        }

        public static /* synthetic */ GraphQLSchema buildSchema$default(Companion companion, TypeDefinitionRegistry typeDefinitionRegistry, SchemaConfig schemaConfig, DataFetchingInterceptor dataFetchingInterceptor, int n, Object object) {
            if ((n & 2) != 0) {
                schemaConfig = new SchemaConfig(null, null, false, false, null, false, false, 127, null);
            }
            if ((n & 4) != 0) {
                dataFetchingInterceptor = null;
            }
            return companion.buildSchema(typeDefinitionRegistry, schemaConfig, dataFetchingInterceptor);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final GraphQLSchema buildSchema(@NotNull String sdl, @NotNull SchemaConfig config) {
            Intrinsics.checkNotNullParameter((Object)sdl, (String)"sdl");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return org.neo4j.graphql.SchemaBuilder$Companion.buildSchema$default(this, sdl, config, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final GraphQLSchema buildSchema(@NotNull String sdl) {
            Intrinsics.checkNotNullParameter((Object)sdl, (String)"sdl");
            return org.neo4j.graphql.SchemaBuilder$Companion.buildSchema$default(this, sdl, null, null, 6, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final GraphQLSchema buildSchema(@NotNull TypeDefinitionRegistry typeDefinitionRegistry, @NotNull SchemaConfig config) {
            Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return org.neo4j.graphql.SchemaBuilder$Companion.buildSchema$default(this, typeDefinitionRegistry, config, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final GraphQLSchema buildSchema(@NotNull TypeDefinitionRegistry typeDefinitionRegistry) {
            Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
            return org.neo4j.graphql.SchemaBuilder$Companion.buildSchema$default(this, typeDefinitionRegistry, null, null, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

