/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql;

import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.SerializationError;
import graphql.TypeMismatchError;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.neo4j.graphql.Cypher;
import org.neo4j.graphql.InvalidQueryException;
import org.neo4j.graphql.OptimizedQueryException;
import org.neo4j.graphql.QueryContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/neo4j/graphql/Translator;", "", "schema", "Lgraphql/schema/GraphQLSchema;", "(Lgraphql/schema/GraphQLSchema;)V", "gql", "Lgraphql/GraphQL;", "getSchema", "()Lgraphql/schema/GraphQLSchema;", "translate", "", "Lorg/neo4j/graphql/Cypher;", "query", "", "params", "", "ctx", "Lorg/neo4j/graphql/QueryContext;", "CypherHolder", "neo4j-graphql-java"})
@SourceDebugExtension(value={"SMAP\nTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Translator.kt\norg/neo4j/graphql/Translator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1855#2,2:43\n*S KotlinDebug\n*F\n+ 1 Translator.kt\norg/neo4j/graphql/Translator\n*L\n24#1:43,2\n*E\n"})
public final class Translator {
    @NotNull
    private final GraphQLSchema schema;
    @NotNull
    private final GraphQL gql;

    public Translator(@NotNull GraphQLSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.schema = schema;
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)this.schema).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"build(...)");
        this.gql = graphQL;
    }

    @NotNull
    public final GraphQLSchema getSchema() {
        return this.schema;
    }

    @JvmOverloads
    @NotNull
    public final List<Cypher> translate(@NotNull String query, @NotNull Map<String, ? extends Object> params, @NotNull QueryContext ctx) throws OptimizedQueryException {
        CypherHolder cypherHolder;
        block2: {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            cypherHolder = new CypherHolder(null, 1, null);
            ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).variables(params).graphQLContext(MapsKt.mapOf((Pair)TuplesKt.to((Object)"Neo4jGraphQLQueryContext", (Object)ctx))).localContext((Object)cypherHolder).build();
            ExecutionResult result = this.gql.execute(executionInput);
            List list = result.getErrors();
            if (list == null) break block2;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GraphQLError it = (GraphQLError)element$iv;
                boolean bl = false;
                GraphQLError graphQLError = it;
                if (graphQLError instanceof ExceptionWhileDataFetching) {
                    Throwable throwable = ((ExceptionWhileDataFetching)it).getException();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getException(...)");
                    throw throwable;
                }
                if (((graphQLError instanceof TypeMismatchError ? true : graphQLError instanceof NonNullableFieldWasNullError) ? true : graphQLError instanceof SerializationError) || graphQLError == null) continue;
                Intrinsics.checkNotNull((Object)it);
                throw new InvalidQueryException(it);
            }
        }
        return cypherHolder.getCyphers();
    }

    public static /* synthetic */ List translate$default(Translator translator, String string, Map map, QueryContext queryContext, int n, Object object) throws OptimizedQueryException {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            queryContext = new QueryContext(false, null, null, 7, null);
        }
        return translator.translate(string, map, queryContext);
    }

    @JvmOverloads
    @NotNull
    public final List<Cypher> translate(@NotNull String query, @NotNull Map<String, ? extends Object> params) throws OptimizedQueryException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        return Translator.translate$default(this, query, params, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final List<Cypher> translate(@NotNull String query) throws OptimizedQueryException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return Translator.translate$default(this, query, null, null, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/neo4j/graphql/Translator$CypherHolder;", "", "cyphers", "", "Lorg/neo4j/graphql/Cypher;", "(Ljava/util/List;)V", "getCyphers", "()Ljava/util/List;", "neo4j-graphql-java"})
    public static final class CypherHolder {
        @NotNull
        private final List<Cypher> cyphers;

        public CypherHolder(@NotNull List<Cypher> cyphers) {
            Intrinsics.checkNotNullParameter(cyphers, (String)"cyphers");
            this.cyphers = cyphers;
        }

        public /* synthetic */ CypherHolder(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(list);
        }

        @NotNull
        public final List<Cypher> getCyphers() {
            return this.cyphers;
        }

        public CypherHolder() {
            this(null, 1, null);
        }
    }
}

