/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql.handler;

import graphql.language.DirectivesContainer;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.atteo.evo.inflector.English;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.graphql.AugmentationHandler;
import org.neo4j.graphql.Cypher;
import org.neo4j.graphql.CypherDirective;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.GraphQLExtensionsKt;
import org.neo4j.graphql.QueryContext;
import org.neo4j.graphql.SchemaConfig;
import org.neo4j.graphql.handler.BaseDataFetcherForContainer;
import org.neo4j.graphql.handler.QueryHandler;
import org.neo4j.graphql.handler.filter.OptimizedFilterHandler;
import org.neo4j.graphql.handler.projection.ProjectionBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/neo4j/graphql/handler/QueryHandler;", "Lorg/neo4j/graphql/handler/BaseDataFetcherForContainer;", "schemaConfig", "Lorg/neo4j/graphql/SchemaConfig;", "(Lorg/neo4j/graphql/SchemaConfig;)V", "generateCypher", "Lorg/neo4j/cypherdsl/core/Statement;", "variable", "", "field", "Lgraphql/language/Field;", "env", "Lgraphql/schema/DataFetchingEnvironment;", "Factory", "neo4j-graphql-java"})
@SourceDebugExtension(value={"SMAP\nQueryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryHandler.kt\norg/neo4j/graphql/handler/QueryHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class QueryHandler
extends BaseDataFetcherForContainer {
    private QueryHandler(SchemaConfig schemaConfig) {
        super(schemaConfig);
    }

    @Override
    @NotNull
    protected Statement generateCypher(@NotNull String variable, @NotNull Field field, @NotNull DataFetchingEnvironment env) {
        StatementBuilder.OngoingReading ongoingReading;
        Pair pair;
        PatternElement[] patternElementArray;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        GraphQLFieldDefinition fieldDefinition = env.getFieldDefinition();
        GraphQLFieldsContainer type = GraphQLExtensionsKt.typeAsContainer(env);
        if (GraphQLExtensionsKt.isRelationType(type)) {
            String[] stringArray = new String[]{GraphQLExtensionsKt.label(type)};
            Relationship rel = ((Relationship)org.neo4j.cypherdsl.core.Cypher.anyNode().relationshipTo(org.neo4j.cypherdsl.core.Cypher.anyNode(), stringArray)).named(variable);
            boolean bl = false;
            patternElementArray = new PatternElement[]{rel};
            pair = TuplesKt.to((Object)rel, (Object)org.neo4j.cypherdsl.core.Cypher.match((PatternElement[])patternElementArray));
        } else {
            Node node = org.neo4j.cypherdsl.core.Cypher.node((String)GraphQLExtensionsKt.label(type), (String[])new String[0]).named(variable);
            boolean bl = false;
            patternElementArray = new PatternElement[]{node};
            pair = TuplesKt.to((Object)node, (Object)org.neo4j.cypherdsl.core.Cypher.match((PatternElement[])patternElementArray));
        }
        Pair pair2 = pair;
        Object propertyContainer = pair2.component1();
        StatementBuilder.OngoingReadingWithoutWhere match = (StatementBuilder.OngoingReadingWithoutWhere)pair2.component2();
        Set<QueryContext.OptimizationStrategy> set = GraphQLExtensionsKt.queryContext(env).getOptimizedQuery();
        boolean bl = set != null ? set.contains((Object)QueryContext.OptimizationStrategy.FILTER_AS_MATCH) : false;
        if (bl) {
            OptimizedFilterHandler optimizedFilterHandler = new OptimizedFilterHandler(type, this.getSchemaConfig());
            Intrinsics.checkNotNull((Object)fieldDefinition);
            Map map = env.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
            Intrinsics.checkNotNull((Object)match);
            PropertyContainer propertyContainer2 = (PropertyContainer)propertyContainer;
            Map map2 = env.getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getVariables(...)");
            ongoingReading = optimizedFilterHandler.generateFilterQuery(variable, fieldDefinition, map, match, propertyContainer2, map2);
        } else {
            PropertyContainer propertyContainer3 = (PropertyContainer)propertyContainer;
            Intrinsics.checkNotNull((Object)fieldDefinition);
            Map map = env.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
            Map map3 = env.getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getVariables(...)");
            Condition where = this.where(propertyContainer3, fieldDefinition, type, map, map3);
            patternElementArray = match.where(where);
            Intrinsics.checkNotNull((Object)patternElementArray);
            ongoingReading = (StatementBuilder.OngoingReading)patternElementArray;
        }
        StatementBuilder.OngoingReading ongoingReading2 = ongoingReading;
        patternElementArray = ProjectionBase.projectFields$default(this, (PropertyContainer)propertyContainer, type, env, null, null, null, 56, null);
        List projectionEntries = (List)patternElementArray.component1();
        List subQueries = (List)patternElementArray.component2();
        AliasedExpression aliasedExpression = ((PropertyContainer)propertyContainer).project(projectionEntries).as(GraphQLExtensionsKt.aliasOrName(field));
        Intrinsics.checkNotNullExpressionValue((Object)aliasedExpression, (String)"as(...)");
        AliasedExpression mapProjection = aliasedExpression;
        Expression[] expressionArray = new Expression[]{mapProjection};
        StatementBuilder.OngoingReadingAndReturn ongoingReadingAndReturn = ExtensionFunctionsKt.withSubQueries(ongoingReading2, subQueries).returning(expressionArray);
        Intrinsics.checkNotNullExpressionValue((Object)ongoingReadingAndReturn, (String)"returning(...)");
        SymbolicName symbolicName = ((PropertyContainer)propertyContainer).getRequiredSymbolicName();
        Intrinsics.checkNotNullExpressionValue((Object)symbolicName, (String)"getRequiredSymbolicName(...)");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        Statement statement = this.skipLimitOrder(ongoingReadingAndReturn, symbolicName, fieldDefinition, map).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        return statement;
    }

    public /* synthetic */ QueryHandler(SchemaConfig schemaConfig, DefaultConstructorMarker $constructor_marker) {
        this(schemaConfig);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J \u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u0014\u0010\u0017\u001a\u00020\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/neo4j/graphql/handler/QueryHandler$Factory;", "Lorg/neo4j/graphql/AugmentationHandler;", "schemaConfig", "Lorg/neo4j/graphql/SchemaConfig;", "typeDefinitionRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "neo4jTypeDefinitionRegistry", "(Lorg/neo4j/graphql/SchemaConfig;Lgraphql/schema/idl/TypeDefinitionRegistry;Lgraphql/schema/idl/TypeDefinitionRegistry;)V", "augmentType", "", "type", "Lgraphql/language/ImplementingTypeDefinition;", "canHandle", "", "createDataFetcher", "Lgraphql/schema/DataFetcher;", "Lorg/neo4j/graphql/Cypher;", "operationType", "Lorg/neo4j/graphql/AugmentationHandler$OperationType;", "fieldDefinition", "Lgraphql/language/FieldDefinition;", "getRelevantFields", "", "hasRelationships", "neo4j-graphql-java"})
    @SourceDebugExtension(value={"SMAP\nQueryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryHandler.kt\norg/neo4j/graphql/handler/QueryHandler$Factory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n819#2:135\n847#2,2:136\n1747#2,3:138\n766#2:141\n857#2,2:142\n*S KotlinDebug\n*F\n+ 1 QueryHandler.kt\norg/neo4j/graphql/handler/QueryHandler$Factory\n*L\n93#1:135\n93#1:136,2\n94#1:138,3\n99#1:141\n99#1:142,2\n*E\n"})
    public static final class Factory
    extends AugmentationHandler {
        public Factory(@NotNull SchemaConfig schemaConfig, @NotNull TypeDefinitionRegistry typeDefinitionRegistry, @NotNull TypeDefinitionRegistry neo4jTypeDefinitionRegistry) {
            Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
            Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
            Intrinsics.checkNotNullParameter((Object)neo4jTypeDefinitionRegistry, (String)"neo4jTypeDefinitionRegistry");
            super(schemaConfig, typeDefinitionRegistry, neo4jTypeDefinitionRegistry);
        }

        @Override
        public void augmentType(@NotNull ImplementingTypeDefinition<?> type) {
            String fieldName;
            List arguments2;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            if (!this.canHandle(type)) {
                return;
            }
            String typeName = type.getName();
            List<FieldDefinition> relevantFields = this.getRelevantFields(type);
            String filterTypeName = AugmentationHandler.addFilterType$default(this, type, null, 2, null);
            List list = arguments2 = this.getSchemaConfig().getUseWhereFilter() ? CollectionsKt.listOf((Object)AugmentationHandler.input$default(this, "where", (Type)new TypeName(filterTypeName), null, 4, null)) : CollectionsKt.plus((Collection)this.getInputValueDefinitions(relevantFields, true, (Function1<? super FieldDefinition, Boolean>)((Function1)augmentType.arguments.1.INSTANCE)), (Object)AugmentationHandler.input$default(this, "filter", (Type)new TypeName(filterTypeName), null, 4, null));
            if (this.getSchemaConfig().getCapitalizeQueryFields()) {
                v1 = typeName;
            } else {
                Intrinsics.checkNotNull((Object)typeName);
                v1 = fieldName = ExtensionFunctionsKt.decapitalize(typeName);
            }
            if (this.getSchemaConfig().getPluralizeFields()) {
                fieldName = English.plural((String)fieldName);
            }
            FieldDefinition.Builder builder = FieldDefinition.newFieldDefinition().name(fieldName).inputValueDefinitions(CollectionsKt.toMutableList((Collection)arguments2)).type((Type)new NonNullType((Type)new ListType((Type)new NonNullType((Type)new TypeName(type.getName())))));
            if (this.getSchemaConfig().getQueryOptionStyle() == SchemaConfig.InputStyle.INPUT_TYPE) {
                String optionsTypeName = this.addOptions(type);
                builder.inputValueDefinition(AugmentationHandler.input$default(this, "options", (Type)new TypeName(optionsTypeName), null, 4, null));
            } else {
                builder.inputValueDefinition(AugmentationHandler.input$default(this, "first", (Type)GraphQLExtensionsKt.getTypeInt(), null, 4, null)).inputValueDefinition(AugmentationHandler.input$default(this, "offset", (Type)GraphQLExtensionsKt.getTypeInt(), null, 4, null));
                String orderingTypeName = this.addOrdering(type);
                if (orderingTypeName != null) {
                    builder.inputValueDefinition(AugmentationHandler.input$default(this, "orderBy", (Type)new ListType((Type)new NonNullType((Type)new TypeName(orderingTypeName))), null, 4, null));
                }
            }
            FieldDefinition def = builder.build();
            Intrinsics.checkNotNull((Object)def);
            this.addQueryField(def);
        }

        @Override
        @Nullable
        public DataFetcher<Cypher> createDataFetcher(@NotNull AugmentationHandler.OperationType operationType, @NotNull FieldDefinition fieldDefinition) {
            Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
            Intrinsics.checkNotNullParameter((Object)fieldDefinition, (String)"fieldDefinition");
            if (operationType != AugmentationHandler.OperationType.QUERY) {
                return null;
            }
            CypherDirective cypherDirective = this.cypherDirective((DirectivesContainer)fieldDefinition);
            if (cypherDirective != null) {
                return null;
            }
            Type type = fieldDefinition.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            TypeDefinition<?> typeDefinition = this.resolve(GraphQLExtensionsKt.inner(type));
            ImplementingTypeDefinition implementingTypeDefinition = typeDefinition instanceof ImplementingTypeDefinition ? (ImplementingTypeDefinition)typeDefinition : null;
            if (implementingTypeDefinition == null) {
                return null;
            }
            ImplementingTypeDefinition type2 = implementingTypeDefinition;
            if (!this.canHandle(type2)) {
                return null;
            }
            return new QueryHandler(this.getSchemaConfig(), null);
        }

        private final boolean canHandle(ImplementingTypeDefinition<?> type) {
            String typeName = type.getName();
            if (!this.getSchemaConfig().getQuery().getEnabled() || this.getSchemaConfig().getQuery().getExclude().contains(typeName) || this.isRootType(type)) {
                return false;
            }
            return !this.getRelevantFields(type).isEmpty() || this.hasRelationships(type);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean hasRelationships(ImplementingTypeDefinition<?> type) {
            boolean bl;
            block4: {
                void $this$filterNotTo$iv$iv;
                List list = type.getFieldDefinitions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFieldDefinitions(...)");
                Iterable $this$filterNot$iv = list;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    FieldDefinition it = (FieldDefinition)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (GraphQLExtensionsKt.isIgnored(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FieldDefinition it = (FieldDefinition)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!this.isRelationship(it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final List<FieldDefinition> getRelevantFields(ImplementingTypeDefinition<?> type) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getScalarFields(type);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FieldDefinition it = (FieldDefinition)element$iv$iv;
                boolean bl = false;
                if (!(this.dynamicPrefix(it) == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }
}

