/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql.handler.relation;

import graphql.language.Argument;
import graphql.language.DirectivesContainer;
import graphql.language.FieldDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.graphql.AugmentationHandler;
import org.neo4j.graphql.Cypher;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.GraphQLExtensionsKt;
import org.neo4j.graphql.RelationshipInfo;
import org.neo4j.graphql.SchemaConfig;
import org.neo4j.graphql.handler.BaseDataFetcherForContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\n\"\u0004\b\u0016\u0010\f\u00a8\u0006)"}, d2={"Lorg/neo4j/graphql/handler/relation/BaseRelationHandler;", "Lorg/neo4j/graphql/handler/BaseDataFetcherForContainer;", "prefix", "", "schemaConfig", "Lorg/neo4j/graphql/SchemaConfig;", "(Ljava/lang/String;Lorg/neo4j/graphql/SchemaConfig;)V", "endId", "Lorg/neo4j/graphql/handler/relation/BaseRelationHandler$RelatedField;", "getEndId", "()Lorg/neo4j/graphql/handler/relation/BaseRelationHandler$RelatedField;", "setEndId", "(Lorg/neo4j/graphql/handler/relation/BaseRelationHandler$RelatedField;)V", "relation", "Lorg/neo4j/graphql/RelationshipInfo;", "Lgraphql/schema/GraphQLFieldsContainer;", "getRelation", "()Lorg/neo4j/graphql/RelationshipInfo;", "setRelation", "(Lorg/neo4j/graphql/RelationshipInfo;)V", "startId", "getStartId", "setStartId", "getRelationSelect", "Lkotlin/Pair;", "Lorg/neo4j/cypherdsl/core/Node;", "Lorg/neo4j/cypherdsl/core/Condition;", "start", "", "arguments", "", "Lgraphql/language/Argument;", "initDataFetcher", "", "fieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "parentType", "Lgraphql/schema/GraphQLType;", "initRelation", "BaseRelationFactory", "RelatedField", "neo4j-graphql-java"})
public abstract class BaseRelationHandler
extends BaseDataFetcherForContainer {
    @NotNull
    private final String prefix;
    public RelationshipInfo<GraphQLFieldsContainer> relation;
    public RelatedField startId;
    public RelatedField endId;

    public BaseRelationHandler(@NotNull String prefix, @NotNull SchemaConfig schemaConfig) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        super(schemaConfig);
        this.prefix = prefix;
    }

    @NotNull
    public final RelationshipInfo<GraphQLFieldsContainer> getRelation() {
        RelationshipInfo<GraphQLFieldsContainer> relationshipInfo = this.relation;
        if (relationshipInfo != null) {
            return relationshipInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"relation");
        return null;
    }

    public final void setRelation(@NotNull RelationshipInfo<GraphQLFieldsContainer> relationshipInfo) {
        Intrinsics.checkNotNullParameter(relationshipInfo, (String)"<set-?>");
        this.relation = relationshipInfo;
    }

    @NotNull
    public final RelatedField getStartId() {
        RelatedField relatedField = this.startId;
        if (relatedField != null) {
            return relatedField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"startId");
        return null;
    }

    public final void setStartId(@NotNull RelatedField relatedField) {
        Intrinsics.checkNotNullParameter((Object)relatedField, (String)"<set-?>");
        this.startId = relatedField;
    }

    @NotNull
    public final RelatedField getEndId() {
        RelatedField relatedField = this.endId;
        if (relatedField != null) {
            return relatedField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"endId");
        return null;
    }

    public final void setEndId(@NotNull RelatedField relatedField) {
        Intrinsics.checkNotNullParameter((Object)relatedField, (String)"<set-?>");
        this.endId = relatedField;
    }

    @Override
    protected void initDataFetcher(@NotNull GraphQLFieldDefinition fieldDefinition, @NotNull GraphQLType parentType) {
        Intrinsics.checkNotNullParameter((Object)fieldDefinition, (String)"fieldDefinition");
        Intrinsics.checkNotNullParameter((Object)parentType, (String)"parentType");
        super.initDataFetcher(fieldDefinition, parentType);
        this.initRelation(fieldDefinition);
        this.getPropertyFields().remove(this.getStartId().getArgumentName());
        this.getPropertyFields().remove(this.getEndId().getArgumentName());
    }

    protected void initRelation(@NotNull GraphQLFieldDefinition fieldDefinition) {
        Intrinsics.checkNotNullParameter((Object)fieldDefinition, (String)"fieldDefinition");
        String p = this.prefix + this.getType().getName();
        String string = fieldDefinition.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String it = ExtensionFunctionsKt.decapitalize(StringsKt.removePrefix((String)string, (CharSequence)p));
        boolean bl = false;
        GraphQLFieldDefinition graphQLFieldDefinition = GraphQLExtensionsKt.getRelevantFieldDefinition(this.getType(), it);
        if (graphQLFieldDefinition == null) {
            throw new IllegalStateException("Cannot find field " + it + " on type " + this.getType().getName());
        }
        GraphQLFieldDefinition targetField = graphQLFieldDefinition;
        GraphQLFieldsContainer graphQLFieldsContainer = this.getType();
        String string2 = targetField.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        RelationshipInfo<GraphQLFieldsContainer> relationshipInfo = GraphQLExtensionsKt.relationshipFor(graphQLFieldsContainer, string2);
        if (relationshipInfo == null) {
            throw new IllegalStateException("Cannot resolve relationship for " + targetField.getName() + " on type " + this.getType().getName());
        }
        this.setRelation(relationshipInfo);
        GraphQLOutputType graphQLOutputType = targetField.getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getType(...)");
        GraphQLFieldsContainer targetType = GraphQLExtensionsKt.getInnerFieldsContainer((GraphQLType)graphQLOutputType);
        GraphQLFieldDefinition graphQLFieldDefinition2 = GraphQLExtensionsKt.getIdField(this.getType());
        if (graphQLFieldDefinition2 == null) {
            throw new IllegalStateException("Cannot find id field for type " + this.getType().getName());
        }
        GraphQLFieldDefinition sourceIdField = graphQLFieldDefinition2;
        GraphQLFieldDefinition graphQLFieldDefinition3 = GraphQLExtensionsKt.getIdField(targetType);
        if (graphQLFieldDefinition3 == null) {
            throw new IllegalStateException("Cannot find id field for type " + targetType.getName());
        }
        GraphQLFieldDefinition targetIdField = graphQLFieldDefinition3;
        String string3 = sourceIdField.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        this.setStartId(new RelatedField(string3, sourceIdField, this.getType()));
        String string4 = targetField.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        this.setEndId(new RelatedField(string4, targetIdField, targetType));
    }

    @NotNull
    public final Pair<Node, Condition> getRelationSelect(boolean start, @NotNull Map<String, ? extends Argument> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        String relFieldName = null;
        RelatedField idField = null;
        if (start) {
            relFieldName = this.getRelation().getStartField();
            idField = this.getStartId();
        } else {
            relFieldName = this.getRelation().getEndField();
            idField = this.getEndId();
        }
        if (!arguments2.containsKey(idField.getArgumentName())) {
            throw new IllegalArgumentException("No ID for the " + (start ? "start" : "end") + " Type provided, " + idField.getArgumentName() + " is required");
        }
        Pair<PropertyContainer, Condition> pair = BaseDataFetcherForContainer.Companion.getSelectQuery(relFieldName, GraphQLExtensionsKt.label(idField.getDeclaringType()), arguments2.get(idField.getArgumentName()), idField.getField(), false);
        PropertyContainer rel = (PropertyContainer)pair.component1();
        Condition where = (Condition)pair.component2();
        Node node = rel instanceof Node ? (Node)rel : null;
        if (node == null) {
            throw new IllegalStateException("Expected type to be of type node");
        }
        return TuplesKt.to((Object)node, (Object)where);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0014\u0010\u0013\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\rH\u0004J\u0010\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H&J\u001e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fJ*\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001c2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001d\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/neo4j/graphql/handler/relation/BaseRelationHandler$BaseRelationFactory;", "Lorg/neo4j/graphql/AugmentationHandler;", "prefix", "", "schemaConfig", "Lorg/neo4j/graphql/SchemaConfig;", "typeDefinitionRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "neo4jTypeDefinitionRegistry", "(Ljava/lang/String;Lorg/neo4j/graphql/SchemaConfig;Lgraphql/schema/idl/TypeDefinitionRegistry;Lgraphql/schema/idl/TypeDefinitionRegistry;)V", "buildFieldDefinition", "Lgraphql/language/FieldDefinition$Builder;", "source", "Lgraphql/language/ImplementingTypeDefinition;", "targetField", "Lgraphql/language/FieldDefinition;", "nullableResult", "", "canHandleField", "canHandleType", "type", "createDataFetcher", "Lgraphql/schema/DataFetcher;", "Lorg/neo4j/graphql/Cypher;", "operationType", "Lorg/neo4j/graphql/AugmentationHandler$OperationType;", "fieldDefinition", "getRelationFields", "Lkotlin/Pair;", "hasRelationshipFor", "name", "neo4j-graphql-java"})
    @SourceDebugExtension(value={"SMAP\nBaseRelationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseRelationHandler.kt\norg/neo4j/graphql/handler/relation/BaseRelationHandler$BaseRelationFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
    public static abstract class BaseRelationFactory
    extends AugmentationHandler {
        @NotNull
        private final String prefix;

        public BaseRelationFactory(@NotNull String prefix, @NotNull SchemaConfig schemaConfig, @NotNull TypeDefinitionRegistry typeDefinitionRegistry, @NotNull TypeDefinitionRegistry neo4jTypeDefinitionRegistry) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
            Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
            Intrinsics.checkNotNullParameter((Object)neo4jTypeDefinitionRegistry, (String)"neo4jTypeDefinitionRegistry");
            super(schemaConfig, typeDefinitionRegistry, neo4jTypeDefinitionRegistry);
            this.prefix = prefix;
        }

        @Nullable
        protected final FieldDefinition.Builder buildFieldDefinition(@NotNull ImplementingTypeDefinition<?> source, @NotNull FieldDefinition targetField, boolean nullableResult) {
            Intrinsics.checkNotNullParameter(source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)targetField, (String)"targetField");
            Pair<FieldDefinition, FieldDefinition> pair = this.getRelationFields(source, targetField);
            if (pair == null) {
                return null;
            }
            FieldDefinition sourceIdField = (FieldDefinition)pair.component1();
            String string = targetField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String targetFieldName = ExtensionFunctionsKt.capitalize(string);
            NonNullType idType = new NonNullType((Type)GraphQLExtensionsKt.getTypeID());
            Type type = targetField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            NonNullType targetIDType = GraphQLExtensionsKt.isList(type) ? new NonNullType((Type)new ListType((Type)idType)) : idType;
            Type type2 = (Type)new TypeName(source.getName());
            if (!nullableResult) {
                type2 = (Type)new NonNullType(type2);
            }
            FieldDefinition.Builder builder = FieldDefinition.newFieldDefinition().name(this.prefix + source.getName() + targetFieldName);
            AugmentationHandler augmentationHandler = this;
            String string2 = sourceIdField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            FieldDefinition.Builder builder2 = builder.inputValueDefinition(AugmentationHandler.input$default(augmentationHandler, string2, (Type)idType, null, 4, null));
            AugmentationHandler augmentationHandler2 = this;
            String string3 = targetField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            return builder2.inputValueDefinition(AugmentationHandler.input$default(augmentationHandler2, string3, (Type)targetIDType, null, 4, null)).type(type2);
        }

        protected final boolean canHandleType(@NotNull ImplementingTypeDefinition<?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            if (!this.getSchemaConfig().getMutation().getEnabled() || this.getSchemaConfig().getMutation().getExclude().contains(type.getName()) || this.isRootType(type)) {
                return false;
            }
            return this.getIdField(type) != null;
        }

        protected final boolean canHandleField(@NotNull FieldDefinition targetField) {
            Intrinsics.checkNotNullParameter((Object)targetField, (String)"targetField");
            Type type = targetField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            TypeDefinition<?> typeDefinition = this.resolve(GraphQLExtensionsKt.inner(type));
            ImplementingTypeDefinition implementingTypeDefinition = typeDefinition instanceof ImplementingTypeDefinition ? (ImplementingTypeDefinition)typeDefinition : null;
            if (implementingTypeDefinition == null) {
                return false;
            }
            ImplementingTypeDefinition type2 = implementingTypeDefinition;
            if (!targetField.hasDirective("relation")) {
                return false;
            }
            if (GraphQLExtensionsKt.isIgnored(targetField)) {
                return false;
            }
            return this.getIdField(type2) != null;
        }

        @Override
        @Nullable
        public final DataFetcher<Cypher> createDataFetcher(@NotNull AugmentationHandler.OperationType operationType, @NotNull FieldDefinition fieldDefinition) {
            Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
            Intrinsics.checkNotNullParameter((Object)fieldDefinition, (String)"fieldDefinition");
            if (operationType != AugmentationHandler.OperationType.MUTATION) {
                return null;
            }
            if (this.cypherDirective((DirectivesContainer)fieldDefinition) != null) {
                return null;
            }
            Type type = fieldDefinition.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            TypeDefinition<?> typeDefinition = this.resolve(GraphQLExtensionsKt.inner(type));
            ImplementingTypeDefinition implementingTypeDefinition = typeDefinition instanceof ImplementingTypeDefinition ? (ImplementingTypeDefinition)typeDefinition : null;
            if (implementingTypeDefinition == null) {
                return null;
            }
            ImplementingTypeDefinition sourceType = implementingTypeDefinition;
            if (!this.canHandleType(sourceType)) {
                return null;
            }
            String p = this.prefix + sourceType.getName();
            String string = fieldDefinition.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)p, (boolean)false, (int)2, null)) {
                return null;
            }
            String string2 = fieldDefinition.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String it = ExtensionFunctionsKt.decapitalize(StringsKt.removePrefix((String)string2, (CharSequence)p));
            boolean bl = false;
            FieldDefinition fieldDefinition2 = this.getFieldDefinition(sourceType, it);
            if (fieldDefinition2 == null) {
                return null;
            }
            FieldDefinition targetField = fieldDefinition2;
            if (!this.canHandleField(targetField)) {
                return null;
            }
            String string3 = targetField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            if (!this.hasRelationshipFor(sourceType, string3)) {
                return null;
            }
            if (this.getRelationFields(sourceType, targetField) == null) {
                return null;
            }
            return this.createDataFetcher();
        }

        private final boolean hasRelationshipFor(ImplementingTypeDefinition<?> $this$hasRelationshipFor, String name) {
            FieldDefinition fieldDefinition = this.getFieldDefinition($this$hasRelationshipFor, name);
            if (fieldDefinition == null) {
                throw new IllegalArgumentException(name + " is not defined on " + $this$hasRelationshipFor.getName());
            }
            FieldDefinition field = fieldDefinition;
            Type type = field.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            TypeDefinition<?> typeDefinition = this.resolve(GraphQLExtensionsKt.inner(type));
            ImplementingTypeDefinition implementingTypeDefinition = typeDefinition instanceof ImplementingTypeDefinition ? (ImplementingTypeDefinition)typeDefinition : null;
            if (implementingTypeDefinition == null) {
                return false;
            }
            ImplementingTypeDefinition fieldObjectType = implementingTypeDefinition;
            String target = this.getDirectiveArgument((DirectivesContainer)$this$hasRelationshipFor, "relation", "to", null);
            if (target != null) {
                FieldDefinition fieldDefinition2 = this.getFieldDefinition(fieldObjectType, target);
                if (Intrinsics.areEqual((Object)(fieldDefinition2 != null ? fieldDefinition2.getName() : null), (Object)$this$hasRelationshipFor.getName())) {
                    return true;
                }
            } else {
                if (GraphQLExtensionsKt.getDirective((DirectivesContainer)fieldObjectType, "relation") != null) {
                    return true;
                }
                if (GraphQLExtensionsKt.getDirective((DirectivesContainer)field, "relation") != null) {
                    return true;
                }
            }
            return false;
        }

        @Nullable
        public abstract DataFetcher<Cypher> createDataFetcher();

        private final Pair<FieldDefinition, FieldDefinition> getRelationFields(ImplementingTypeDefinition<?> source, FieldDefinition targetField) {
            Type type = targetField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            TypeDefinition<?> typeDefinition = this.resolve(GraphQLExtensionsKt.inner(type));
            ImplementingTypeDefinition implementingTypeDefinition = typeDefinition instanceof ImplementingTypeDefinition ? (ImplementingTypeDefinition)typeDefinition : null;
            if (implementingTypeDefinition == null) {
                return null;
            }
            ImplementingTypeDefinition targetType = implementingTypeDefinition;
            FieldDefinition sourceIdField = this.getIdField(source);
            FieldDefinition targetIdField = this.getIdField(targetType);
            if (sourceIdField == null || targetIdField == null) {
                return null;
            }
            return TuplesKt.to((Object)sourceIdField, (Object)targetIdField);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/neo4j/graphql/handler/relation/BaseRelationHandler$RelatedField;", "", "argumentName", "", "field", "Lgraphql/schema/GraphQLFieldDefinition;", "declaringType", "Lgraphql/schema/GraphQLFieldsContainer;", "(Ljava/lang/String;Lgraphql/schema/GraphQLFieldDefinition;Lgraphql/schema/GraphQLFieldsContainer;)V", "getArgumentName", "()Ljava/lang/String;", "getDeclaringType", "()Lgraphql/schema/GraphQLFieldsContainer;", "getField", "()Lgraphql/schema/GraphQLFieldDefinition;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "neo4j-graphql-java"})
    public static final class RelatedField {
        @NotNull
        private final String argumentName;
        @NotNull
        private final GraphQLFieldDefinition field;
        @NotNull
        private final GraphQLFieldsContainer declaringType;

        public RelatedField(@NotNull String argumentName, @NotNull GraphQLFieldDefinition field, @NotNull GraphQLFieldsContainer declaringType) {
            Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)declaringType, (String)"declaringType");
            this.argumentName = argumentName;
            this.field = field;
            this.declaringType = declaringType;
        }

        @NotNull
        public final String getArgumentName() {
            return this.argumentName;
        }

        @NotNull
        public final GraphQLFieldDefinition getField() {
            return this.field;
        }

        @NotNull
        public final GraphQLFieldsContainer getDeclaringType() {
            return this.declaringType;
        }

        @NotNull
        public final String component1() {
            return this.argumentName;
        }

        @NotNull
        public final GraphQLFieldDefinition component2() {
            return this.field;
        }

        @NotNull
        public final GraphQLFieldsContainer component3() {
            return this.declaringType;
        }

        @NotNull
        public final RelatedField copy(@NotNull String argumentName, @NotNull GraphQLFieldDefinition field, @NotNull GraphQLFieldsContainer declaringType) {
            Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)declaringType, (String)"declaringType");
            return new RelatedField(argumentName, field, declaringType);
        }

        public static /* synthetic */ RelatedField copy$default(RelatedField relatedField, String string, GraphQLFieldDefinition graphQLFieldDefinition, GraphQLFieldsContainer graphQLFieldsContainer, int n, Object object) {
            if ((n & 1) != 0) {
                string = relatedField.argumentName;
            }
            if ((n & 2) != 0) {
                graphQLFieldDefinition = relatedField.field;
            }
            if ((n & 4) != 0) {
                graphQLFieldsContainer = relatedField.declaringType;
            }
            return relatedField.copy(string, graphQLFieldDefinition, graphQLFieldsContainer);
        }

        @NotNull
        public String toString() {
            return "RelatedField(argumentName=" + this.argumentName + ", field=" + this.field + ", declaringType=" + this.declaringType + ")";
        }

        public int hashCode() {
            int result = this.argumentName.hashCode();
            result = result * 31 + this.field.hashCode();
            result = result * 31 + this.declaringType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelatedField)) {
                return false;
            }
            RelatedField relatedField = (RelatedField)other;
            if (!Intrinsics.areEqual((Object)this.argumentName, (Object)relatedField.argumentName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.field, (Object)relatedField.field)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.declaringType, (Object)relatedField.declaringType);
        }
    }
}

