/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql;

import graphql.language.EnumTypeDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.ListComprehension;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.GraphQLExtensionsKt;
import org.neo4j.graphql.Neo4jPointConverter;
import org.neo4j.graphql.Neo4jSimpleConverter;
import org.neo4j.graphql.Neo4jTypesKt;
import org.neo4j.graphql.PredicatesKt;
import org.neo4j.graphql.SchemaConfig;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u001c\b\u0086\u0081\u0002\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001ABQ\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J:\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002JL\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003JH\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@\u00a8\u0006B"}, d2={"Lorg/neo4j/graphql/FieldOperator;", "", "suffix", "", "conditionCreator", "Lkotlin/Function2;", "Lorg/neo4j/cypherdsl/core/Expression;", "Lorg/neo4j/cypherdsl/core/Condition;", "not", "", "requireParam", "distance", "list", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function2;ZZZZ)V", "getDistance", "()Z", "getList", "getNot", "getRequireParam", "getSuffix", "()Ljava/lang/String;", "fieldName", "resolveCondition", "", "variablePrefix", "queriedField", "property", "Lorg/neo4j/cypherdsl/core/Property;", "value", "", "propertyContainer", "Lorg/neo4j/cypherdsl/core/PropertyContainer;", "field", "Lgraphql/schema/GraphQLFieldDefinition;", "schemaConfig", "Lorg/neo4j/graphql/SchemaConfig;", "resolveNeo4jTypeConditions", "values", "", "EQ", "IS_NULL", "IS_NOT_NULL", "NEQ", "GTE", "GT", "LTE", "LT", "NIN", "IN", "NC", "NSW", "NEW", "C", "SW", "EW", "MATCHES", "INCLUDES_ALL", "INCLUDES_SOME", "INCLUDES_NONE", "INCLUDES_SINGLE", "DISTANCE", "DISTANCE_LT", "DISTANCE_LTE", "DISTANCE_GT", "DISTANCE_GTE", "Companion", "neo4j-graphql-java"})
@SourceDebugExtension(value={"SMAP\nPredicates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Predicates.kt\norg/neo4j/graphql/FieldOperator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1864#2,3:221\n*S KotlinDebug\n*F\n+ 1 Predicates.kt\norg/neo4j/graphql/FieldOperator\n*L\n98#1:221,3\n*E\n"})
public final class FieldOperator
extends Enum<FieldOperator> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String suffix;
    @NotNull
    private final Function2<Expression, Expression, Condition> conditionCreator;
    private final boolean not;
    private final boolean requireParam;
    private final boolean distance;
    private final boolean list;
    public static final /* enum */ FieldOperator EQ;
    public static final /* enum */ FieldOperator IS_NULL;
    public static final /* enum */ FieldOperator IS_NOT_NULL;
    public static final /* enum */ FieldOperator NEQ;
    public static final /* enum */ FieldOperator GTE;
    public static final /* enum */ FieldOperator GT;
    public static final /* enum */ FieldOperator LTE;
    public static final /* enum */ FieldOperator LT;
    public static final /* enum */ FieldOperator NIN;
    public static final /* enum */ FieldOperator IN;
    public static final /* enum */ FieldOperator NC;
    public static final /* enum */ FieldOperator NSW;
    public static final /* enum */ FieldOperator NEW;
    public static final /* enum */ FieldOperator C;
    public static final /* enum */ FieldOperator SW;
    public static final /* enum */ FieldOperator EW;
    public static final /* enum */ FieldOperator MATCHES;
    public static final /* enum */ FieldOperator INCLUDES_ALL;
    public static final /* enum */ FieldOperator INCLUDES_SOME;
    public static final /* enum */ FieldOperator INCLUDES_NONE;
    public static final /* enum */ FieldOperator INCLUDES_SINGLE;
    public static final /* enum */ FieldOperator DISTANCE;
    public static final /* enum */ FieldOperator DISTANCE_LT;
    public static final /* enum */ FieldOperator DISTANCE_LTE;
    public static final /* enum */ FieldOperator DISTANCE_GT;
    public static final /* enum */ FieldOperator DISTANCE_GTE;
    private static final /* synthetic */ FieldOperator[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private FieldOperator(String suffix, Function2<? super Expression, ? super Expression, ? extends Condition> conditionCreator, boolean not, boolean requireParam, boolean distance, boolean list) {
        this.suffix = suffix;
        this.conditionCreator = conditionCreator;
        this.not = not;
        this.requireParam = requireParam;
        this.distance = distance;
        this.list = list;
    }

    /* synthetic */ FieldOperator(String string, int n, String string2, Function2 function2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x20) != 0) {
            bl4 = false;
        }
        this(string2, (Function2<? super Expression, ? super Expression, ? extends Condition>)function2, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    public final boolean getNot() {
        return this.not;
    }

    public final boolean getRequireParam() {
        return this.requireParam;
    }

    public final boolean getDistance() {
        return this.distance;
    }

    public final boolean getList() {
        return this.list;
    }

    @NotNull
    public final List<Condition> resolveCondition(@NotNull String variablePrefix, @NotNull String queriedField, @NotNull PropertyContainer propertyContainer, @Nullable GraphQLFieldDefinition field, @Nullable Object value, @NotNull SchemaConfig schemaConfig, @Nullable String suffix) {
        List list;
        GraphQLFieldDefinition graphQLFieldDefinition;
        Intrinsics.checkNotNullParameter((Object)variablePrefix, (String)"variablePrefix");
        Intrinsics.checkNotNullParameter((Object)queriedField, (String)"queriedField");
        Intrinsics.checkNotNullParameter((Object)propertyContainer, (String)"propertyContainer");
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        if (schemaConfig.getUseTemporalScalars()) {
            GraphQLFieldDefinition graphQLFieldDefinition2 = field;
            boolean bl = graphQLFieldDefinition2 != null && (graphQLFieldDefinition2 = graphQLFieldDefinition2.getType()) != null ? GraphQLExtensionsKt.isNeo4jTemporalType((GraphQLType)graphQLFieldDefinition2) : false;
            if (bl) {
                Neo4jSimpleConverter neo4jTypeConverter = Neo4jTypesKt.getNeo4jTypeConverter(field);
                String[] stringArray = new String[]{variablePrefix, queriedField, null, suffix};
                Parameter parameter = ExtensionFunctionsKt.queryParameter(value, stringArray).withValue(value);
                Property property = propertyContainer.property(field.getName());
                Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
                Intrinsics.checkNotNull((Object)parameter);
                return CollectionsKt.listOf((Object)neo4jTypeConverter.createCondition(property, parameter, this.conditionCreator));
            }
        }
        boolean bl = (graphQLFieldDefinition = field) != null && (graphQLFieldDefinition = graphQLFieldDefinition.getType()) != null ? GraphQLExtensionsKt.isNeo4jType((GraphQLType)graphQLFieldDefinition) : false;
        if (bl && value instanceof Map) {
            list = this.resolveNeo4jTypeConditions(variablePrefix, queriedField, propertyContainer, field, (Map)value, suffix);
        } else {
            GraphQLFieldDefinition graphQLFieldDefinition3 = field;
            boolean bl2 = graphQLFieldDefinition3 != null ? GraphQLExtensionsKt.isNativeId(graphQLFieldDefinition3) : false;
            if (bl2) {
                Condition condition;
                FunctionInvocation id = ExtensionFunctionsKt.id(propertyContainer);
                String[] stringArray = new String[]{variablePrefix, queriedField, suffix};
                Parameter<?> parameter = ExtensionFunctionsKt.queryParameter(value, stringArray);
                if (this.list) {
                    SymbolicName symbolicName = Cypher.name((String)"id");
                    Intrinsics.checkNotNullExpressionValue((Object)symbolicName, (String)"name(...)");
                    SymbolicName idVar = symbolicName;
                    Expression[] expressionArray = new Expression[]{idVar};
                    ListComprehension listComprehension = Cypher.listWith((SymbolicName)idVar).in((Expression)parameter).returning(expressionArray);
                    Intrinsics.checkNotNullExpressionValue((Object)listComprehension, (String)"returning(...)");
                    condition = (Condition)this.conditionCreator.invoke((Object)id, (Object)listComprehension);
                } else {
                    condition = (Condition)this.conditionCreator.invoke((Object)id, parameter);
                }
                Condition condition2 = condition;
                list = CollectionsKt.listOf((Object)condition2);
            } else {
                Object object = field;
                if (object == null || (object = GraphQLExtensionsKt.propertyName(object)) == null) {
                    object = queriedField;
                }
                Property property = propertyContainer.property((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
                list = this.resolveCondition(variablePrefix, queriedField, property, value, suffix);
            }
        }
        return list;
    }

    public static /* synthetic */ List resolveCondition$default(FieldOperator fieldOperator, String string, String string2, PropertyContainer propertyContainer, GraphQLFieldDefinition graphQLFieldDefinition, Object object, SchemaConfig schemaConfig, String string3, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveCondition");
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        return fieldOperator.resolveCondition(string, string2, propertyContainer, graphQLFieldDefinition, object, schemaConfig, string3);
    }

    private final List<Condition> resolveNeo4jTypeConditions(String variablePrefix, String queriedField, PropertyContainer propertyContainer, GraphQLFieldDefinition field, Map<?, ?> values, String suffix) {
        Neo4jSimpleConverter neo4jTypeConverter = Neo4jTypesKt.getNeo4jTypeConverter(field);
        List conditions = new ArrayList();
        if (this.distance) {
            Object object = new String[]{variablePrefix, queriedField, suffix};
            Parameter<?> parameter = ExtensionFunctionsKt.queryParameter(values, (String[])object);
            object = conditions;
            Intrinsics.checkNotNull((Object)neo4jTypeConverter, (String)"null cannot be cast to non-null type org.neo4j.graphql.Neo4jPointConverter");
            Neo4jPointConverter neo4jPointConverter = (Neo4jPointConverter)neo4jTypeConverter;
            Property property = propertyContainer.property(GraphQLExtensionsKt.propertyName(field));
            Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
            object.add(neo4jPointConverter.createDistanceCondition((Expression)property, parameter, this.conditionCreator));
        } else {
            Iterable $this$forEachIndexed$iv = values.entrySet();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Map.Entry entry = (Map.Entry)item$iv;
                int index = n;
                boolean bl = false;
                Object key = entry.getKey();
                Object value = entry.getValue();
                String fieldName = String.valueOf(key);
                String[] stringArray = new String[]{variablePrefix, queriedField, values.size() > 1 ? "And" + (index + 1) : null, suffix, fieldName};
                Parameter parameter = ExtensionFunctionsKt.queryParameter(value, stringArray).withValue(value);
                Collection collection = conditions;
                Intrinsics.checkNotNull((Object)parameter);
                collection.add(neo4jTypeConverter.createCondition(fieldName, field, parameter, this.conditionCreator, propertyContainer));
            }
        }
        return conditions;
    }

    private final List<Condition> resolveCondition(String variablePrefix, String queriedField, Property property, Object value, String suffix) {
        String[] stringArray = new String[]{variablePrefix, queriedField, suffix};
        Parameter<?> parameter = ExtensionFunctionsKt.queryParameter(value, stringArray);
        Condition condition = (Condition)this.conditionCreator.invoke((Object)property, parameter);
        return CollectionsKt.listOf((Object)condition);
    }

    @NotNull
    public final String fieldName(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return fieldName + this.suffix;
    }

    public static FieldOperator[] values() {
        return (FieldOperator[])$VALUES.clone();
    }

    public static FieldOperator valueOf(String value) {
        return Enum.valueOf(FieldOperator.class, value);
    }

    @NotNull
    public static EnumEntries<FieldOperator> getEntries() {
        return $ENTRIES;
    }

    static {
        EQ = new FieldOperator("EQ", 0, "", 1.INSTANCE, false, false, false, false, 60, null);
        IS_NULL = new FieldOperator("IS_NULL", 1, "", 2.INSTANCE, false, false, false, false, 52, null);
        IS_NOT_NULL = new FieldOperator("IS_NOT_NULL", 2, "_not", 3.INSTANCE, true, false, false, false, 48, null);
        NEQ = new FieldOperator("NEQ", 3, "_not", 4.INSTANCE, true, false, false, false, 56, null);
        GTE = new FieldOperator("GTE", 4, "_gte", 5.INSTANCE, false, false, false, false, 60, null);
        GT = new FieldOperator("GT", 5, "_gt", 6.INSTANCE, false, false, false, false, 60, null);
        LTE = new FieldOperator("LTE", 6, "_lte", 7.INSTANCE, false, false, false, false, 60, null);
        LT = new FieldOperator("LT", 7, "_lt", 8.INSTANCE, false, false, false, false, 60, null);
        NIN = new FieldOperator("NIN", 8, "_not_in", 9.INSTANCE, true, false, false, true, 24, null);
        IN = new FieldOperator("IN", 9, "_in", 10.INSTANCE, false, false, false, true, 28, null);
        NC = new FieldOperator("NC", 10, "_not_contains", 11.INSTANCE, true, false, false, false, 56, null);
        NSW = new FieldOperator("NSW", 11, "_not_starts_with", 12.INSTANCE, true, false, false, false, 56, null);
        NEW = new FieldOperator("NEW", 12, "_not_ends_with", 13.INSTANCE, true, false, false, false, 56, null);
        C = new FieldOperator("C", 13, "_contains", 14.INSTANCE, false, false, false, false, 60, null);
        SW = new FieldOperator("SW", 14, "_starts_with", 15.INSTANCE, false, false, false, false, 60, null);
        EW = new FieldOperator("EW", 15, "_ends_with", 16.INSTANCE, false, false, false, false, 60, null);
        MATCHES = new FieldOperator("MATCHES", 16, "_matches", 17.INSTANCE, false, false, false, false, 60, null);
        INCLUDES_ALL = new FieldOperator("INCLUDES_ALL", 17, "_includes_all", PredicatesKt.access$createArrayPredicate(18.INSTANCE), false, false, false, true, 28, null);
        INCLUDES_SOME = new FieldOperator("INCLUDES_SOME", 18, "_includes_some", PredicatesKt.access$createArrayPredicate(19.INSTANCE), false, false, false, true, 28, null);
        INCLUDES_NONE = new FieldOperator("INCLUDES_NONE", 19, "_includes_none", PredicatesKt.access$createArrayPredicate(20.INSTANCE), false, false, false, true, 28, null);
        INCLUDES_SINGLE = new FieldOperator("INCLUDES_SINGLE", 20, "_includes_single", PredicatesKt.access$createArrayPredicate(21.INSTANCE), false, false, false, true, 28, null);
        DISTANCE = new FieldOperator("DISTANCE", 21, "_distance", 22.INSTANCE, false, false, true, false, 44, null);
        DISTANCE_LT = new FieldOperator("DISTANCE_LT", 22, "_distance_lt", 23.INSTANCE, false, false, true, false, 44, null);
        DISTANCE_LTE = new FieldOperator("DISTANCE_LTE", 23, "_distance_lte", 24.INSTANCE, false, false, true, false, 44, null);
        DISTANCE_GT = new FieldOperator("DISTANCE_GT", 24, "_distance_gt", 25.INSTANCE, false, false, true, false, 44, null);
        DISTANCE_GTE = new FieldOperator("DISTANCE_GTE", 25, "_distance_gte", 26.INSTANCE, false, false, true, false, 44, null);
        $VALUES = fieldOperatorArray = new FieldOperator[]{FieldOperator.EQ, FieldOperator.IS_NULL, FieldOperator.IS_NOT_NULL, FieldOperator.NEQ, FieldOperator.GTE, FieldOperator.GT, FieldOperator.LTE, FieldOperator.LT, FieldOperator.NIN, FieldOperator.IN, FieldOperator.NC, FieldOperator.NSW, FieldOperator.NEW, FieldOperator.C, FieldOperator.SW, FieldOperator.EW, FieldOperator.MATCHES, FieldOperator.INCLUDES_ALL, FieldOperator.INCLUDES_SOME, FieldOperator.INCLUDES_NONE, FieldOperator.INCLUDES_SINGLE, FieldOperator.DISTANCE, FieldOperator.DISTANCE_LT, FieldOperator.DISTANCE_LTE, FieldOperator.DISTANCE_GT, FieldOperator.DISTANCE_GTE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/neo4j/graphql/FieldOperator$Companion;", "", "()V", "forType", "", "Lorg/neo4j/graphql/FieldOperator;", "type", "Lgraphql/language/TypeDefinition;", "isNeo4jType", "", "isList", "neo4j-graphql-java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FieldOperator> forType(@NotNull TypeDefinition<?> type, boolean isNeo4jType, boolean isList) {
            List list;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            if (isList) {
                FieldOperator[] fieldOperatorArray = new FieldOperator[]{EQ, NEQ, INCLUDES_ALL, INCLUDES_NONE, INCLUDES_SOME, INCLUDES_SINGLE};
                list = CollectionsKt.listOf((Object[])fieldOperatorArray);
            } else if (Intrinsics.areEqual((Object)type.getName(), (Object)GraphQLExtensionsKt.getTypeBoolean().getName())) {
                FieldOperator[] fieldOperatorArray = new FieldOperator[]{EQ, NEQ};
                list = CollectionsKt.listOf((Object[])fieldOperatorArray);
            } else if (Intrinsics.areEqual((Object)type.getName(), (Object)"_Neo4jPointDistanceFilter")) {
                FieldOperator[] fieldOperatorArray = new FieldOperator[]{EQ, LT, LTE, GT, GTE};
                list = CollectionsKt.listOf((Object[])fieldOperatorArray);
            } else if (GraphQLExtensionsKt.isNeo4jSpatialType(type)) {
                FieldOperator[] fieldOperatorArray = new FieldOperator[]{EQ, NEQ};
                list = CollectionsKt.listOf((Object[])fieldOperatorArray);
            } else if (isNeo4jType) {
                FieldOperator[] fieldOperatorArray = new FieldOperator[]{EQ, NEQ, IN, NIN};
                list = CollectionsKt.listOf((Object[])fieldOperatorArray);
            } else {
                if (type instanceof ImplementingTypeDefinition) {
                    throw new IllegalArgumentException("This operators are not for relations, use the RelationOperator instead");
                }
                if (type instanceof EnumTypeDefinition) {
                    FieldOperator[] fieldOperatorArray = new FieldOperator[]{EQ, NEQ, IN, NIN};
                    list = CollectionsKt.listOf((Object[])fieldOperatorArray);
                } else if (!(type instanceof ScalarTypeDefinition)) {
                    FieldOperator[] fieldOperatorArray = new FieldOperator[]{EQ, NEQ, IN, NIN};
                    list = CollectionsKt.listOf((Object[])fieldOperatorArray);
                } else {
                    List list2;
                    FieldOperator[] fieldOperatorArray = new FieldOperator[]{EQ, NEQ, IN, NIN, LT, LTE, GT, GTE};
                    Collection collection = CollectionsKt.listOf((Object[])fieldOperatorArray);
                    if (Intrinsics.areEqual((Object)((ScalarTypeDefinition)type).getName(), (Object)"String") || Intrinsics.areEqual((Object)((ScalarTypeDefinition)type).getName(), (Object)"ID")) {
                        fieldOperatorArray = new FieldOperator[]{C, NC, SW, NSW, EW, NEW, MATCHES};
                        list2 = CollectionsKt.listOf((Object[])fieldOperatorArray);
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    list = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                }
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

