/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql;

import graphql.GraphQLContext;
import graphql.Scalars;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectivesContainer;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.InputValueWithState;
import graphql.schema.SelectedField;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.graphql.CypherDirective;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.Neo4jTypesKt;
import org.neo4j.graphql.QueryContext;
import org.neo4j.graphql.RelationshipInfo;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00cc\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a.\u0010\u0012\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\n\u0010\u0015\u001a\u00020\u000e*\u00020\u0016\u001a\n\u0010\u0015\u001a\u00020\u000e*\u00020\u0017\u001a\u0012\u0010\u0018\u001a\u00020\u000e*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000e\u001a\u0012\u0010\u0018\u001a\u00020\u000e*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u000e*\u00020\u001d\u001a+\u0010\u001f\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 *\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\n\b\u0002\u0010#\u001a\u0004\u0018\u0001H \u00a2\u0006\u0002\u0010$\u001a\u0018\u0010%\u001a\u0004\u0018\u00010&*\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020\u000e\u001a?\u0010)\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 *\u0006\u0012\u0002\b\u00030'2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\n\b\u0002\u0010#\u001a\u0004\u0018\u0001H \u00a2\u0006\u0002\u0010-\u001a1\u0010)\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 *\u00020.2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u0001H \u00a2\u0006\u0002\u0010/\u001a\f\u00100\u001a\u0004\u0018\u00010\u001d*\u000201\u001a\n\u00102\u001a\u000201*\u000203\u001a)\u00104\u001a\u0002H \"\u0004\b\u0000\u0010 *\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\n\b\u0002\u0010#\u001a\u0004\u0018\u0001H \u00a2\u0006\u0002\u0010$\u001a=\u00105\u001a\u0002H \"\u0004\b\u0000\u0010 *\u0006\u0012\u0002\b\u00030'2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\n\b\u0002\u0010#\u001a\u0004\u0018\u0001H \u00a2\u0006\u0002\u0010-\u001a\u0014\u00106\u001a\u0004\u0018\u00010\u000e*\u00020+2\u0006\u0010(\u001a\u00020\u000e\u001a\u0016\u00107\u001a\u0004\u0018\u00010\u001d*\u0002012\b\u0010(\u001a\u0004\u0018\u00010\u000e\u001a\u0018\u00108\u001a\u0010\u0012\f\u0012\n :*\u0004\u0018\u00010\u001d0\u001d09*\u000201\u001a\u0018\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000e09*\u0002012\u0006\u0010<\u001a\u00020=\u001a\u0012\u0010>\u001a\u0006\u0012\u0002\b\u00030?*\u0006\u0012\u0002\b\u00030?\u001a\n\u0010>\u001a\u000203*\u000203\u001a\n\u0010@\u001a\u00020\u000e*\u000203\u001a\n\u0010A\u001a\u00020\u0014*\u00020\u001d\u001a\n\u0010B\u001a\u00020\u0014*\u00020C\u001a\n\u0010B\u001a\u00020\u0014*\u00020\u001d\u001a\u000e\u0010\u0013\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030?\u001a\n\u0010\u0013\u001a\u00020\u0014*\u000203\u001a\n\u0010D\u001a\u00020\u0014*\u00020\u001d\u001a\u000e\u0010E\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030F\u001a\n\u0010G\u001a\u00020\u0014*\u00020\u001d\u001a\n\u0010G\u001a\u00020\u0014*\u000203\u001a\n\u0010H\u001a\u00020\u0014*\u00020\u001d\u001a\n\u0010H\u001a\u00020\u0014*\u000203\u001a\n\u0010I\u001a\u00020\u0014*\u000201\u001a\n\u0010J\u001a\u00020\u0014*\u00020\u001d\u001a\n\u0010K\u001a\u00020\u000e*\u000201\u001a\n\u0010L\u001a\u00020\u000e*\u00020M\u001a\n\u0010N\u001a\u00020\u000e*\u00020+\u001a\u0010\u0010(\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030?\u001a\f\u0010(\u001a\u0004\u0018\u00010\u000e*\u000203\u001a\n\u0010O\u001a\u00020\u000e*\u00020\u001d\u001a\n\u0010P\u001a\u00020Q*\u00020M\u001a\n\u0010R\u001a\u00020\u000e*\u00020+\u001a\n\u0010S\u001a\u000203*\u000203\u001a\u0012\u0010T\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010U*\u000201\u001a\u001a\u0010V\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010U*\u0002012\u0006\u0010(\u001a\u00020\u000e\u001a\n\u0010W\u001a\u00020\u000e*\u000203\u001a\u0012\u0010X\u001a\u00020Y*\u00020Y2\u0006\u0010Z\u001a\u00020Q\u001a\n\u0010[\u001a\u00020\u000e*\u00020+\u001a\u0010\u0010\\\u001a\u0004\u0018\u00010]*\u0006\u0012\u0002\b\u00030^\u001a\f\u0010\\\u001a\u0004\u0018\u00010]*\u00020]\u001a\n\u0010_\u001a\u000201*\u00020M\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\u00a8\u0006`"}, d2={"TypeBoolean", "Lgraphql/language/TypeName;", "getTypeBoolean", "()Lgraphql/language/TypeName;", "TypeFloat", "getTypeFloat", "TypeID", "getTypeID", "TypeInt", "getTypeInt", "addArrayFilterField", "", "Lgraphql/language/InputObjectTypeDefinition$Builder;", "fieldName", "", "filterType", "description", "Lgraphql/language/Description;", "addFilterField", "isList", "", "aliasOrName", "Lgraphql/language/Field;", "Lgraphql/schema/SelectedField;", "contextualize", "variable", "Lorg/neo4j/cypherdsl/core/SymbolicName;", "cypherDirective", "Lorg/neo4j/graphql/CypherDirective;", "Lgraphql/schema/GraphQLFieldDefinition;", "dynamicPrefix", "getArgument", "T", "Lgraphql/schema/GraphQLAppliedDirective;", "argumentName", "defaultValue", "(Lgraphql/schema/GraphQLAppliedDirective;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getDirective", "Lgraphql/language/Directive;", "Lgraphql/language/DirectivesContainer;", "name", "getDirectiveArgument", "typeRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "directiveName", "(Lgraphql/language/DirectivesContainer;Lgraphql/schema/idl/TypeDefinitionRegistry;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "Lgraphql/schema/GraphQLDirectiveContainer;", "(Lgraphql/schema/GraphQLDirectiveContainer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getIdField", "Lgraphql/schema/GraphQLFieldsContainer;", "getInnerFieldsContainer", "Lgraphql/schema/GraphQLType;", "getMandatoryArgument", "getMandatoryDirectiveArgument", "getOperationType", "getRelevantFieldDefinition", "getRelevantFieldDefinitions", "", "kotlin.jvm.PlatformType", "getValidTypeLabels", "schema", "Lgraphql/schema/GraphQLSchema;", "inner", "Lgraphql/language/Type;", "innerName", "isID", "isIgnored", "Lgraphql/language/FieldDefinition;", "isNativeId", "isNeo4jSpatialType", "Lgraphql/language/TypeDefinition;", "isNeo4jTemporalType", "isNeo4jType", "isRelationType", "isRelationship", "label", "logField", "Lgraphql/schema/DataFetchingEnvironment;", "mutationTypeName", "propertyName", "queryContext", "Lorg/neo4j/graphql/QueryContext;", "queryTypeName", "ref", "relationship", "Lorg/neo4j/graphql/RelationshipInfo;", "relationshipFor", "requiredName", "setQueryContext", "Lgraphql/GraphQLContext;", "ctx", "subscriptionTypeName", "toJavaValue", "", "Lgraphql/language/Value;", "typeAsContainer", "neo4j-graphql-java"})
@SourceDebugExtension(value={"SMAP\nGraphQLExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLExtensions.kt\norg/neo4j/graphql/GraphQLExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1#2:258\n1#2:269\n1603#3,9:259\n1855#3:268\n1856#3:270\n1612#3:271\n288#3,2:272\n1549#3:274\n1620#3,3:275\n1179#3,2:278\n1253#3,4:280\n819#3:284\n847#3,2:285\n288#3,2:287\n*S KotlinDebug\n*F\n+ 1 GraphQLExtensions.kt\norg/neo4j/graphql/GraphQLExtensionsKt\n*L\n87#1:269\n87#1:259,9\n87#1:268\n87#1:270\n87#1:271\n142#1:272,2\n189#1:274\n189#1:275,3\n190#1:278,2\n190#1:280,4\n204#1:284\n204#1:285,2\n241#1:287,2\n*E\n"})
public final class GraphQLExtensionsKt {
    @NotNull
    private static final TypeName TypeInt = new TypeName("Int");
    @NotNull
    private static final TypeName TypeFloat = new TypeName("Float");
    @NotNull
    private static final TypeName TypeBoolean = new TypeName("Boolean");
    @NotNull
    private static final TypeName TypeID = new TypeName("ID");

    @Nullable
    public static final String name(@NotNull Type<?> $this$name) {
        String string;
        Intrinsics.checkNotNullParameter($this$name, (String)"<this>");
        if (GraphQLExtensionsKt.inner($this$name) instanceof TypeName) {
            Type<?> type = GraphQLExtensionsKt.inner($this$name);
            Intrinsics.checkNotNull(type, (String)"null cannot be cast to non-null type graphql.language.TypeName");
            string = ((TypeName)type).getName();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final Type<?> inner(@NotNull Type<?> $this$inner) {
        Type<?> type;
        Intrinsics.checkNotNullParameter($this$inner, (String)"<this>");
        Type<?> type2 = $this$inner;
        if (type2 instanceof ListType) {
            Type type3 = ((ListType)$this$inner).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"getType(...)");
            type = GraphQLExtensionsKt.inner(type3);
        } else if (type2 instanceof NonNullType) {
            Type type4 = ((NonNullType)$this$inner).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"getType(...)");
            type = GraphQLExtensionsKt.inner(type4);
        } else {
            type = $this$inner;
        }
        return type;
    }

    public static final boolean isList(@NotNull Type<?> $this$isList) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isList, (String)"<this>");
        Type<?> type = $this$isList;
        if (type instanceof ListType) {
            bl = true;
        } else if (type instanceof NonNullType) {
            Type type2 = ((NonNullType)$this$isList).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
            bl = GraphQLExtensionsKt.isList(type2);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final GraphQLType inner(@NotNull GraphQLType $this$inner) {
        GraphQLType graphQLType;
        Intrinsics.checkNotNullParameter((Object)$this$inner, (String)"<this>");
        GraphQLType graphQLType2 = $this$inner;
        if (graphQLType2 instanceof GraphQLList) {
            GraphQLType graphQLType3 = ((GraphQLList)$this$inner).getWrappedType();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLType3, (String)"getWrappedType(...)");
            graphQLType = GraphQLExtensionsKt.inner(graphQLType3);
        } else if (graphQLType2 instanceof GraphQLNonNull) {
            GraphQLType graphQLType4 = ((GraphQLNonNull)$this$inner).getWrappedType();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLType4, (String)"getWrappedType(...)");
            graphQLType = GraphQLExtensionsKt.inner(graphQLType4);
        } else {
            graphQLType = $this$inner;
        }
        return graphQLType;
    }

    @Nullable
    public static final String name(@NotNull GraphQLType $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        GraphQLNamedType graphQLNamedType = $this$name instanceof GraphQLNamedType ? (GraphQLNamedType)$this$name : null;
        return graphQLNamedType != null ? graphQLNamedType.getName() : null;
    }

    @NotNull
    public static final String requiredName(@NotNull GraphQLType $this$requiredName) {
        Intrinsics.checkNotNullParameter((Object)$this$requiredName, (String)"<this>");
        String string = GraphQLExtensionsKt.name($this$requiredName);
        if (string == null) {
            boolean bl = false;
            String string2 = "name is required but cannot be determined for " + $this$requiredName.getClass();
            throw new IllegalArgumentException(string2.toString());
        }
        return string;
    }

    public static final boolean isList(@NotNull GraphQLType $this$isList) {
        Intrinsics.checkNotNullParameter((Object)$this$isList, (String)"<this>");
        return $this$isList instanceof GraphQLList || $this$isList instanceof GraphQLNonNull && ((GraphQLNonNull)$this$isList).getWrappedType() instanceof GraphQLList;
    }

    public static final boolean isNeo4jType(@NotNull GraphQLType $this$isNeo4jType) {
        Intrinsics.checkNotNullParameter((Object)$this$isNeo4jType, (String)"<this>");
        return StringsKt.startsWith$default((String)GraphQLExtensionsKt.innerName($this$isNeo4jType), (String)"_Neo4j", (boolean)false, (int)2, null);
    }

    public static final boolean isNeo4jTemporalType(@NotNull GraphQLType $this$isNeo4jTemporalType) {
        Intrinsics.checkNotNullParameter((Object)$this$isNeo4jTemporalType, (String)"<this>");
        return Neo4jTypesKt.getNEO4j_TEMPORAL_TYPES().contains(GraphQLExtensionsKt.innerName($this$isNeo4jTemporalType));
    }

    public static final boolean isNeo4jSpatialType(@NotNull TypeDefinition<?> $this$isNeo4jSpatialType) {
        Intrinsics.checkNotNullParameter($this$isNeo4jSpatialType, (String)"<this>");
        String string = $this$isNeo4jSpatialType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)"_Neo4jPoint", (boolean)false, (int)2, null);
    }

    public static final boolean isNeo4jType(@NotNull GraphQLFieldDefinition $this$isNeo4jType) {
        Intrinsics.checkNotNullParameter((Object)$this$isNeo4jType, (String)"<this>");
        GraphQLOutputType graphQLOutputType = $this$isNeo4jType.getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getType(...)");
        return GraphQLExtensionsKt.isNeo4jType((GraphQLType)graphQLOutputType);
    }

    public static final boolean isNeo4jTemporalType(@NotNull GraphQLFieldDefinition $this$isNeo4jTemporalType) {
        Intrinsics.checkNotNullParameter((Object)$this$isNeo4jTemporalType, (String)"<this>");
        GraphQLOutputType graphQLOutputType = $this$isNeo4jTemporalType.getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getType(...)");
        return GraphQLExtensionsKt.isNeo4jTemporalType((GraphQLType)graphQLOutputType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRelationship(@NotNull GraphQLFieldDefinition $this$isRelationship) {
        Intrinsics.checkNotNullParameter((Object)$this$isRelationship, (String)"<this>");
        GraphQLOutputType graphQLOutputType = $this$isRelationship.getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getType(...)");
        if (GraphQLExtensionsKt.isNeo4jType((GraphQLType)graphQLOutputType)) return false;
        GraphQLOutputType graphQLOutputType2 = $this$isRelationship.getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType2, (String)"getType(...)");
        GraphQLType it = GraphQLExtensionsKt.inner((GraphQLType)graphQLOutputType2);
        boolean bl = false;
        if (!(it instanceof GraphQLFieldsContainer)) return false;
        return true;
    }

    public static final boolean isRelationType(@NotNull GraphQLFieldsContainer $this$isRelationType) {
        Intrinsics.checkNotNullParameter((Object)$this$isRelationType, (String)"<this>");
        GraphQLDirectiveContainer graphQLDirectiveContainer = $this$isRelationType instanceof GraphQLDirectiveContainer ? (GraphQLDirectiveContainer)$this$isRelationType : null;
        return (graphQLDirectiveContainer != null ? graphQLDirectiveContainer.getAppliedDirective("relation") : null) != null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final RelationshipInfo<GraphQLFieldsContainer> relationshipFor(@NotNull GraphQLFieldsContainer $this$relationshipFor, @NotNull String name) {
        block8: {
            block6: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)$this$relationshipFor, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    v0 = GraphQLExtensionsKt.getRelevantFieldDefinition($this$relationshipFor, name);
                    if (v0 == null) {
                        throw new IllegalArgumentException(name + " is not defined on " + $this$relationshipFor.getName());
                    }
                    field = v0;
                    v1 = field.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getType(...)");
                    var5_3 = GraphQLExtensionsKt.inner((GraphQLType)v1);
                    v2 = var5_3 instanceof GraphQLImplementingType != false ? (GraphQLImplementingType)var5_3 : null;
                    if (v2 == null) {
                        return null;
                    }
                    fieldObjectType = v2;
                    if (!GraphQLExtensionsKt.isRelationType($this$relationshipFor)) break block6;
                    v3 = $this$relationshipFor.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
                    typeName /* !! */  = v3;
                    v4 = var6_5 = $this$relationshipFor instanceof GraphQLDirectiveContainer != false ? (GraphQLDirectiveContainer)$this$relationshipFor : null;
                    if (var6_5 == null || (var7_7 = var6_5.getAppliedDirective("relation")) == null) break block7;
                    it = var7_7;
                    $i$a$-let-GraphQLExtensionsKt$relationshipFor$1 = false;
                    v5 = GraphQLExtensionsKt.getRelevantFieldDefinition((GraphQLFieldsContainer)fieldObjectType, GraphQLExtensionsKt.getArgument(it, "to", null));
                    var8_11 = TuplesKt.to((Object)it, (Object)Intrinsics.areEqual((Object)(v5 != null ? v5.getName() : null), (Object)typeName /* !! */ ));
                    if (var8_11 == null) break block7;
                    v6 = var8_11;
                    break block8;
                }
                throw new IllegalStateException("Type " + $this$relationshipFor.getName() + " needs an @relation directive");
            }
            v7 = typeName /* !! */  = fieldObjectType instanceof GraphQLDirectiveContainer != false ? (GraphQLDirectiveContainer)fieldObjectType : null;
            if (typeName /* !! */  == null || (var6_5 = typeName /* !! */ .getAppliedDirective("relation")) == null) ** GOTO lbl-1000
            it = var6_5;
            $i$a$-let-GraphQLExtensionsKt$relationshipFor$2 = false;
            var7_7 = TuplesKt.to((Object)it, (Object)true);
            if (var7_7 != null) {
                v6 = var7_7;
            } else lbl-1000:
            // 2 sources

            {
                v8 = field.getAppliedDirective("relation");
                if (v8 != null) {
                    it = v8;
                    $i$a$-let-GraphQLExtensionsKt$relationshipFor$3 = false;
                    v6 = TuplesKt.to((Object)it, (Object)false);
                } else {
                    throw new IllegalStateException("Field " + field + " needs an @relation directive");
                }
            }
        }
        var4_13 = v6;
        relDirective = (GraphQLAppliedDirective)var4_13.component1();
        inverse = (Boolean)var4_13.component2();
        relInfo = RelationshipInfo.Companion.create((GraphQLFieldsContainer)fieldObjectType, relDirective);
        return inverse != false ? RelationshipInfo.copy$default(relInfo, null, null, null, relInfo.getDirection().invert(), relInfo.getEndField(), relInfo.getStartField(), 7, null) : relInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getValidTypeLabels(@NotNull GraphQLFieldsContainer $this$getValidTypeLabels, @NotNull GraphQLSchema schema) {
        Intrinsics.checkNotNullParameter((Object)$this$getValidTypeLabels, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if ($this$getValidTypeLabels instanceof GraphQLObjectType) {
            return CollectionsKt.listOf((Object)GraphQLExtensionsKt.label($this$getValidTypeLabels));
        }
        if ($this$getValidTypeLabels instanceof GraphQLInterfaceType) {
            void $this$mapNotNullTo$iv$iv;
            List list = schema.getImplementations((GraphQLInterfaceType)$this$getValidTypeLabels);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getImplementations(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                GraphQLObjectType it = (GraphQLObjectType)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (GraphQLExtensionsKt.label((GraphQLFieldsContainer)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final String label(@NotNull GraphQLFieldsContainer $this$label) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$label, (String)"<this>");
        if (GraphQLExtensionsKt.isRelationType($this$label)) {
            String string2;
            Object object;
            Object object2;
            InputValueWithState inputValueWithState;
            GraphQLAppliedDirectiveArgument graphQLAppliedDirectiveArgument;
            GraphQLAppliedDirective graphQLAppliedDirective;
            GraphQLDirectiveContainer graphQLDirectiveContainer;
            GraphQLDirectiveContainer graphQLDirectiveContainer2 = graphQLDirectiveContainer = $this$label instanceof GraphQLDirectiveContainer ? (GraphQLDirectiveContainer)$this$label : null;
            if (graphQLDirectiveContainer != null && (graphQLAppliedDirective = graphQLDirectiveContainer.getAppliedDirective("relation")) != null && (graphQLAppliedDirectiveArgument = graphQLAppliedDirective.getArgument("name")) != null && (inputValueWithState = graphQLAppliedDirectiveArgument.getArgumentValue()) != null && (object2 = inputValueWithState.getValue()) != null && (object = GraphQLExtensionsKt.toJavaValue(object2)) != null && (string2 = object.toString()) != null) {
                string = string2;
            } else {
                String string3 = $this$label.getName();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            }
        } else {
            String string4 = $this$label.getName();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        }
        return string;
    }

    @Nullable
    public static final RelationshipInfo<GraphQLFieldsContainer> relationship(@NotNull GraphQLFieldsContainer $this$relationship) {
        Intrinsics.checkNotNullParameter((Object)$this$relationship, (String)"<this>");
        return RelationshipInfo.Companion.create($this$relationship);
    }

    @NotNull
    public static final GraphQLType ref(@NotNull GraphQLType $this$ref) {
        GraphQLType graphQLType;
        Intrinsics.checkNotNullParameter((Object)$this$ref, (String)"<this>");
        GraphQLType graphQLType2 = $this$ref;
        if (graphQLType2 instanceof GraphQLNonNull) {
            GraphQLType graphQLType3 = ((GraphQLNonNull)$this$ref).getWrappedType();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLType3, (String)"getWrappedType(...)");
            graphQLType = (GraphQLType)new GraphQLNonNull(GraphQLExtensionsKt.ref(graphQLType3));
        } else if (graphQLType2 instanceof GraphQLList) {
            GraphQLType graphQLType4 = ((GraphQLList)$this$ref).getWrappedType();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLType4, (String)"getWrappedType(...)");
            graphQLType = (GraphQLType)new GraphQLList(GraphQLExtensionsKt.ref(graphQLType4));
        } else {
            graphQLType = graphQLType2 instanceof GraphQLScalarType ? $this$ref : (graphQLType2 instanceof GraphQLEnumType ? $this$ref : (graphQLType2 instanceof GraphQLTypeReference ? $this$ref : (GraphQLType)new GraphQLTypeReference(GraphQLExtensionsKt.name($this$ref))));
        }
        return graphQLType;
    }

    @NotNull
    public static final String aliasOrName(@NotNull Field $this$aliasOrName) {
        Intrinsics.checkNotNullParameter((Object)$this$aliasOrName, (String)"<this>");
        String string = $this$aliasOrName.getAlias();
        if (string == null) {
            String string2 = $this$aliasOrName.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    @NotNull
    public static final String aliasOrName(@NotNull SelectedField $this$aliasOrName) {
        Intrinsics.checkNotNullParameter((Object)$this$aliasOrName, (String)"<this>");
        String string = $this$aliasOrName.getAlias();
        if (string == null) {
            String string2 = $this$aliasOrName.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    @NotNull
    public static final String contextualize(@NotNull SelectedField $this$contextualize, @NotNull String variable) {
        Intrinsics.checkNotNullParameter((Object)$this$contextualize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return variable + ExtensionFunctionsKt.capitalize(GraphQLExtensionsKt.aliasOrName($this$contextualize));
    }

    @NotNull
    public static final String contextualize(@NotNull SelectedField $this$contextualize, @NotNull SymbolicName variable) {
        Intrinsics.checkNotNullParameter((Object)$this$contextualize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return variable.getValue() + ExtensionFunctionsKt.capitalize(GraphQLExtensionsKt.aliasOrName($this$contextualize));
    }

    @NotNull
    public static final String innerName(@NotNull GraphQLType $this$innerName) {
        Intrinsics.checkNotNullParameter((Object)$this$innerName, (String)"<this>");
        String string = GraphQLExtensionsKt.name(GraphQLExtensionsKt.inner($this$innerName));
        if (string == null) {
            throw new IllegalStateException("inner name cannot be retrieved for " + $this$innerName.getClass());
        }
        return string;
    }

    @NotNull
    public static final String propertyName(@NotNull GraphQLFieldDefinition $this$propertyName) {
        Intrinsics.checkNotNullParameter((Object)$this$propertyName, (String)"<this>");
        String string = GraphQLExtensionsKt.getDirectiveArgument((GraphQLDirectiveContainer)$this$propertyName, "property", "name", $this$propertyName.getName());
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public static final String dynamicPrefix(@NotNull GraphQLFieldDefinition $this$dynamicPrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$dynamicPrefix, (String)"<this>");
        return GraphQLExtensionsKt.getDirectiveArgument((GraphQLDirectiveContainer)$this$dynamicPrefix, "dynamic", "prefix", null);
    }

    @NotNull
    public static final GraphQLFieldsContainer getInnerFieldsContainer(@NotNull GraphQLType $this$getInnerFieldsContainer) {
        Intrinsics.checkNotNullParameter((Object)$this$getInnerFieldsContainer, (String)"<this>");
        GraphQLType graphQLType = GraphQLExtensionsKt.inner($this$getInnerFieldsContainer);
        GraphQLFieldsContainer graphQLFieldsContainer = graphQLType instanceof GraphQLFieldsContainer ? (GraphQLFieldsContainer)graphQLType : null;
        if (graphQLFieldsContainer == null) {
            throw new IllegalArgumentException(GraphQLExtensionsKt.innerName($this$getInnerFieldsContainer) + " is neither an object nor an interface");
        }
        return graphQLFieldsContainer;
    }

    @Nullable
    public static final <T> T getDirectiveArgument(@NotNull GraphQLDirectiveContainer $this$getDirectiveArgument, @NotNull String directiveName, @NotNull String argumentName, @Nullable T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectiveArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directiveName, (String)"directiveName");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        Object object = $this$getDirectiveArgument.getAppliedDirective(directiveName);
        if (object == null || (object = GraphQLExtensionsKt.getArgument(object, argumentName, defaultValue)) == null) {
            object = defaultValue;
        }
        return (T)object;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final <T> T getDirectiveArgument(@NotNull DirectivesContainer<?> $this$getDirectiveArgument, @NotNull TypeDefinitionRegistry typeRegistry, @NotNull String directiveName, @NotNull String argumentName, @Nullable T defaultValue) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter($this$getDirectiveArgument, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)typeRegistry, (String)"typeRegistry");
                Intrinsics.checkNotNullParameter((Object)directiveName, (String)"directiveName");
                Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
                v0 = GraphQLExtensionsKt.getDirective($this$getDirectiveArgument, directiveName);
                if (v0 == null) {
                    return defaultValue;
                }
                v1 = v0.getArgument(argumentName);
                if ((v1 != null && (v1 = v1.getValue()) != null ? GraphQLExtensionsKt.toJavaValue(v1) : (v2 = null)) != null) break block6;
                var5_5 = typeRegistry.getDirectiveDefinition(directiveName);
                if (var5_5 == null || (var6_6 = (DirectiveDefinition)ExtensionFunctionsKt.unwrap(var5_5)) == null || (var7_7 = var6_6.getInputValueDefinitions()) == null) ** GOTO lbl-1000
                var10_8 = var7_7;
                for (T var12_10 : var10_8) {
                    inputValueDefinition = (InputValueDefinition)var12_10;
                    $i$a$-find-GraphQLExtensionsKt$getDirectiveArgument$1 = false;
                    if (!Intrinsics.areEqual((Object)inputValueDefinition.getName(), (Object)argumentName)) continue;
                    v3 = var12_10;
                    break block5;
                }
                v3 = null;
            }
            var8_13 = v3;
            if (var8_13 != null && (var9_14 = var8_13.getDefaultValue()) != null) {
                v4 = GraphQLExtensionsKt.toJavaValue(var9_14);
            } else lbl-1000:
            // 2 sources

            {
                v4 = v2 = null;
            }
            if (v4 == null) {
                v2 = defaultValue;
            }
        }
        return (T)v2;
    }

    public static /* synthetic */ Object getDirectiveArgument$default(DirectivesContainer directivesContainer, TypeDefinitionRegistry typeDefinitionRegistry, String string, String string2, Object object, int n, Object object2) {
        if ((n & 8) != 0) {
            object = null;
        }
        return GraphQLExtensionsKt.getDirectiveArgument(directivesContainer, typeDefinitionRegistry, string, string2, object);
    }

    @Nullable
    public static final Directive getDirective(@NotNull DirectivesContainer<?> $this$getDirective, @NotNull String name) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter($this$getDirective, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            List list = $this$getDirective.getDirectives();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDirectives(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Directive it = (Directive)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public static final <T> T getMandatoryDirectiveArgument(@NotNull DirectivesContainer<?> $this$getMandatoryDirectiveArgument, @NotNull TypeDefinitionRegistry typeRegistry, @NotNull String directiveName, @NotNull String argumentName, @Nullable T defaultValue) {
        Intrinsics.checkNotNullParameter($this$getMandatoryDirectiveArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typeRegistry, (String)"typeRegistry");
        Intrinsics.checkNotNullParameter((Object)directiveName, (String)"directiveName");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        T t = GraphQLExtensionsKt.getDirectiveArgument($this$getMandatoryDirectiveArgument, typeRegistry, directiveName, argumentName, defaultValue);
        if (t == null) {
            throw new IllegalStateException("No default value for @" + directiveName + "::" + argumentName);
        }
        return t;
    }

    public static /* synthetic */ Object getMandatoryDirectiveArgument$default(DirectivesContainer directivesContainer, TypeDefinitionRegistry typeDefinitionRegistry, String string, String string2, Object object, int n, Object object2) {
        if ((n & 8) != 0) {
            object = null;
        }
        return GraphQLExtensionsKt.getMandatoryDirectiveArgument(directivesContainer, typeDefinitionRegistry, string, string2, object);
    }

    public static final <T> T getMandatoryArgument(@NotNull GraphQLAppliedDirective $this$getMandatoryArgument, @NotNull String argumentName, @Nullable T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getMandatoryArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        T t = GraphQLExtensionsKt.getArgument($this$getMandatoryArgument, argumentName, defaultValue);
        if (t == null) {
            throw new IllegalStateException(argumentName + " is required for @" + $this$getMandatoryArgument.getName());
        }
        return t;
    }

    public static /* synthetic */ Object getMandatoryArgument$default(GraphQLAppliedDirective graphQLAppliedDirective, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return GraphQLExtensionsKt.getMandatoryArgument(graphQLAppliedDirective, string, object);
    }

    @Nullable
    public static final <T> T getArgument(@NotNull GraphQLAppliedDirective $this$getArgument, @NotNull String argumentName, @Nullable T defaultValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argumentName, (String)"argumentName");
        GraphQLAppliedDirectiveArgument argument = $this$getArgument.getArgument(argumentName);
        if (argument.getArgumentValue().isSet() && argument.getArgumentValue().getValue() != null) {
            Object object2 = argument.getArgumentValue().getValue();
            object = object2 != null ? GraphQLExtensionsKt.toJavaValue(object2) : null;
        } else {
            Argument argument2 = argument.getDefinition();
            if ((argument2 != null ? argument2.getValue() : null) != null) {
                Argument argument3 = argument.getDefinition();
                object = argument3 != null && (argument3 = argument3.getValue()) != null ? GraphQLExtensionsKt.toJavaValue(argument3) : null;
            } else {
                object = defaultValue;
                if (object == null) {
                    throw new IllegalStateException("No default value for @" + $this$getArgument.getName() + "::" + argumentName);
                }
            }
        }
        return object;
    }

    public static /* synthetic */ Object getArgument$default(GraphQLAppliedDirective graphQLAppliedDirective, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return GraphQLExtensionsKt.getArgument(graphQLAppliedDirective, string, object);
    }

    @Nullable
    public static final CypherDirective cypherDirective(@NotNull GraphQLFieldDefinition $this$cypherDirective) {
        CypherDirective cypherDirective;
        Intrinsics.checkNotNullParameter((Object)$this$cypherDirective, (String)"<this>");
        GraphQLAppliedDirective graphQLAppliedDirective = $this$cypherDirective.getAppliedDirective("cypher");
        if (graphQLAppliedDirective != null) {
            String string;
            Object[] objectArray;
            Regex regex;
            String rewrittenStatement;
            GraphQLAppliedDirective it = graphQLAppliedDirective;
            boolean bl = false;
            String originalStatement = (String)GraphQLExtensionsKt.getMandatoryArgument$default(it, "statement", null, 2, null);
            if (!Intrinsics.areEqual((Object)originalStatement, (Object)(rewrittenStatement = (regex = new Regex("\\$([_a-zA-Z]\\w*)")).replace((CharSequence)(objectArray = (Object[])originalStatement), string = "$1")))) {
                objectArray = new Object[4];
                objectArray[0] = originalStatement;
                objectArray[1] = rewrittenStatement;
                objectArray[2] = $this$cypherDirective.getName();
                FieldDefinition fieldDefinition = $this$cypherDirective.getDefinition();
                objectArray[3] = fieldDefinition != null ? fieldDefinition.getSourceLocation() : null;
                LoggerFactory.getLogger(CypherDirective.class).warn("The field arguments used in the directives statement must not contain parameters. The statement was replaced. Please adjust your GraphQl Schema.\n\tGot        : {}\n\tReplaced by: {}\n\tField      : {} ({})", objectArray);
            }
            cypherDirective = new CypherDirective(rewrittenStatement, GraphQLExtensionsKt.getMandatoryArgument(it, "passThrough", false));
        } else {
            cypherDirective = null;
        }
        return cypherDirective;
    }

    @Nullable
    public static final Object toJavaValue(@NotNull Object $this$toJavaValue) {
        Intrinsics.checkNotNullParameter((Object)$this$toJavaValue, (String)"<this>");
        return $this$toJavaValue instanceof Value ? GraphQLExtensionsKt.toJavaValue((Value)$this$toJavaValue) : $this$toJavaValue;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object toJavaValue(@NotNull Value<?> $this$toJavaValue) {
        Object object;
        Intrinsics.checkNotNullParameter($this$toJavaValue, (String)"<this>");
        Value<?> value = $this$toJavaValue;
        if (value instanceof StringValue) {
            object = ((StringValue)$this$toJavaValue).getValue();
        } else if (value instanceof EnumValue) {
            object = ((EnumValue)$this$toJavaValue).getName();
        } else if (value instanceof NullValue) {
            object = null;
        } else if (value instanceof BooleanValue) {
            object = ((BooleanValue)$this$toJavaValue).isValue();
        } else if (value instanceof FloatValue) {
            object = ((FloatValue)$this$toJavaValue).getValue().doubleValue();
        } else if (value instanceof IntValue) {
            object = ((IntValue)$this$toJavaValue).getValue().longValueExact();
        } else if (value instanceof VariableReference) {
            object = $this$toJavaValue;
        } else if (value instanceof ArrayValue) {
            void $this$mapTo$iv$iv;
            List list = ((ArrayValue)$this$toJavaValue).getValues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Value value2 = (Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(GraphQLExtensionsKt.toJavaValue(it));
            }
            object = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else if (value instanceof ObjectValue) {
            void $this$associateTo$iv$iv;
            List list = ((ObjectValue)$this$toJavaValue).getObjectFields();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getObjectFields(...)");
            Iterable $this$associate$iv = list;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                ObjectField it = (ObjectField)element$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Value value3 = it.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"getValue(...)");
                Pair pair = TuplesKt.to((Object)string, (Object)GraphQLExtensionsKt.toJavaValue(value3));
                map.put(pair.getFirst(), pair.getSecond());
            }
            object = destination$iv$iv2;
        } else {
            throw new IllegalStateException("Unhandled value " + $this$toJavaValue);
        }
        return object;
    }

    public static final boolean isID(@NotNull GraphQLFieldDefinition $this$isID) {
        Intrinsics.checkNotNullParameter((Object)$this$isID, (String)"<this>");
        GraphQLOutputType graphQLOutputType = $this$isID.getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getType(...)");
        return Intrinsics.areEqual((Object)GraphQLExtensionsKt.inner((GraphQLType)graphQLOutputType), (Object)Scalars.GraphQLID);
    }

    public static final boolean isNativeId(@NotNull GraphQLFieldDefinition $this$isNativeId) {
        Intrinsics.checkNotNullParameter((Object)$this$isNativeId, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isNativeId.getName(), (Object)"_id");
    }

    public static final boolean isIgnored(@NotNull GraphQLFieldDefinition $this$isIgnored) {
        Intrinsics.checkNotNullParameter((Object)$this$isIgnored, (String)"<this>");
        return $this$isIgnored.getDirective("ignore") != null;
    }

    public static final boolean isIgnored(@NotNull FieldDefinition $this$isIgnored) {
        Intrinsics.checkNotNullParameter((Object)$this$isIgnored, (String)"<this>");
        return $this$isIgnored.hasDirective("ignore");
    }

    @Nullable
    public static final GraphQLFieldDefinition getIdField(@NotNull GraphQLFieldsContainer $this$getIdField) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getIdField, (String)"<this>");
            Iterable iterable = GraphQLExtensionsKt.getRelevantFieldDefinitions($this$getIdField);
            for (Object t : iterable) {
                GraphQLFieldDefinition it = (GraphQLFieldDefinition)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!GraphQLExtensionsKt.isID(it)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<GraphQLFieldDefinition> getRelevantFieldDefinitions(@NotNull GraphQLFieldsContainer $this$getRelevantFieldDefinitions) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getRelevantFieldDefinitions, (String)"<this>");
        List list = $this$getRelevantFieldDefinitions.getFieldDefinitions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFieldDefinitions(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            GraphQLFieldDefinition it = (GraphQLFieldDefinition)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (GraphQLExtensionsKt.isIgnored(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final GraphQLFieldDefinition getRelevantFieldDefinition(@NotNull GraphQLFieldsContainer $this$getRelevantFieldDefinition, @Nullable String name) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getRelevantFieldDefinition, (String)"<this>");
        GraphQLFieldDefinition graphQLFieldDefinition = $this$getRelevantFieldDefinition.getFieldDefinition(name);
        if (graphQLFieldDefinition != null) {
            GraphQLFieldDefinition graphQLFieldDefinition2;
            GraphQLFieldDefinition it = graphQLFieldDefinition2 = graphQLFieldDefinition;
            boolean bl = false;
            object = !GraphQLExtensionsKt.isIgnored(it) ? graphQLFieldDefinition2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public static final void addFilterField(@NotNull InputObjectTypeDefinition.Builder $this$addFilterField, @NotNull String fieldName, boolean isList, @NotNull String filterType, @Nullable Description description) {
        Intrinsics.checkNotNullParameter((Object)$this$addFilterField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)filterType, (String)"filterType");
        Type wrappedType = isList ? (Type)new ListType((Type)new TypeName(filterType)) : (Type)new TypeName(filterType);
        InputValueDefinition.Builder inputField = InputValueDefinition.newInputValueDefinition().name(fieldName).type(wrappedType);
        if (description != null) {
            inputField.description(description);
        }
        $this$addFilterField.inputValueDefinition(inputField.build());
    }

    public static /* synthetic */ void addFilterField$default(InputObjectTypeDefinition.Builder builder, String string, boolean bl, String string2, Description description, int n, Object object) {
        if ((n & 8) != 0) {
            description = null;
        }
        GraphQLExtensionsKt.addFilterField(builder, string, bl, string2, description);
    }

    public static final void addArrayFilterField(@NotNull InputObjectTypeDefinition.Builder $this$addArrayFilterField, @NotNull String fieldName, @NotNull String filterType, @Nullable Description description) {
        Intrinsics.checkNotNullParameter((Object)$this$addArrayFilterField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)filterType, (String)"filterType");
        InputValueDefinition.Builder inputField = InputValueDefinition.newInputValueDefinition().name(fieldName).type((Type)new ListType((Type)new NonNullType((Type)new TypeName(filterType))));
        if (description != null) {
            inputField.description(description);
        }
        $this$addArrayFilterField.inputValueDefinition(inputField.build());
    }

    public static /* synthetic */ void addArrayFilterField$default(InputObjectTypeDefinition.Builder builder, String string, String string2, Description description, int n, Object object) {
        if ((n & 4) != 0) {
            description = null;
        }
        GraphQLExtensionsKt.addArrayFilterField(builder, string, string2, description);
    }

    @NotNull
    public static final String queryTypeName(@NotNull TypeDefinitionRegistry $this$queryTypeName) {
        Intrinsics.checkNotNullParameter((Object)$this$queryTypeName, (String)"<this>");
        String string = GraphQLExtensionsKt.getOperationType($this$queryTypeName, "query");
        if (string == null) {
            string = "Query";
        }
        return string;
    }

    @NotNull
    public static final String mutationTypeName(@NotNull TypeDefinitionRegistry $this$mutationTypeName) {
        Intrinsics.checkNotNullParameter((Object)$this$mutationTypeName, (String)"<this>");
        String string = GraphQLExtensionsKt.getOperationType($this$mutationTypeName, "mutation");
        if (string == null) {
            string = "Mutation";
        }
        return string;
    }

    @NotNull
    public static final String subscriptionTypeName(@NotNull TypeDefinitionRegistry $this$subscriptionTypeName) {
        Intrinsics.checkNotNullParameter((Object)$this$subscriptionTypeName, (String)"<this>");
        String string = GraphQLExtensionsKt.getOperationType($this$subscriptionTypeName, "subscription");
        if (string == null) {
            string = "Subscription";
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String getOperationType(@NotNull TypeDefinitionRegistry $this$getOperationType, @NotNull String name) {
        Object v4;
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getOperationType, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Optional optional = $this$getOperationType.schemaDefinition();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"schemaDefinition(...)");
            SchemaDefinition schemaDefinition = (SchemaDefinition)ExtensionFunctionsKt.unwrap(optional);
            object = schemaDefinition;
            if (schemaDefinition == null) return null;
            List list = object.getOperationTypeDefinitions();
            object = list;
            if (list == null) return null;
            Iterable $this$firstOrNull$iv = (Iterable)object;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OperationTypeDefinition it = (OperationTypeDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v4 = element$iv;
                break block1;
            }
            v4 = null;
        }
        OperationTypeDefinition operationTypeDefinition = v4;
        object = operationTypeDefinition;
        if (operationTypeDefinition == null) return null;
        TypeName typeName = object.getTypeName();
        object = typeName;
        if (typeName == null) return null;
        String string = object.getName();
        return string;
    }

    @NotNull
    public static final GraphQLFieldsContainer typeAsContainer(@NotNull DataFetchingEnvironment $this$typeAsContainer) {
        Intrinsics.checkNotNullParameter((Object)$this$typeAsContainer, (String)"<this>");
        GraphQLOutputType graphQLOutputType = $this$typeAsContainer.getFieldDefinition().getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getType(...)");
        GraphQLType graphQLType = GraphQLExtensionsKt.inner((GraphQLType)graphQLOutputType);
        GraphQLFieldsContainer graphQLFieldsContainer = graphQLType instanceof GraphQLFieldsContainer ? (GraphQLFieldsContainer)graphQLType : null;
        if (graphQLFieldsContainer == null) {
            String string = GraphQLExtensionsKt.logField($this$typeAsContainer);
            GraphQLOutputType graphQLOutputType2 = $this$typeAsContainer.getFieldDefinition().getType();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType2, (String)"getType(...)");
            throw new IllegalStateException("expect type of field " + string + " to be GraphQLFieldsContainer, but was " + GraphQLExtensionsKt.name((GraphQLType)graphQLOutputType2));
        }
        return graphQLFieldsContainer;
    }

    @NotNull
    public static final String logField(@NotNull DataFetchingEnvironment $this$logField) {
        Intrinsics.checkNotNullParameter((Object)$this$logField, (String)"<this>");
        GraphQLType graphQLType = $this$logField.getParentType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLType, (String)"getParentType(...)");
        return GraphQLExtensionsKt.name(graphQLType) + "." + $this$logField.getFieldDefinition().getName();
    }

    @NotNull
    public static final QueryContext queryContext(@NotNull DataFetchingEnvironment $this$queryContext) {
        Intrinsics.checkNotNullParameter((Object)$this$queryContext, (String)"<this>");
        QueryContext queryContext = (QueryContext)$this$queryContext.getGraphQlContext().get((Object)"Neo4jGraphQLQueryContext");
        if (queryContext == null) {
            queryContext = new QueryContext(false, null, null, 7, null);
        }
        return queryContext;
    }

    @NotNull
    public static final GraphQLContext setQueryContext(@NotNull GraphQLContext $this$setQueryContext, @NotNull QueryContext ctx) {
        Intrinsics.checkNotNullParameter((Object)$this$setQueryContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        $this$setQueryContext.put((Object)"Neo4jGraphQLQueryContext", (Object)ctx);
        return $this$setQueryContext;
    }

    @NotNull
    public static final TypeName getTypeInt() {
        return TypeInt;
    }

    @NotNull
    public static final TypeName getTypeFloat() {
        return TypeFloat;
    }

    @NotNull
    public static final TypeName getTypeBoolean() {
        return TypeBoolean;
    }

    @NotNull
    public static final TypeName getTypeID() {
        return TypeID;
    }
}

