/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql.handler;

import graphql.language.DirectivesContainer;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.graphql.AugmentationHandler;
import org.neo4j.graphql.Cypher;
import org.neo4j.graphql.CypherDirective;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.GraphQLExtensionsKt;
import org.neo4j.graphql.SchemaConfig;
import org.neo4j.graphql.handler.BaseDataFetcher;
import org.neo4j.graphql.handler.projection.ProjectionBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/neo4j/graphql/handler/CypherDirectiveHandler;", "Lorg/neo4j/graphql/handler/BaseDataFetcher;", "schemaConfig", "Lorg/neo4j/graphql/SchemaConfig;", "(Lorg/neo4j/graphql/SchemaConfig;)V", "generateCypher", "Lorg/neo4j/cypherdsl/core/Statement;", "variable", "", "field", "Lgraphql/language/Field;", "env", "Lgraphql/schema/DataFetchingEnvironment;", "Factory", "neo4j-graphql-java"})
public final class CypherDirectiveHandler
extends BaseDataFetcher {
    public CypherDirectiveHandler(@NotNull SchemaConfig schemaConfig) {
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        super(schemaConfig);
    }

    @Override
    @NotNull
    protected Statement generateCypher(@NotNull String variable, @NotNull Field field, @NotNull DataFetchingEnvironment env) {
        StatementBuilder.OngoingReadingAndReturn ongoingReadingAndReturn;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        GraphQLFieldDefinition fieldDefinition = env.getFieldDefinition();
        GraphQLOutputType graphQLOutputType = fieldDefinition.getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getType(...)");
        GraphQLType graphQLType = GraphQLExtensionsKt.inner((GraphQLType)graphQLOutputType);
        GraphQLFieldsContainer type = graphQLType instanceof GraphQLFieldsContainer ? (GraphQLFieldsContainer)graphQLType : null;
        Intrinsics.checkNotNull((Object)fieldDefinition);
        CypherDirective cypherDirective = GraphQLExtensionsKt.cypherDirective(fieldDefinition);
        if (cypherDirective == null) {
            throw new IllegalStateException("Expect field " + GraphQLExtensionsKt.logField(env) + " to have @cypher directive present");
        }
        CypherDirective cypherDirective2 = cypherDirective;
        Node node = org.neo4j.cypherdsl.core.Cypher.anyNode((String)variable);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"anyNode(...)");
        Node node2 = node;
        SymbolicName symbolicName = node2.getRequiredSymbolicName();
        Intrinsics.checkNotNullExpressionValue((Object)symbolicName, (String)"getRequiredSymbolicName(...)");
        SymbolicName ctxVariable = symbolicName;
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        ResultStatement nestedQuery = this.cypherDirective(ctxVariable, fieldDefinition, map, cypherDirective2, null);
        StatementBuilder.OngoingReadingWithoutWhere reading = org.neo4j.cypherdsl.core.Cypher.call((Statement)((Statement)nestedQuery));
        boolean bl = false;
        if (type == null || cypherDirective2.getPassThrough()) {
            Expression[] expressionArray = new Expression[]{ctxVariable.as(GraphQLExtensionsKt.aliasOrName(field))};
            ongoingReadingAndReturn = reading.returning(expressionArray);
        } else {
            Pair pair = ProjectionBase.projectFields$default(this, (PropertyContainer)node2, type, env, null, null, null, 56, null);
            List fieldProjection = (List)pair.component1();
            List nestedSubQueries = (List)pair.component2();
            Intrinsics.checkNotNull((Object)reading);
            Expression[] expressionArray = new Expression[]{ctxVariable.project(fieldProjection).as(GraphQLExtensionsKt.aliasOrName(field))};
            ongoingReadingAndReturn = ExtensionFunctionsKt.withSubQueries((StatementBuilder.OngoingReading)reading, nestedSubQueries).returning(expressionArray);
        }
        Statement statement = ongoingReadingAndReturn.build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        return statement;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/neo4j/graphql/handler/CypherDirectiveHandler$Factory;", "Lorg/neo4j/graphql/AugmentationHandler;", "schemaConfig", "Lorg/neo4j/graphql/SchemaConfig;", "typeDefinitionRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "neo4jTypeDefinitionRegistry", "(Lorg/neo4j/graphql/SchemaConfig;Lgraphql/schema/idl/TypeDefinitionRegistry;Lgraphql/schema/idl/TypeDefinitionRegistry;)V", "createDataFetcher", "Lgraphql/schema/DataFetcher;", "Lorg/neo4j/graphql/Cypher;", "operationType", "Lorg/neo4j/graphql/AugmentationHandler$OperationType;", "fieldDefinition", "Lgraphql/language/FieldDefinition;", "neo4j-graphql-java"})
    public static final class Factory
    extends AugmentationHandler {
        public Factory(@NotNull SchemaConfig schemaConfig, @NotNull TypeDefinitionRegistry typeDefinitionRegistry, @NotNull TypeDefinitionRegistry neo4jTypeDefinitionRegistry) {
            Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
            Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
            Intrinsics.checkNotNullParameter((Object)neo4jTypeDefinitionRegistry, (String)"neo4jTypeDefinitionRegistry");
            super(schemaConfig, typeDefinitionRegistry, neo4jTypeDefinitionRegistry);
        }

        @Override
        @Nullable
        public DataFetcher<Cypher> createDataFetcher(@NotNull AugmentationHandler.OperationType operationType, @NotNull FieldDefinition fieldDefinition) {
            Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
            Intrinsics.checkNotNullParameter((Object)fieldDefinition, (String)"fieldDefinition");
            if (this.cypherDirective((DirectivesContainer)fieldDefinition) == null) {
                return null;
            }
            return new CypherDirectiveHandler(this.getSchemaConfig());
        }
    }
}

