/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql.parser;

import graphql.schema.GraphQLFieldDefinition;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.FieldOperator;
import org.neo4j.graphql.SchemaConfig;
import org.neo4j.graphql.parser.Predicate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/neo4j/graphql/parser/FieldPredicate;", "Lorg/neo4j/graphql/parser/Predicate;", "Lorg/neo4j/graphql/FieldOperator;", "op", "value", "", "fieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "index", "", "(Lorg/neo4j/graphql/FieldOperator;Ljava/lang/Object;Lgraphql/schema/GraphQLFieldDefinition;I)V", "getFieldDefinition", "()Lgraphql/schema/GraphQLFieldDefinition;", "createCondition", "", "Lorg/neo4j/cypherdsl/core/Condition;", "propertyContainer", "Lorg/neo4j/cypherdsl/core/PropertyContainer;", "variablePrefix", "", "variableSuffix", "schemaConfig", "Lorg/neo4j/graphql/SchemaConfig;", "neo4j-graphql-java"})
public final class FieldPredicate
extends Predicate<FieldOperator> {
    @NotNull
    private final GraphQLFieldDefinition fieldDefinition;

    public FieldPredicate(@NotNull FieldOperator op, @Nullable Object value, @NotNull GraphQLFieldDefinition fieldDefinition, int index) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)fieldDefinition, (String)"fieldDefinition");
        String[] stringArray = new String[]{fieldDefinition.getName(), ExtensionFunctionsKt.toCamelCase(op.getSuffix())};
        super(op, value, ExtensionFunctionsKt.normalizeName(stringArray), index);
        this.fieldDefinition = fieldDefinition;
    }

    @NotNull
    public final GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    @NotNull
    public final List<Condition> createCondition(@NotNull PropertyContainer propertyContainer, @NotNull String variablePrefix, @NotNull String variableSuffix, @NotNull SchemaConfig schemaConfig) {
        Intrinsics.checkNotNullParameter((Object)propertyContainer, (String)"propertyContainer");
        Intrinsics.checkNotNullParameter((Object)variablePrefix, (String)"variablePrefix");
        Intrinsics.checkNotNullParameter((Object)variableSuffix, (String)"variableSuffix");
        Intrinsics.checkNotNullParameter((Object)schemaConfig, (String)"schemaConfig");
        return ((FieldOperator)((Object)this.getOp())).resolveCondition(variablePrefix, this.getNormalizedName(), propertyContainer, this.fieldDefinition, this.getValue(), schemaConfig, variableSuffix);
    }
}

