/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphql.parser;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.graphql.ExtensionFunctionsKt;
import org.neo4j.graphql.GraphQLExtensionsKt;
import org.neo4j.graphql.RelationOperator;
import org.neo4j.graphql.RelationshipInfo;
import org.neo4j.graphql.parser.Predicate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/neo4j/graphql/parser/RelationPredicate;", "Lorg/neo4j/graphql/parser/Predicate;", "Lorg/neo4j/graphql/RelationOperator;", "type", "Lgraphql/schema/GraphQLFieldsContainer;", "op", "value", "", "fieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "index", "", "(Lgraphql/schema/GraphQLFieldsContainer;Lorg/neo4j/graphql/RelationOperator;Ljava/lang/Object;Lgraphql/schema/GraphQLFieldDefinition;I)V", "getFieldDefinition", "()Lgraphql/schema/GraphQLFieldDefinition;", "relNode", "Lorg/neo4j/cypherdsl/core/Node;", "getRelNode", "()Lorg/neo4j/cypherdsl/core/Node;", "relationshipInfo", "Lorg/neo4j/graphql/RelationshipInfo;", "getRelationshipInfo", "()Lorg/neo4j/graphql/RelationshipInfo;", "createExistsCondition", "Lorg/neo4j/cypherdsl/core/Condition;", "propertyContainer", "Lorg/neo4j/cypherdsl/core/PropertyContainer;", "createRelation", "Lorg/neo4j/cypherdsl/core/Relationship;", "start", "neo4j-graphql-java"})
public final class RelationPredicate
extends Predicate<RelationOperator> {
    @NotNull
    private final GraphQLFieldDefinition fieldDefinition;
    @NotNull
    private final RelationshipInfo<GraphQLFieldsContainer> relationshipInfo;
    @NotNull
    private final Node relNode;

    public RelationPredicate(@NotNull GraphQLFieldsContainer type, @NotNull RelationOperator op, @Nullable Object value, @NotNull GraphQLFieldDefinition fieldDefinition, int index) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)fieldDefinition, (String)"fieldDefinition");
        String[] stringArray = new String[]{fieldDefinition.getName(), ExtensionFunctionsKt.toCamelCase(op.getSuffix())};
        super(op, value, ExtensionFunctionsKt.normalizeName(stringArray), index);
        this.fieldDefinition = fieldDefinition;
        String string = this.fieldDefinition.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        RelationshipInfo<GraphQLFieldsContainer> relationshipInfo = GraphQLExtensionsKt.relationshipFor(type, string);
        Intrinsics.checkNotNull(relationshipInfo);
        this.relationshipInfo = relationshipInfo;
        GraphQLOutputType graphQLOutputType = this.fieldDefinition.getType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getType(...)");
        Node node = Cypher.node((String)GraphQLExtensionsKt.label(GraphQLExtensionsKt.getInnerFieldsContainer((GraphQLType)graphQLOutputType)), (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node(...)");
        this.relNode = node;
    }

    @NotNull
    public final GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    @NotNull
    public final RelationshipInfo<GraphQLFieldsContainer> getRelationshipInfo() {
        return this.relationshipInfo;
    }

    @NotNull
    public final Node getRelNode() {
        return this.relNode;
    }

    @NotNull
    public final Relationship createRelation(@NotNull Node start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        return RelationshipInfo.createRelation$default(this.relationshipInfo, start, this.relNode, false, null, 12, null);
    }

    @NotNull
    public final Condition createExistsCondition(@NotNull PropertyContainer propertyContainer) {
        Condition condition;
        Intrinsics.checkNotNullParameter((Object)propertyContainer, (String)"propertyContainer");
        Node node = propertyContainer instanceof Node ? (Node)propertyContainer : null;
        if (node == null) {
            throw new IllegalStateException("propertyContainer is expected to be a Node but was " + propertyContainer.getClass().getName());
        }
        Relationship relation = this.createRelation(node);
        PatternElement[] patternElementArray = new PatternElement[]{relation};
        Condition condition2 = Cypher.match((PatternElement[])patternElementArray).asCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition2, (String)"asCondition(...)");
        Condition condition3 = condition2;
        switch (WhenMappings.$EnumSwitchMapping$0[((RelationOperator)((Object)this.getOp())).ordinal()]) {
            case 1: {
                condition = condition3;
                break;
            }
            case 2: {
                Condition condition4 = condition3.not();
                condition = condition4;
                Intrinsics.checkNotNullExpressionValue((Object)condition4, (String)"not(...)");
                break;
            }
            default: {
                throw new IllegalStateException(this.getOp() + " should not be set for Null value");
            }
        }
        return condition;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelationOperator.values().length];
            try {
                nArray[RelationOperator.NOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationOperator.EQ_OR_NOT_EXISTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

