/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.visualization.PropertyType;
import org.neo4j.visualization.graphviz.GraphStyle;
import org.neo4j.visualization.graphviz.ParameterGetter;
import org.neo4j.visualization.graphviz.PropertyFilter;
import org.neo4j.visualization.graphviz.PropertyFormatter;
import org.neo4j.visualization.graphviz.StyleConfiguration;
import org.neo4j.visualization.graphviz.StyleParameter;
import org.neo4j.visualization.graphviz.TitleGetter;

class DefaultStyleConfiguration
implements StyleConfiguration {
    boolean displayRelationshipLabel = true;
    private final Map<String, String> header;
    private final Map<String, String> nodeHeader;
    private final Map<String, String> edgeHeader;
    private final Map<String, ParameterGetter<? super Node>> nodeParams = new HashMap<String, ParameterGetter<? super Node>>();
    private final Map<String, ParameterGetter<? super Relationship>> edgeParams = new HashMap<String, ParameterGetter<? super Relationship>>();
    private PropertyFilter nodeFilter = null;
    private PropertyFilter edgeFilter = null;
    private TitleGetter<? super Node> nodeTitle = null;
    private TitleGetter<? super Relationship> edgeTitle = null;
    private PropertyFormatter nodeFormat = null;
    private PropertyFormatter edgeFormat = null;
    private Predicate<Relationship> reversedRelationshipOrder = null;

    DefaultStyleConfiguration(StyleParameter ... parameters) {
        this.nodeHeader = new HashMap<String, String>(GraphStyle.header().nodeHeader);
        this.edgeHeader = new HashMap<String, String>(GraphStyle.header().edgeHeader);
        this.header = new HashMap<String, String>(GraphStyle.header().graphHeader);
        for (StyleParameter parameter : parameters) {
            parameter.configure(this);
        }
    }

    @Override
    public String escapeLabel(String label) {
        label = label.replace("\\", "\\\\");
        label = label.replace("\"", "\\\"");
        label = label.replace("'", "\\'");
        label = label.replace("\n", "\\n");
        label = label.replace("<", "\\<");
        label = label.replace(">", "\\>");
        label = label.replace("[", "\\[");
        label = label.replace("]", "\\]");
        label = label.replace("{", "\\{");
        label = label.replace("}", "\\}");
        label = label.replace("|", "\\|");
        return label;
    }

    boolean reverseOrder(Relationship edge) {
        return this.reversedRelationshipOrder != null && this.reversedRelationshipOrder.test(edge);
    }

    void emitHeader(Appendable stream) throws IOException {
        GraphStyle.emitHeader(stream, this.header);
    }

    void emitHeaderNode(Appendable stream) throws IOException {
        GraphStyle.emitHeader(stream, this.nodeHeader);
    }

    void emitHeaderEdge(Appendable stream) throws IOException {
        GraphStyle.emitHeader(stream, this.edgeHeader);
    }

    void emit(Node node, Appendable stream) throws IOException {
        this.emit((PropertyContainer)node, this.nodeParams, stream);
    }

    void emit(Relationship edge, Appendable stream) throws IOException {
        this.emit((PropertyContainer)edge, this.edgeParams, stream);
    }

    private <C extends PropertyContainer> void emit(C container, Map<String, ParameterGetter<? super C>> params, Appendable stream) throws IOException {
        for (String key : params.keySet()) {
            String value = params.get(key).getParameterValue(container, key);
            if (value == null) continue;
            stream.append("    " + key + " = \"" + value + "\"\n");
        }
    }

    String getTitle(Node node) {
        if (this.nodeTitle != null) {
            return this.nodeTitle.getTitle((Node)node);
        }
        return node.toString();
    }

    String getTitle(Relationship edge) {
        if (this.edgeTitle != null) {
            return this.edgeTitle.getTitle((Relationship)edge);
        }
        return edge.getType().name();
    }

    boolean acceptNodeProperty(String key) {
        if (this.nodeFilter != null) {
            return this.nodeFilter.acceptProperty(key);
        }
        return true;
    }

    boolean acceptEdgeProperty(String key) {
        if (this.edgeFilter != null) {
            return this.edgeFilter.acceptProperty(key);
        }
        return true;
    }

    void emitNodeProperty(Appendable stream, String key, PropertyType type, Object value) throws IOException {
        if (this.nodeFormat != null) {
            stream.append(this.nodeFormat.format(key, type, value) + "\\l");
        } else {
            stream.append(PropertyType.format(key) + " = " + PropertyType.format(value) + " : " + type.typeName + "\\l");
        }
    }

    void emitRelationshipProperty(Appendable stream, String key, PropertyType type, Object value) throws IOException {
        if (this.edgeFormat != null) {
            stream.append(this.edgeFormat.format(key, type, value) + "\\l");
        } else {
            stream.append(PropertyType.format(key) + " = " + PropertyType.format(value) + " : " + type.typeName + "\\l");
        }
    }

    @Override
    public void setRelationshipReverseOrderPredicate(Predicate<Relationship> reversed) {
        this.reversedRelationshipOrder = reversed;
    }

    @Override
    public void setGraphProperty(String property, String value) {
        this.header.put(property, value);
    }

    @Override
    public void setDefaultNodeProperty(String property, String value) {
        this.nodeHeader.put(property, value);
    }

    @Override
    public void setDefaultRelationshipProperty(String property, String value) {
        this.edgeHeader.put(property, value);
    }

    @Override
    public void displayRelationshipLabel(boolean on) {
        this.displayRelationshipLabel = on;
    }

    @Override
    public void setNodeParameterGetter(String key, ParameterGetter<? super Node> getter) {
        this.nodeParams.put(key, getter);
    }

    @Override
    public void setNodePropertyFilter(PropertyFilter filter) {
        this.nodeFilter = filter;
    }

    @Override
    public void setNodeTitleGetter(TitleGetter<? super Node> getter) {
        this.nodeTitle = getter;
    }

    @Override
    public void setRelationshipParameterGetter(String key, ParameterGetter<? super Relationship> getter) {
        this.edgeParams.put(key, getter);
    }

    @Override
    public void setRelationshipPropertyFilter(PropertyFilter filter) {
        this.edgeFilter = filter;
    }

    @Override
    public void setRelationshipTitleGetter(TitleGetter<? super Relationship> getter) {
        this.edgeTitle = getter;
    }

    @Override
    public void setNodePropertyFomatter(PropertyFormatter format) {
        this.nodeFormat = format;
    }

    @Override
    public void setRelationshipPropertyFomatter(PropertyFormatter format) {
        this.edgeFormat = format;
    }
}

