/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.IOException;
import java.io.PrintStream;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.visualization.GraphRenderer;
import org.neo4j.visualization.PropertyRenderer;
import org.neo4j.visualization.graphviz.GraphStyle;
import org.neo4j.visualization.graphviz.NodeStyle;
import org.neo4j.visualization.graphviz.PropertyContainerStyle;
import org.neo4j.visualization.graphviz.RelationshipStyle;

class GraphvizRenderer
implements GraphRenderer<IOException> {
    private final PrintStream stream;
    private final GraphStyle graphStyle;
    private final NodeStyle nodeStyle;
    private final RelationshipStyle edgeStyle;

    GraphvizRenderer(GraphStyle style, PrintStream stream) throws IOException {
        this.stream = stream;
        this.nodeStyle = style.nodeStyle;
        this.edgeStyle = style.edgeStyle;
        this.graphStyle = style;
        this.graphStyle.emitGraphStart(stream);
    }

    @Override
    public void done() throws IOException {
        this.graphStyle.emitGraphEnd(this.stream);
    }

    @Override
    public PropertyRenderer<IOException> renderNode(Node node) throws IOException {
        return new PropertyAdapter(node);
    }

    @Override
    public PropertyRenderer<IOException> renderRelationship(Relationship relationship) throws IOException {
        return new PropertyAdapter(relationship);
    }

    public GraphvizRenderer renderSubgraph(String name) throws IOException {
        return new GraphvizRenderer(this.graphStyle.getSubgraphStyle(name), this.stream);
    }

    private class PropertyAdapter
    implements PropertyRenderer<IOException> {
        private final PropertyContainerStyle style;

        PropertyAdapter(Node node) throws IOException {
            GraphvizRenderer.this.nodeStyle.emitNodeStart(GraphvizRenderer.this.stream, node);
            this.style = GraphvizRenderer.this.nodeStyle;
        }

        PropertyAdapter(Relationship relationship) throws IOException {
            GraphvizRenderer.this.edgeStyle.emitRelationshipStart(GraphvizRenderer.this.stream, relationship);
            this.style = GraphvizRenderer.this.edgeStyle;
        }

        @Override
        public void done() throws IOException {
            this.style.emitEnd(GraphvizRenderer.this.stream);
        }

        @Override
        public void renderProperty(String propertyKey, Object propertyValue) throws IOException {
            this.style.emitProperty(GraphvizRenderer.this.stream, propertyKey, propertyValue);
        }
    }
}

