/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.com.ConnectionLostHandler;
import org.neo4j.com.MismatchingVersionHandler;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.MasterClient153;
import org.neo4j.kernel.ha.MasterClient17;
import org.neo4j.kernel.ha.MasterClient18;
import org.neo4j.kernel.ha.MasterClientFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;

public class MasterClientResolver
implements MasterClientFactory,
MismatchingVersionHandler {
    private volatile MasterClientFactory currentFactory;
    private volatile ProtocolVersionCombo currentVersion;
    private boolean downgradeForbidden = false;
    private final Map<ProtocolVersionCombo, MasterClientFactory> protocolToFactoryMapping = new HashMap<ProtocolVersionCombo, MasterClientFactory>();

    @Override
    public MasterClient instantiate(String hostNameOrIp, int port, StoreId storeId) {
        MasterClient result = this.currentFactory.instantiate(hostNameOrIp, port, storeId);
        result.addMismatchingVersionHandler(this);
        return result;
    }

    public void versionMismatched(int expected, int received) {
        this.getFor(received, 2);
    }

    public MasterClientResolver(StringLogger messageLogger, int readTimeout, int lockReadTimeout, int channels, int chunkSize) {
        this.protocolToFactoryMapping.put(ProtocolVersionCombo.PC_153, new F153(messageLogger, readTimeout, lockReadTimeout, channels, chunkSize));
        this.protocolToFactoryMapping.put(ProtocolVersionCombo.PC_17, new F17(messageLogger, readTimeout, lockReadTimeout, channels, chunkSize));
        this.protocolToFactoryMapping.put(ProtocolVersionCombo.PC_18, new F18(messageLogger, readTimeout, lockReadTimeout, channels, chunkSize));
    }

    public MasterClientFactory getFor(int applicationProtocol, int internalProtocol) {
        ProtocolVersionCombo incomingCombo = new ProtocolVersionCombo(applicationProtocol, internalProtocol);
        MasterClientFactory candidate = this.protocolToFactoryMapping.get(incomingCombo);
        if (!(candidate == null || this.currentVersion != null && this.downgradeForbidden && this.currentVersion.compareTo(incomingCombo) > 0)) {
            this.currentFactory = candidate;
            this.currentVersion = incomingCombo;
        }
        return candidate;
    }

    public MasterClientFactory getDefault() {
        return this.getFor(ProtocolVersionCombo.PC_18.applicationProtocol, ProtocolVersionCombo.PC_18.internalProtocol);
    }

    public void enableDowngradeBarrier() {
        this.downgradeForbidden = true;
    }

    public static final class F18
    extends StaticMasterClientFactory {
        public F18(StringLogger stringLogger, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(stringLogger, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, StoreId storeId) {
            return new MasterClient18(hostNameOrIp, port, this.stringLogger, storeId, ConnectionLostHandler.NO_ACTION, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize);
        }
    }

    public static final class F17
    extends StaticMasterClientFactory {
        public F17(StringLogger stringLogger, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(stringLogger, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, StoreId storeId) {
            return new MasterClient17(hostNameOrIp, port, this.stringLogger, storeId, ConnectionLostHandler.NO_ACTION, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize);
        }
    }

    public static final class F153
    extends StaticMasterClientFactory {
        public F153(StringLogger stringLogger, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            super(stringLogger, readTimeoutSeconds, lockReadTimeout, maxConcurrentChannels, chunkSize);
        }

        @Override
        public MasterClient instantiate(String hostNameOrIp, int port, StoreId storeId) {
            return new MasterClient153(hostNameOrIp, port, this.stringLogger, storeId, ConnectionLostHandler.NO_ACTION, this.readTimeoutSeconds, this.lockReadTimeout, this.maxConcurrentChannels, this.chunkSize);
        }
    }

    protected static abstract class StaticMasterClientFactory
    implements MasterClientFactory {
        protected final StringLogger stringLogger;
        protected final int readTimeoutSeconds;
        protected final int lockReadTimeout;
        protected final int maxConcurrentChannels;
        protected final int chunkSize;

        StaticMasterClientFactory(StringLogger stringLogger, int readTimeoutSeconds, int lockReadTimeout, int maxConcurrentChannels, int chunkSize) {
            this.stringLogger = stringLogger;
            this.readTimeoutSeconds = readTimeoutSeconds;
            this.lockReadTimeout = lockReadTimeout;
            this.maxConcurrentChannels = maxConcurrentChannels;
            this.chunkSize = chunkSize;
        }
    }

    private static final class ProtocolVersionCombo
    implements Comparable<ProtocolVersionCombo> {
        final int applicationProtocol;
        final int internalProtocol;
        static final ProtocolVersionCombo PC_153 = new ProtocolVersionCombo(2, 2);
        static final ProtocolVersionCombo PC_17 = new ProtocolVersionCombo(3, 2);
        static final ProtocolVersionCombo PC_18 = new ProtocolVersionCombo(4, 2);

        ProtocolVersionCombo(int applicationProtocol, int internalProtocol) {
            this.applicationProtocol = applicationProtocol;
            this.internalProtocol = internalProtocol;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ProtocolVersionCombo.class) {
                return false;
            }
            ProtocolVersionCombo other = (ProtocolVersionCombo)obj;
            return other.applicationProtocol == this.applicationProtocol && other.internalProtocol == this.internalProtocol;
        }

        public int hashCode() {
            return 31 * this.applicationProtocol | this.internalProtocol;
        }

        @Override
        public int compareTo(ProtocolVersionCombo o) {
            return this.applicationProtocol < o.applicationProtocol ? -1 : (this.applicationProtocol == o.applicationProtocol ? 0 : 1);
        }
    }
}

