/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import org.neo4j.com.ComException;
import org.neo4j.com.Response;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdRange;

public class SlaveIdGenerator
implements IdGenerator {
    private static final long VALUE_REPRESENTING_NULL = -1L;
    private final Broker broker;
    private final SlaveDatabaseOperations databaseOperations;
    private volatile long highestIdInUse;
    private volatile long defragCount;
    private volatile IdRangeIterator idQueue = EMPTY_ID_RANGE_ITERATOR;
    private volatile int allocationMaster;
    private final IdType idType;
    private final IdGenerator localIdGenerator;
    private static IdRangeIterator EMPTY_ID_RANGE_ITERATOR = new IdRangeIterator(new IdRange(new long[0], 0L, 0)){

        @Override
        long next() {
            return -1L;
        }
    };

    public SlaveIdGenerator(IdType idType, long highestIdInUse, Broker broker, SlaveDatabaseOperations databaseOperations, IdGenerator localIdGenerator) {
        this.idType = idType;
        this.broker = broker;
        this.databaseOperations = databaseOperations;
        this.localIdGenerator = localIdGenerator;
    }

    private void forgetIdAllocationFromMaster() {
        this.idQueue = EMPTY_ID_RANGE_ITERATOR;
    }

    public void close(boolean shutdown) {
        this.localIdGenerator.close(shutdown);
        if (shutdown) {
            this.localIdGenerator.delete();
        }
    }

    public void freeId(long id) {
    }

    public long getHighId() {
        return Math.max(this.localIdGenerator.getHighId(), this.highestIdInUse);
    }

    public long getNumberOfIdsInUse() {
        return Math.max(this.localIdGenerator.getNumberOfIdsInUse(), this.highestIdInUse - this.defragCount);
    }

    public synchronized long nextId() {
        try {
            long nextId = this.nextLocalId();
            Pair<Master, Machine> master = this.broker.getMaster();
            if (nextId == -1L) {
                Response<IdAllocation> response = ((Master)master.first()).allocateIds(this.idType);
                IdAllocation allocation = (IdAllocation)response.response();
                response.close();
                this.allocationMaster = ((Machine)master.other()).getMachineId();
                nextId = this.storeLocally(allocation);
            } else if (((Machine)master.other()).getMachineId() != this.allocationMaster) {
                throw new ComException("Master changed");
            }
            return nextId;
        }
        catch (RuntimeException e) {
            this.databaseOperations.exceptionHappened(e);
            throw e;
        }
    }

    public IdRange nextIdBatch(int size) {
        throw new UnsupportedOperationException("Should never be called");
    }

    private long storeLocally(IdAllocation allocation) {
        this.highestIdInUse = allocation.getHighestIdInUse();
        this.defragCount = allocation.getDefragCount();
        this.idQueue = new IdRangeIterator(allocation.getIdRange());
        this.updateLocalIdGenerator();
        return this.idQueue.next();
    }

    private void updateLocalIdGenerator() {
        long localHighId = this.localIdGenerator.getHighId();
        if (this.highestIdInUse > localHighId) {
            this.localIdGenerator.setHighId(this.highestIdInUse);
        }
    }

    private long nextLocalId() {
        return this.idQueue.next();
    }

    public void setHighId(long id) {
        this.localIdGenerator.setHighId(id);
    }

    public long getDefragCount() {
        return this.defragCount;
    }

    public void delete() {
    }

    private static class IdRangeIterator {
        private int position = 0;
        private final long[] defrag;
        private final long start;
        private final int length;

        IdRangeIterator(IdRange idRange) {
            this.defrag = idRange.getDefragIds();
            this.start = idRange.getRangeStart();
            this.length = idRange.getRangeLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long next() {
            try {
                if (this.position < this.defrag.length) {
                    long l = this.defrag[this.position];
                    return l;
                }
                int offset = this.position - this.defrag.length;
                long l = offset < this.length ? this.start + (long)offset : -1L;
                return l;
            }
            finally {
                ++this.position;
            }
        }
    }

    public static class SlaveIdGeneratorFactory
    implements IdGeneratorFactory {
        private final Broker broker;
        private final SlaveDatabaseOperations databaseOperations;
        private final Map<IdType, SlaveIdGenerator> generators = new EnumMap<IdType, SlaveIdGenerator>(IdType.class);
        private final IdGeneratorFactory localFactory = new DefaultIdGeneratorFactory();

        public SlaveIdGeneratorFactory(Broker broker, SlaveDatabaseOperations databaseOperations) {
            this.broker = broker;
            this.databaseOperations = databaseOperations;
        }

        public IdGenerator open(FileSystemAbstraction fs, String fileName, int grabSize, IdType idType, long highestIdInUse, boolean startup) {
            if (startup) {
                new File(fileName).delete();
            }
            IdGenerator localIdGenerator = this.localFactory.open(fs, fileName, grabSize, idType, highestIdInUse, startup);
            SlaveIdGenerator generator = new SlaveIdGenerator(idType, highestIdInUse, this.broker, this.databaseOperations, localIdGenerator);
            this.generators.put(idType, generator);
            return generator;
        }

        public void create(FileSystemAbstraction fs, String fileName) {
            this.localFactory.create(fs, fileName);
        }

        public IdGenerator get(IdType idType) {
            return this.generators.get(idType);
        }

        public void forgetIdAllocationsFromMaster() {
            for (SlaveIdGenerator idGenerator : this.generators.values()) {
                idGenerator.forgetIdAllocationFromMaster();
            }
        }
    }
}

