/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.LockStatus;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.TxManager;

public class SlaveLockManager
extends LockManager {
    private final Broker broker;
    private final TxManager tm;
    private final SlaveDatabaseOperations databaseOperations;
    private final TxHook txHook;

    public SlaveLockManager(RagManager ragManager, TxManager tm, TxHook txHook, Broker broker, SlaveDatabaseOperations databaseOperations) {
        super(ragManager);
        this.tm = tm;
        this.txHook = txHook;
        this.broker = broker;
        this.databaseOperations = databaseOperations;
    }

    private int getLocalTxId() {
        return this.tm.getEventIdentifier();
    }

    public void getReadLock(Object resource, Transaction tx) throws DeadlockDetectedException, IllegalResourceException {
        LockGrabber grabber = null;
        if (resource instanceof Node) {
            grabber = LockGrabber.NODE_READ;
        } else if (resource instanceof Relationship) {
            grabber = LockGrabber.RELATIONSHIP_READ;
        } else if (resource instanceof GraphProperties) {
            grabber = LockGrabber.GRAPH_READ;
        } else if (resource instanceof NodeManager.IndexLock) {
            grabber = LockGrabber.INDEX_READ;
        }
        try {
            if (grabber == null) {
                super.getReadLock(resource, tx);
                return;
            }
            this.initializeTxIfFirst();
            LockResult result = null;
            do {
                int eventIdentifier = this.getLocalTxId();
                result = this.databaseOperations.receive(grabber.acquireLock((Master)this.broker.getMaster().first(), this.databaseOperations.getSlaveContext(eventIdentifier), resource));
                switch (result.getStatus()) {
                    case OK_LOCKED: {
                        super.getReadLock(resource, tx);
                        return;
                    }
                    case DEAD_LOCKED: {
                        throw new DeadlockDetectedException(result.getDeadlockMessage());
                    }
                }
            } while (result.getStatus() == LockStatus.NOT_LOCKED);
        }
        catch (RuntimeException e) {
            this.databaseOperations.exceptionHappened(e);
            throw e;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeTxIfFirst() throws SystemException {
        Transaction tx = this.tm.getTransaction();
        if (!this.txHook.hasAnyLocks(tx)) {
            this.txHook.initializeTransaction(this.tm.getEventIdentifier());
        }
    }

    public void getWriteLock(Object resource, Transaction tx) throws DeadlockDetectedException, IllegalResourceException {
        LockGrabber grabber = null;
        if (resource instanceof Node) {
            grabber = LockGrabber.NODE_WRITE;
        } else if (resource instanceof Relationship) {
            grabber = LockGrabber.RELATIONSHIP_WRITE;
        } else if (resource instanceof GraphProperties) {
            grabber = LockGrabber.GRAPH_WRITE;
        } else if (resource instanceof NodeManager.IndexLock) {
            grabber = LockGrabber.INDEX_WRITE;
        }
        try {
            if (grabber == null) {
                super.getWriteLock(resource, tx);
                return;
            }
            this.initializeTxIfFirst();
            LockResult result = null;
            do {
                int eventIdentifier = this.getLocalTxId();
                result = this.databaseOperations.receive(grabber.acquireLock((Master)this.broker.getMaster().first(), this.databaseOperations.getSlaveContext(eventIdentifier), resource));
                switch (result.getStatus()) {
                    case OK_LOCKED: {
                        super.getWriteLock(resource, tx);
                        return;
                    }
                    case DEAD_LOCKED: {
                        throw new DeadlockDetectedException(result.getDeadlockMessage());
                    }
                }
            } while (result.getStatus() == LockStatus.NOT_LOCKED);
        }
        catch (RuntimeException e) {
            this.databaseOperations.exceptionHappened(e);
            throw e;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum LockGrabber {
        NODE_READ{

            @Override
            Response<LockResult> acquireLock(Master master, RequestContext context, Object resource) {
                return master.acquireNodeReadLock(context, ((Node)resource).getId());
            }
        }
        ,
        NODE_WRITE{

            @Override
            Response<LockResult> acquireLock(Master master, RequestContext context, Object resource) {
                return master.acquireNodeWriteLock(context, ((Node)resource).getId());
            }
        }
        ,
        RELATIONSHIP_READ{

            @Override
            Response<LockResult> acquireLock(Master master, RequestContext context, Object resource) {
                return master.acquireRelationshipReadLock(context, ((Relationship)resource).getId());
            }
        }
        ,
        RELATIONSHIP_WRITE{

            @Override
            Response<LockResult> acquireLock(Master master, RequestContext context, Object resource) {
                return master.acquireRelationshipWriteLock(context, ((Relationship)resource).getId());
            }
        }
        ,
        GRAPH_READ{

            @Override
            Response<LockResult> acquireLock(Master master, RequestContext context, Object resource) {
                return master.acquireGraphReadLock(context);
            }
        }
        ,
        GRAPH_WRITE{

            @Override
            Response<LockResult> acquireLock(Master master, RequestContext context, Object resource) {
                return master.acquireGraphWriteLock(context);
            }
        }
        ,
        INDEX_WRITE{

            @Override
            Response<LockResult> acquireLock(Master master, RequestContext context, Object resource) {
                NodeManager.IndexLock lock = (NodeManager.IndexLock)resource;
                return master.acquireIndexWriteLock(context, lock.getIndex(), lock.getKey());
            }
        }
        ,
        INDEX_READ{

            @Override
            Response<LockResult> acquireLock(Master master, RequestContext context, Object resource) {
                NodeManager.IndexLock lock = (NodeManager.IndexLock)resource;
                return master.acquireIndexReadLock(context, lock.getIndex(), lock.getKey());
            }
        };


        abstract Response<LockResult> acquireLock(Master var1, RequestContext var2, Object var3);
    }
}

