/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.ha.Slave;
import org.neo4j.kernel.ha.SlavePriority;

public abstract class SlavePriorities {
    private static final Comparator<Slave> SERVER_ID_COMPARATOR = new Comparator<Slave>(){

        @Override
        public int compare(Slave first, Slave second) {
            return first.getServerId() - second.getServerId();
        }
    };
    private static final Comparator<Slave> REVERSE_SERVER_ID_COMPARATOR = Collections.reverseOrder(SERVER_ID_COMPARATOR);

    private SlavePriorities() {
    }

    public static SlavePriority givenOrder() {
        return new SlavePriority(){

            @Override
            public Iterator<Slave> prioritize(Slave[] slaves) {
                return Arrays.asList(slaves).iterator();
            }
        };
    }

    public static SlavePriority roundRobin() {
        return new SlavePriority(){
            final AtomicInteger index = new AtomicInteger();

            @Override
            public Iterator<Slave> prioritize(final Slave[] slaves) {
                final List slaveList = SlavePriorities.sortSlaves(slaves, true);
                return new PrefetchingIterator<Slave>(){
                    private int start;
                    private int count;
                    {
                        this.start = index.getAndIncrement() % slaves.length;
                    }

                    protected Slave fetchNextOrNull() {
                        int id;
                        return (id = this.count++) <= slaves.length ? (Slave)slaveList.get((this.start + id) % slaves.length) : null;
                    }
                };
            }
        };
    }

    public static SlavePriority fixed() {
        return new SlavePriority(){

            @Override
            public Iterator<Slave> prioritize(Slave[] slaves) {
                return SlavePriorities.sortSlaves(slaves, false).iterator();
            }
        };
    }

    private static List<Slave> sortSlaves(Slave[] slaves, boolean asc) {
        ArrayList<Slave> slaveList = new ArrayList<Slave>();
        slaveList.addAll(Arrays.asList(slaves));
        Collections.sort(slaveList, asc ? SERVER_ID_COMPARATOR : REVERSE_SERVER_ID_COMPARATOR);
        return slaveList;
    }
}

