/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import javax.transaction.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.SlaveDatabaseOperations;
import org.neo4j.kernel.impl.transaction.TxHook;

public class SlaveTxHook
implements TxHook {
    private final Broker broker;
    private final SlaveDatabaseOperations databaseOperations;
    private GraphDatabaseAPI spi;

    public SlaveTxHook(Broker broker, SlaveDatabaseOperations databaseOperations, GraphDatabaseAPI spi) {
        this.broker = broker;
        this.databaseOperations = databaseOperations;
        this.spi = spi;
    }

    public void initializeTransaction(int eventIdentifier) {
        try {
            this.databaseOperations.receive(((Master)this.broker.getMaster().first()).initializeTx(this.databaseOperations.getSlaveContext(eventIdentifier)));
        }
        catch (RuntimeException e) {
            this.databaseOperations.exceptionHappened(e);
            throw e;
        }
    }

    public boolean hasAnyLocks(Transaction tx) {
        return this.spi.getLockReleaser().hasLocks(tx);
    }

    public void finishTransaction(int eventIdentifier, boolean success) {
        try {
            this.databaseOperations.receive(((Master)this.broker.getMaster().first()).finishTransaction(this.databaseOperations.getSlaveContext(eventIdentifier), success));
        }
        catch (RuntimeException e) {
            this.databaseOperations.exceptionHappened(e);
            throw e;
        }
    }

    public boolean freeIdsDuringRollback() {
        return false;
    }
}

