/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.graphdb.factory.Default;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.GCResistantCache;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;

public class GCResistantCacheProvider
extends CacheProvider {
    public static final String NAME = "gcr";

    public GCResistantCacheProvider() {
        super(NAME, "GC resistant cache");
    }

    public Cache<NodeImpl> newNodeCache(StringLogger logger, Config config) {
        long node = (Long)config.get(Configuration.node_cache_size);
        long rel = (Long)config.get(Configuration.relationship_cache_size);
        this.checkMemToUse(logger, node, rel, Runtime.getRuntime().maxMemory());
        return new GCResistantCache<NodeImpl>(node, ((Float)config.get(Configuration.node_cache_array_fraction)).floatValue(), (Long)config.get(Configuration.log_interval), "NodeCache", logger);
    }

    public Cache<RelationshipImpl> newRelationshipCache(StringLogger logger, Config config) {
        long node = (Long)config.get(Configuration.node_cache_size);
        long rel = (Long)config.get(Configuration.relationship_cache_size);
        this.checkMemToUse(logger, node, rel, Runtime.getRuntime().maxMemory());
        return new GCResistantCache<RelationshipImpl>(rel, ((Float)config.get(Configuration.relationship_cache_array_fraction)).floatValue(), (Long)config.get(Configuration.log_interval), "RelationshipCache", logger);
    }

    private void checkMemToUse(StringLogger logger, long node, long rel, long available) {
        long advicedMax = available / 2L;
        long total = 0L;
        node = Math.max(1L, node);
        total += node;
        if ((total += (rel = Math.max(1L, rel))) > available) {
            throw new IllegalArgumentException(String.format("Configured cache memory limits (node=%s, relationship=%s, total=%s) exceeds available heap space (%s)", node, rel, total, available));
        }
        if (total > advicedMax) {
            logger.logMessage(String.format("Configured cache memory limits(node=%s, relationship=%s, total=%s) exceeds recommended limit (%s)", node, rel, total, advicedMax));
        }
    }

    public Class getSettingsClass() {
        return Configuration.class;
    }

    public static class Configuration {
        public static GraphDatabaseSetting<Long> node_cache_size = new GCRMemoryUsageSetting("node_cache_size");
        public static GraphDatabaseSetting<Long> relationship_cache_size = new GCRMemoryUsageSetting("relationship_cache_size");
        @Default(value="1.0")
        public static GraphDatabaseSetting<Float> node_cache_array_fraction = new GraphDatabaseSetting.FloatSetting("node_cache_array_fraction", "Must be a valid floating point number.", Float.valueOf(1.0f), Float.valueOf(10.0f));
        @Default(value="1.0")
        public static GraphDatabaseSetting<Float> relationship_cache_array_fraction = new GraphDatabaseSetting.FloatSetting("relationship_cache_array_fraction", "Must be a valid floating point number.", Float.valueOf(1.0f), Float.valueOf(10.0f));
        @Default(value="60s")
        public static GraphDatabaseSetting<Long> log_interval = new GraphDatabaseSetting.TimeSpanSetting("gcr_cache_min_log_interval");

        private static final class GCRMemoryUsageSetting
        extends GraphDatabaseSetting.NumberOfBytesSetting
        implements GraphDatabaseSetting.DefaultValue {
            public GCRMemoryUsageSetting(String name) {
                super(name);
            }

            public String getDefaultValue() {
                long available = Runtime.getRuntime().maxMemory();
                long defaultMem = available / 4L;
                return "" + defaultMem;
            }
        }
    }
}

