/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.LazySingleReference;

public class DelegateInvocationHandler<T>
implements InvocationHandler {
    private volatile T delegate;
    private final LazySingleReference<T> concrete;

    public DelegateInvocationHandler(final Class<T> interfaceClass) {
        this.concrete = new LazySingleReference<T>(){

            protected T create() {
                return Proxy.newProxyInstance(DelegateInvocationHandler.class.getClassLoader(), new Class[]{interfaceClass}, new Concrete());
            }
        };
    }

    public T setDelegate(T delegate) {
        T oldDelegate = this.delegate;
        this.delegate = delegate;
        this.harden();
        this.concrete.invalidate();
        return oldDelegate;
    }

    void harden() {
        ((Concrete)Proxy.getInvocationHandler(this.concrete.get())).set(this.delegate);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.delegate == null) {
            throw new StateChangedTransactionFailureException("This transaction made assumptions about the instance it is executing on that no longer hold true. This normally happens when a transaction expects the instance it is executing on to be in some specific cluster role(such as 'master' or 'slave') and the instance changing state while the transaction is executing. Simply retry your transaction and you should see a successful outcome.");
        }
        return DelegateInvocationHandler.proxyInvoke(this.delegate, method, args);
    }

    private static Object proxyInvoke(Object delegate, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public T cement() {
        return (T)this.concrete.get();
    }

    public String toString() {
        return "Delegate[" + this.delegate + "]";
    }

    static class StateChangedTransactionFailureException
    extends TransactionFailureException
    implements Status.HasStatus {
        public StateChangedTransactionFailureException(String msg) {
            super(msg);
        }

        public Status status() {
            return Status.Transaction.InstanceStateChanged;
        }
    }

    private static class Concrete<T>
    implements InvocationHandler {
        private volatile T delegate;

        private Concrete() {
        }

        void set(T delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.delegate == null) {
                throw new TransientDatabaseFailureException("Instance state is not valid. There is no master currently available. Possible causes include unavailability of a majority of the cluster members or network failure that caused this instance to be partitioned away from the cluster");
            }
            return DelegateInvocationHandler.proxyInvoke(this.delegate, method, args);
        }

        public String toString() {
            return "Concrete[" + this.delegate + "]";
        }
    }
}

