/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.util.Quorums;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.cluster.HighAvailability;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class HighAvailabilityMemberStateMachine
extends LifecycleAdapter
implements HighAvailability {
    public static final AvailabilityGuard.AvailabilityRequirement AVAILABILITY_REQUIREMENT = AvailabilityGuard.availabilityRequirement((String)"High Availability member state not ready");
    private final HighAvailabilityMemberContext context;
    private final AvailabilityGuard availabilityGuard;
    private final ClusterMemberEvents events;
    private Log log;
    private final Listeners<HighAvailabilityMemberListener> memberListeners = new Listeners();
    private volatile HighAvailabilityMemberState state;
    private StateMachineClusterEventListener eventsListener;
    private final ObservedClusterMembers members;
    private final Election election;

    public HighAvailabilityMemberStateMachine(HighAvailabilityMemberContext context, AvailabilityGuard availabilityGuard, ObservedClusterMembers members, ClusterMemberEvents events, Election election, LogProvider logProvider) {
        this.context = context;
        this.availabilityGuard = availabilityGuard;
        this.members = members;
        this.events = events;
        this.election = election;
        this.log = logProvider.getLog(this.getClass());
        this.state = HighAvailabilityMemberState.PENDING;
    }

    public void init() throws Throwable {
        this.eventsListener = new StateMachineClusterEventListener();
        this.events.addClusterMemberListener((ClusterMemberListener)this.eventsListener);
        this.availabilityGuard.require(AVAILABILITY_REQUIREMENT);
    }

    public void stop() throws Throwable {
        this.events.removeClusterMemberListener((ClusterMemberListener)this.eventsListener);
        HighAvailabilityMemberState oldState = this.state;
        this.state = HighAvailabilityMemberState.PENDING;
        HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, this.state, null, null);
        this.memberListeners.notify(listener -> listener.instanceStops(event));
        if (oldState.isAccessAllowed()) {
            this.availabilityGuard.require(AVAILABILITY_REQUIREMENT);
        }
        this.context.setAvailableHaMasterId(null);
    }

    @Override
    public void addHighAvailabilityMemberListener(HighAvailabilityMemberListener toAdd) {
        this.memberListeners.add((Object)toAdd);
    }

    @Override
    public void removeHighAvailabilityMemberListener(HighAvailabilityMemberListener toRemove) {
        this.memberListeners.remove((Object)toRemove);
    }

    public HighAvailabilityMemberState getCurrentState() {
        return this.state;
    }

    public boolean isMaster() {
        return this.getCurrentState() == HighAvailabilityMemberState.MASTER;
    }

    private class StateMachineClusterEventListener
    implements ClusterMemberListener {
        private StateMachineClusterEventListener() {
        }

        public synchronized void coordinatorIsElected(InstanceId coordinatorId) {
            try {
                HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                InstanceId previousElected = HighAvailabilityMemberStateMachine.this.context.getElectedMasterId();
                HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(null);
                if (!this.acceptNewState(HighAvailabilityMemberStateMachine.this.state.masterIsElected(HighAvailabilityMemberStateMachine.this.context, coordinatorId))) {
                    return;
                }
                HighAvailabilityMemberStateMachine.this.context.setElectedMasterId(coordinatorId);
                HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, HighAvailabilityMemberStateMachine.this.state, coordinatorId, null);
                HighAvailabilityMemberStateMachine.this.memberListeners.notify(listener -> listener.masterIsElected(event));
                if (oldState.isAccessAllowed() && oldState != HighAvailabilityMemberStateMachine.this.state) {
                    HighAvailabilityMemberStateMachine.this.availabilityGuard.require(AVAILABILITY_REQUIREMENT);
                }
                HighAvailabilityMemberStateMachine.this.log.debug("Got masterIsElected(" + coordinatorId + "), moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState) + ". Previous elected master is " + previousElected);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public synchronized void memberIsAvailable(String role, InstanceId instanceId, URI roleUri, StoreId storeId) {
            try {
                if (role.equals("master")) {
                    HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                    HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(roleUri);
                    if (!this.acceptNewState(HighAvailabilityMemberStateMachine.this.state.masterIsAvailable(HighAvailabilityMemberStateMachine.this.context, instanceId, roleUri))) {
                        return;
                    }
                    HighAvailabilityMemberStateMachine.this.log.debug("Got masterIsAvailable(" + instanceId + "), moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState));
                    HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, HighAvailabilityMemberStateMachine.this.state, instanceId, roleUri);
                    HighAvailabilityMemberStateMachine.this.memberListeners.notify(listener -> listener.masterIsAvailable(event));
                    if (oldState == HighAvailabilityMemberState.TO_MASTER && HighAvailabilityMemberStateMachine.this.state == HighAvailabilityMemberState.MASTER) {
                        HighAvailabilityMemberStateMachine.this.availabilityGuard.fulfill(AVAILABILITY_REQUIREMENT);
                    }
                } else if (role.equals("slave")) {
                    HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                    if (!this.acceptNewState(HighAvailabilityMemberStateMachine.this.state.slaveIsAvailable(HighAvailabilityMemberStateMachine.this.context, instanceId, roleUri))) {
                        return;
                    }
                    HighAvailabilityMemberStateMachine.this.log.debug("Got slaveIsAvailable(" + instanceId + "), moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState));
                    HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(oldState, HighAvailabilityMemberStateMachine.this.state, instanceId, roleUri);
                    HighAvailabilityMemberStateMachine.this.memberListeners.notify(listener -> listener.slaveIsAvailable(event));
                    if (oldState == HighAvailabilityMemberState.TO_SLAVE && HighAvailabilityMemberStateMachine.this.state == HighAvailabilityMemberState.SLAVE) {
                        HighAvailabilityMemberStateMachine.this.availabilityGuard.fulfill(AVAILABILITY_REQUIREMENT);
                    }
                }
            }
            catch (Throwable throwable) {
                HighAvailabilityMemberStateMachine.this.log.warn("Exception while receiving member availability notification", throwable);
            }
        }

        public void memberIsUnavailable(String role, InstanceId unavailableId) {
            if (HighAvailabilityMemberStateMachine.this.context.getMyId().equals((Object)unavailableId) && "slave".equals(role) && HighAvailabilityMemberStateMachine.this.state == HighAvailabilityMemberState.SLAVE) {
                HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                this.changeStateToPending();
                HighAvailabilityMemberStateMachine.this.log.debug("Got memberIsUnavailable(" + unavailableId + "), moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState));
            } else {
                HighAvailabilityMemberStateMachine.this.log.debug("Got memberIsUnavailable(" + unavailableId + ")");
            }
        }

        public void memberIsFailed(InstanceId instanceId) {
            if (!Quorums.isQuorum((long)this.getAliveCount(), (long)this.getTotalCount())) {
                HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                this.changeStateToDetached();
                HighAvailabilityMemberStateMachine.this.log.debug("Got memberIsFailed(" + instanceId + ") and cluster lost quorum to continue, moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState) + ", while maintaining read only capability.");
            } else if (instanceId.equals((Object)HighAvailabilityMemberStateMachine.this.context.getElectedMasterId()) && HighAvailabilityMemberStateMachine.this.state == HighAvailabilityMemberState.SLAVE) {
                HighAvailabilityMemberState oldState = HighAvailabilityMemberStateMachine.this.state;
                this.changeStateToDetached();
                HighAvailabilityMemberStateMachine.this.log.debug("Got memberIsFailed(" + instanceId + ") which was the master and i am a slave, moved to " + (Object)((Object)HighAvailabilityMemberStateMachine.this.state) + " from " + (Object)((Object)oldState) + ", while maintaining read only capability.");
            } else {
                HighAvailabilityMemberStateMachine.this.log.debug("Got memberIsFailed(" + instanceId + ")");
            }
        }

        public void memberIsAlive(InstanceId instanceId) {
            if (Quorums.isQuorum((long)this.getAliveCount(), (long)this.getTotalCount()) && HighAvailabilityMemberStateMachine.this.state.equals((Object)HighAvailabilityMemberState.PENDING)) {
                HighAvailabilityMemberStateMachine.this.election.performRoleElections();
            }
        }

        private void changeStateToPending() {
            if (HighAvailabilityMemberStateMachine.this.state.isAccessAllowed()) {
                HighAvailabilityMemberStateMachine.this.availabilityGuard.require(AVAILABILITY_REQUIREMENT);
            }
            HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberStateMachine.this.state, HighAvailabilityMemberState.PENDING, null, null);
            HighAvailabilityMemberStateMachine.this.state = HighAvailabilityMemberState.PENDING;
            HighAvailabilityMemberStateMachine.this.memberListeners.notify(listener -> listener.instanceStops(event));
            HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(null);
            HighAvailabilityMemberStateMachine.this.context.setElectedMasterId(null);
        }

        private void changeStateToDetached() {
            HighAvailabilityMemberStateMachine.this.state = HighAvailabilityMemberState.PENDING;
            HighAvailabilityMemberChangeEvent event = new HighAvailabilityMemberChangeEvent(HighAvailabilityMemberStateMachine.this.state, HighAvailabilityMemberState.PENDING, null, null);
            HighAvailabilityMemberStateMachine.this.memberListeners.notify(listener -> listener.instanceDetached(event));
            HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(null);
            HighAvailabilityMemberStateMachine.this.context.setElectedMasterId(null);
        }

        private long getAliveCount() {
            return Iterables.count(HighAvailabilityMemberStateMachine.this.members.getAliveMembers());
        }

        private long getTotalCount() {
            return Iterables.count(HighAvailabilityMemberStateMachine.this.members.getMembers());
        }

        private boolean acceptNewState(HighAvailabilityMemberState newState) {
            if (newState == HighAvailabilityMemberState.ILLEGAL) {
                HighAvailabilityMemberStateMachine.this.log.warn(String.format("Message received resulted in illegal state transition. I was in state %s, context was %s. The error message is %s. This instance will now transition to PENDING state and ask for new elections. While this may fix the error, it may indicate that there is some connectivity issue or some instability of cluster members.", new Object[]{HighAvailabilityMemberStateMachine.this.state, HighAvailabilityMemberStateMachine.this.context, newState.errorMessage()}));
                HighAvailabilityMemberStateMachine.this.context.setElectedMasterId(null);
                HighAvailabilityMemberStateMachine.this.context.setAvailableHaMasterId(null);
                this.changeStateToPending();
                HighAvailabilityMemberStateMachine.this.election.performRoleElections();
                return false;
            }
            HighAvailabilityMemberStateMachine.this.state = newState;
            return true;
        }
    }
}

