/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.Protocol214;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.kernel.ha.HaRequestType210;
import org.neo4j.kernel.ha.HaRequestTypes;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.lock.ResourceType;

public class MasterClient214
extends Client<Master>
implements MasterClient {
    public static final ProtocolVersion PROTOCOL_VERSION = new ProtocolVersion(8, 2);
    private final long lockReadTimeoutMillis;
    private final HaRequestTypes requestTypes;

    public MasterClient214(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, LogProvider logProvider, StoreId storeId, long readTimeoutMillis, long lockReadTimeoutMillis, int maxConcurrentChannels, int chunkSize, ResponseUnpacker responseUnpacker, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor, LogEntryReader<ReadableClosablePositionAwareChannel> entryReader) {
        super(destinationHostNameOrIp, destinationPort, originHostNameOrIp, logProvider, storeId, 0x1000000, readTimeoutMillis, maxConcurrentChannels, chunkSize, responseUnpacker, byteCounterMonitor, requestMonitor, entryReader);
        this.lockReadTimeoutMillis = lockReadTimeoutMillis;
        this.requestTypes = new HaRequestType210(entryReader);
    }

    protected Protocol createProtocol(int chunkSize, byte applicationProtocolVersion) {
        return new Protocol214(chunkSize, applicationProtocolVersion, this.getInternalProtocolVersion());
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return PROTOCOL_VERSION;
    }

    protected long getReadTimeout(RequestType<Master> type, long readTimeout) {
        if (HaRequestTypes.Type.ACQUIRE_EXCLUSIVE_LOCK.is(type) || HaRequestTypes.Type.ACQUIRE_SHARED_LOCK.is(type)) {
            return this.lockReadTimeoutMillis;
        }
        if (HaRequestTypes.Type.COPY_STORE.is(type)) {
            return readTimeout * 2L;
        }
        return readTimeout;
    }

    protected boolean shouldCheckStoreId(RequestType<Master> type) {
        return !HaRequestTypes.Type.COPY_STORE.is(type);
    }

    @Override
    public Response<IdAllocation> allocateIds(RequestContext context, IdType idType) {
        Serializer serializer = buffer -> buffer.writeByte(idType.ordinal());
        Deserializer deserializer = (buffer, temporaryBuffer) -> MasterClient214.readIdAllocation(buffer);
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.ALLOCATE_IDS), context, serializer, deserializer);
    }

    @Override
    public Response<Integer> createRelationshipType(RequestContext context, String name) {
        Serializer serializer = buffer -> Protocol.writeString((ChannelBuffer)buffer, (String)name);
        Deserializer deserializer = (buffer, temporaryBuffer) -> buffer.readInt();
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.CREATE_RELATIONSHIP_TYPE), context, serializer, deserializer);
    }

    @Override
    public Response<Integer> createPropertyKey(RequestContext context, String name) {
        Serializer serializer = buffer -> Protocol.writeString((ChannelBuffer)buffer, (String)name);
        Deserializer deserializer = (buffer, temporaryBuffer) -> buffer.readInt();
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.CREATE_PROPERTY_KEY), context, serializer, deserializer);
    }

    @Override
    public Response<Integer> createLabel(RequestContext context, String name) {
        Serializer serializer = buffer -> Protocol.writeString((ChannelBuffer)buffer, (String)name);
        Deserializer deserializer = (buffer, temporaryBuffer) -> buffer.readInt();
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.CREATE_LABEL), context, serializer, deserializer);
    }

    @Override
    public Response<Void> newLockSession(RequestContext context) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.NEW_LOCK_SESSION), context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireSharedLock(RequestContext context, ResourceType type, long ... resourceIds) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.ACQUIRE_SHARED_LOCK), context, new AcquireLockSerializer(type, resourceIds), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireExclusiveLock(RequestContext context, ResourceType type, long ... resourceIds) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.ACQUIRE_EXCLUSIVE_LOCK), context, new AcquireLockSerializer(type, resourceIds), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<Long> commit(RequestContext context, TransactionRepresentation tx) {
        Protocol.TransactionSerializer serializer = new Protocol.TransactionSerializer(tx);
        Deserializer deserializer = (buffer, temporaryBuffer) -> buffer.readLong();
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.COMMIT), context, (Serializer)serializer, deserializer);
    }

    @Override
    public Response<Void> endLockSession(RequestContext context, boolean success) {
        Serializer serializer = buffer -> buffer.writeByte(success ? 1 : 0);
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.END_LOCK_SESSION), context, serializer, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context) {
        return this.pullUpdates(context, ResponseUnpacker.TxHandler.NO_OP_TX_HANDLER);
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context, ResponseUnpacker.TxHandler txHandler) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.PULL_UPDATES), context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER, null, txHandler);
    }

    @Override
    public Response<HandshakeResult> handshake(long txId, StoreId storeId) {
        Serializer serializer = buffer -> buffer.writeLong(txId);
        Deserializer deserializer = (buffer, temporaryBuffer) -> new HandshakeResult(buffer.readLong(), buffer.readLong());
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.HANDSHAKE), RequestContext.EMPTY, serializer, deserializer, storeId, ResponseUnpacker.TxHandler.NO_OP_TX_HANDLER);
    }

    @Override
    public Response<Void> copyStore(RequestContext context, StoreWriter writer) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.COPY_STORE), context, Protocol.EMPTY_SERIALIZER, this.createFileStreamDeserializer(writer));
    }

    protected Deserializer<Void> createFileStreamDeserializer(StoreWriter writer) {
        return new Protocol.FileStreamsDeserializer210(writer);
    }

    private RequestContext stripFromTransactions(RequestContext context) {
        return new RequestContext(context.getEpoch(), context.machineId(), context.getEventIdentifier(), 0L, context.getChecksum());
    }

    private static IdAllocation readIdAllocation(ChannelBuffer buffer) {
        int numberOfDefragIds = buffer.readInt();
        long[] defragIds = new long[numberOfDefragIds];
        for (int i = 0; i < numberOfDefragIds; ++i) {
            defragIds[i] = buffer.readLong();
        }
        long rangeStart = buffer.readLong();
        int rangeLength = buffer.readInt();
        long highId = buffer.readLong();
        long defragCount = buffer.readLong();
        return new IdAllocation(new IdRange(defragIds, rangeStart, rangeLength), highId, defragCount);
    }

    private static class AcquireLockSerializer
    implements Serializer {
        private final ResourceType type;
        private final long[] resourceIds;

        AcquireLockSerializer(ResourceType type, long ... resourceIds) {
            this.type = type;
            this.resourceIds = resourceIds;
        }

        public void write(ChannelBuffer buffer) throws IOException {
            buffer.writeInt(this.type.typeId());
            buffer.writeInt(this.resourceIds.length);
            for (long entity : this.resourceIds) {
                buffer.writeLong(entity);
            }
        }
    }
}

