/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;

public enum HighAvailabilityMemberState {
    PENDING{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            assert (context.getAvailableHaMaster() == null);
            if (masterId.equals((Object)context.getMyId()) && !context.isSlaveOnly()) {
                return TO_MASTER;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                HighAvailabilityMemberState result = ILLEGAL;
                result.setErrorMessage("Received a MasterIsAvailable event for my InstanceId while in PENDING state");
                return result;
            }
            return TO_SLAVE;
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            if (slaveId.equals((Object)context.getMyId())) {
                HighAvailabilityMemberState result = ILLEGAL;
                result.setErrorMessage("Cannot go from pending to slave");
                return result;
            }
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return true;
        }

        @Override
        public boolean isAccessAllowed() {
            return false;
        }
    }
    ,
    TO_SLAVE{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            if (masterId.equals((Object)context.getElectedMasterId())) {
                return this;
            }
            if (masterId.equals((Object)context.getMyId())) {
                return TO_MASTER;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                HighAvailabilityMemberState result = ILLEGAL;
                result.setErrorMessage("i (" + context.getMyId() + ") am trying to become a slave but someone said i am available as master");
                return result;
            }
            if (masterId.equals((Object)context.getElectedMasterId())) {
                return this;
            }
            HighAvailabilityMemberState result = ILLEGAL;
            result.setErrorMessage("my (" + context.getMyId() + ") current master is " + context.getAvailableHaMaster() + " (elected as " + context.getElectedMasterId() + " but i got a masterIsAvailable event for " + masterHaURI);
            return result;
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            if (slaveId.equals((Object)context.getMyId())) {
                return SLAVE;
            }
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return false;
        }

        @Override
        public boolean isAccessAllowed() {
            return false;
        }
    }
    ,
    TO_MASTER{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            assert (context.getAvailableHaMaster() == null);
            if (masterId.equals((Object)context.getMyId())) {
                return this;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                return MASTER;
            }
            HighAvailabilityMemberState result = ILLEGAL;
            result.setErrorMessage("Received a MasterIsAvailable event for instance " + masterId + " while in TO_MASTER state");
            return result;
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            if (slaveId.equals((Object)context.getMyId())) {
                HighAvailabilityMemberState result = ILLEGAL;
                result.setErrorMessage("Cannot be transitioning to master and slave at the same time");
                return result;
            }
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return true;
        }

        @Override
        public boolean isAccessAllowed() {
            return false;
        }
    }
    ,
    MASTER{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            if (masterId.equals((Object)context.getMyId())) {
                return this;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                return this;
            }
            HighAvailabilityMemberState result = ILLEGAL;
            result.setErrorMessage("I, " + context.getMyId() + " got a masterIsAvailable for " + masterHaURI + " (id is " + masterId + " ) while in MASTER state. Probably missed a MasterIsElected event.");
            return result;
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            if (slaveId.equals((Object)context.getMyId())) {
                HighAvailabilityMemberState result = ILLEGAL;
                result.setErrorMessage("Cannot be master and transition to slave at the same time");
                return result;
            }
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return true;
        }

        @Override
        public boolean isAccessAllowed() {
            return true;
        }
    }
    ,
    SLAVE{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            if (masterId.equals((Object)context.getMyId())) {
                return TO_MASTER;
            }
            if (masterId.equals((Object)context.getElectedMasterId())) {
                return this;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                HighAvailabilityMemberState returnValue = ILLEGAL;
                returnValue.setErrorMessage("Cannot transition to MASTER directly from SLAVE state");
                return returnValue;
            }
            if (masterId.equals((Object)context.getElectedMasterId())) {
                return this;
            }
            HighAvailabilityMemberState returnValue = ILLEGAL;
            returnValue.setErrorMessage("Received a MasterIsAvailable event for " + masterId + " which is different from the current master (" + context.getElectedMasterId() + ") while in the SLAVE state (probably missed a MasterIsElected event)");
            return returnValue;
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return true;
        }

        @Override
        public boolean isAccessAllowed() {
            return true;
        }
    }
    ,
    ILLEGAL{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            throw new IllegalStateException("The ILLEGAL state is not meant to be used as a state, merely as an indicator that something went wrong while handling a message and the state should be set to PENDING");
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            throw new IllegalStateException("The ILLEGAL state is not meant to be used as a state, merely as an indicator that something went wrong while handling a message and the state should be set to PENDING");
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            throw new IllegalStateException("The ILLEGAL state is not meant to be used as a state, merely as an indicator that something went wrong while handling a message and the state should be set to PENDING");
        }

        @Override
        public boolean isEligibleForElection() {
            throw new IllegalStateException("The ILLEGAL state is not meant to be used as a state, merely as an indicator that something went wrong while handling a message and the state should be set to PENDING");
        }

        @Override
        public boolean isAccessAllowed() {
            throw new IllegalStateException("The ILLEGAL state is not meant to be used as a state, merely as an indicator that something went wrong while handling a message and the state should be set to PENDING");
        }
    };

    private String errorMessage = "";

    public abstract HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext var1, InstanceId var2);

    public abstract HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext var1, InstanceId var2, URI var3);

    public abstract HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext var1, InstanceId var2, URI var3);

    public abstract boolean isEligibleForElection();

    public abstract boolean isAccessAllowed();

    public String errorMessage() {
        return this.errorMessage;
    }

    private void setErrorMessage(String message) {
        this.errorMessage = message;
    }
}

