/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.factory.Edition;

public class HighlyAvailableGraphDatabaseFactory
extends GraphDatabaseFactory {
    public HighlyAvailableGraphDatabaseFactory() {
        super(HighlyAvailableGraphDatabaseFactory.highlyAvailableFactoryState());
    }

    private static GraphDatabaseFactoryState highlyAvailableFactoryState() {
        GraphDatabaseFactoryState state = new GraphDatabaseFactoryState();
        state.addSettingsClasses(Arrays.asList(ClusterSettings.class, HaSettings.class));
        return state;
    }

    protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(final File storeDir, final GraphDatabaseFactoryState state) {
        return new GraphDatabaseBuilder.DatabaseCreator(){

            public GraphDatabaseService newDatabase(Map<String, String> config) {
                return this.newDatabase(Config.embeddedDefaults(config));
            }

            public GraphDatabaseService newDatabase(Config config) {
                return new HighlyAvailableGraphDatabase(storeDir, config.with(MapUtil.stringMap((String[])new String[]{"unsupported.dbms.ephemeral", "false"})), state.databaseDependencies());
            }
        };
    }

    public String getEdition() {
        return Edition.enterprise.toString();
    }
}

