/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.function.ThrowingLongUnaryOperator;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class BranchDetectingTxVerifier
implements TxChecksumVerifier {
    private final Log log;
    private final ThrowingLongUnaryOperator<IOException> txChecksumLookup;

    public BranchDetectingTxVerifier(LogProvider logProvider, ThrowingLongUnaryOperator<IOException> txChecksumLookup) {
        this.log = logProvider.getLog(this.getClass());
        this.txChecksumLookup = txChecksumLookup;
    }

    public void assertMatch(long txId, long checksum) {
        long readChecksum;
        if (txId == 0L) {
            return;
        }
        try {
            readChecksum = this.txChecksumLookup.applyAsLong(txId);
        }
        catch (NoSuchTransactionException e) {
            return;
        }
        catch (IOException e) {
            this.log.error("Couldn't verify checksum for " + this.stringify(txId, checksum), (Throwable)e);
            throw new BranchedDataException("Unable to perform a mandatory sanity check due to an IO error.", e);
        }
        if (checksum != readChecksum) {
            throw new BranchedDataException("The cluster contains two logically different versions of the database. This will be automatically resolved. Details: " + this.stringify(txId, checksum) + " does not match " + readChecksum);
        }
    }

    private String stringify(long txId, long checksum) {
        return "txId:" + txId + ", checksum:" + checksum;
    }
}

