/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.management;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.management.NotCompliantMBeanException;
import org.neo4j.com.storecopy.StoreUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.BranchedStoreInfo;

public final class BranchedStoreBean
extends ManagementBeanProvider {
    public BranchedStoreBean() {
        super(BranchedStore.class);
    }

    protected Neo4jMBean createMXBean(ManagementData management) {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management, true);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        if (!BranchedStoreBean.isHA(management)) {
            return null;
        }
        return new BranchedStoreImpl(management);
    }

    private static boolean isHA(ManagementData management) {
        return management.getKernelData().graphDatabase() instanceof HighlyAvailableGraphDatabase;
    }

    private static class BranchedStoreImpl
    extends Neo4jMBean
    implements BranchedStore {
        private final FileSystemAbstraction fileSystem;
        private final File storePath;
        private final PageCache pageCache;

        BranchedStoreImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.fileSystem = this.getFilesystem(management);
            this.storePath = this.getStorePath(management);
            this.pageCache = this.getPageCache(management);
        }

        BranchedStoreImpl(ManagementData management, boolean isMXBean) {
            super(management, isMXBean, new String[0]);
            this.fileSystem = this.getFilesystem(management);
            this.storePath = this.getStorePath(management);
            this.pageCache = this.getPageCache(management);
        }

        public BranchedStoreInfo[] getBranchedStores() {
            if (this.storePath == null) {
                return new BranchedStoreInfo[0];
            }
            LinkedList<BranchedStoreInfo> toReturn = new LinkedList<BranchedStoreInfo>();
            for (File branchDirectory : this.fileSystem.listFiles(StoreUtil.getBranchedDataRootDirectory((File)this.storePath))) {
                if (!branchDirectory.isDirectory()) continue;
                toReturn.add(this.parseBranchedStore(branchDirectory));
            }
            return toReturn.toArray(new BranchedStoreInfo[toReturn.size()]);
        }

        private BranchedStoreInfo parseBranchedStore(File branchDirectory) {
            try {
                File neoStoreFile = new File(branchDirectory, "neostore");
                long txId = MetaDataStore.getRecord((PageCache)this.pageCache, (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID);
                long timestamp = Long.parseLong(branchDirectory.getName());
                long branchedStoreSize = FileUtils.size((FileSystemAbstraction)this.fileSystem, (File)branchDirectory);
                return new BranchedStoreInfo(branchDirectory.getName(), txId, timestamp, branchedStoreSize);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read branched neostore", e);
            }
        }

        private PageCache getPageCache(ManagementData management) {
            return management.getKernelData().getPageCache();
        }

        private FileSystemAbstraction getFilesystem(ManagementData management) {
            return management.getKernelData().getFilesystemAbstraction();
        }

        private File getStorePath(ManagementData management) {
            return management.getKernelData().getStoreDir();
        }
    }
}

