/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.neo4j.internal.id.indexed.IdRange;

public class IllegalIdTransitionException
extends IllegalStateException {
    private final long[] ids;

    public IllegalIdTransitionException(long idRangeIdx, long firstId, long lastId, long into, long from) {
        super(String.format("Illegal addition ID state for range: %d (IDs %d-%d) transition%ninto: %s%nfrom: %s", idRangeIdx, firstId, lastId, IdRange.toPaddedBinaryString(into), IdRange.toPaddedBinaryString(from)));
        this.ids = this.findCollidingIds(firstId, into, from);
    }

    public long[] ids() {
        return this.ids;
    }

    private long[] findCollidingIds(long firstId, long into, long from) {
        MutableLongList list = LongLists.mutable.empty();
        for (int i = 0; i < 64; ++i) {
            long mask = 1L << i;
            if ((into & mask) == 0L || (from & mask) == 0L) continue;
            list.add(firstId + (long)i);
        }
        return list.toArray();
    }
}

