/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.memory.MemoryTracker;

public interface IdController
extends Lifecycle {
    public void maintenance();

    public void initialize(FileSystemAbstraction var1, Path var2, Config var3, Supplier<TransactionSnapshot> var4, TransactionIdVisibilityBoundary var5, IdFreeCondition var6, MemoryTracker var7, DatabaseReadOnlyChecker var8) throws IOException;

    @FunctionalInterface
    public static interface TransactionIdVisibilityBoundary {
        public long oldestObservableHorizon();
    }

    public record TransactionSnapshot(long currentSequenceNumber, long snapshotTimeMillis, long lastCommittedTransactionId, TransactionIdSnapshot idSnapshot) {
        public TransactionSnapshot(long currentSequenceNumber, long snapshotTimeMillis, long lastCommittedTransactionId) {
            this(currentSequenceNumber, snapshotTimeMillis, lastCommittedTransactionId, TransactionIdSnapshot.EMPTY_ID_SNAPSHOT);
        }
    }

    public static interface IdFreeCondition {
        public boolean eligibleForFreeing(TransactionSnapshot var1);
    }
}

