/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class BufferedIdController
extends LifecycleAdapter
implements IdController {
    private final BufferingIdGeneratorFactory bufferingIdGeneratorFactory;
    private final JobScheduler scheduler;
    private JobHandle jobHandle;

    public BufferedIdController(BufferingIdGeneratorFactory bufferingIdGeneratorFactory, JobScheduler scheduler) {
        this.bufferingIdGeneratorFactory = bufferingIdGeneratorFactory;
        this.scheduler = scheduler;
    }

    public void start() {
        this.jobHandle = this.scheduler.scheduleRecurring(Group.STORAGE_MAINTENANCE, this::maintenance, 1L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.jobHandle != null) {
            this.jobHandle.cancel();
            this.jobHandle = null;
        }
    }

    @Override
    public void clear() {
        this.bufferingIdGeneratorFactory.clear();
    }

    @Override
    public void maintenance() {
        this.bufferingIdGeneratorFactory.maintenance();
    }

    @Override
    public void initialize(Supplier<IdController.ConditionSnapshot> conditionSnapshotSupplier) {
        this.bufferingIdGeneratorFactory.initialize(conditionSnapshotSupplier);
    }
}

