/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.internal.id.DelayedBuffer;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.io.pagecache.IOLimiter;

class BufferingIdGenerator
extends IdGenerator.Delegate {
    private DelayedBuffer<IdController.ConditionSnapshot> buffer;

    BufferingIdGenerator(IdGenerator delegate) {
        super(delegate);
    }

    void initialize(Supplier<IdController.ConditionSnapshot> boundaries, Predicate<IdController.ConditionSnapshot> safeThreshold) {
        this.buffer = new DelayedBuffer<IdController.ConditionSnapshot>(boundaries, safeThreshold, 10000, freedIds -> {
            try (IdGenerator.Marker reuseMarker = super.marker();){
                for (long id : freedIds) {
                    reuseMarker.markFree(id);
                }
            }
        });
    }

    @Override
    public IdGenerator.Marker marker() {
        final IdGenerator.Marker actual = super.marker();
        return new IdGenerator.Marker(){

            @Override
            public void markUsed(long id) {
                actual.markUsed(id);
            }

            @Override
            public void markDeleted(long id) {
                actual.markDeleted(id);
                BufferingIdGenerator.this.buffer.offer(id);
            }

            @Override
            public void markFree(long id) {
                actual.markFree(id);
            }

            @Override
            public void close() {
                actual.close();
            }
        };
    }

    @Override
    public void maintenance() {
        this.buffer.maintenance();
        super.maintenance();
    }

    @Override
    public void clearCache() {
        this.buffer.clear();
        super.clearCache();
    }

    void clear() {
        this.buffer.clear();
    }

    @Override
    public void checkpoint(IOLimiter ioLimiter) {
        this.buffer.maintenance();
        super.checkpoint(ioLimiter);
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
        super.close();
    }
}

