/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.internal.id.indexed.ConcurrentLongQueue;
import org.neo4j.internal.id.indexed.FreeIdScanner;
import org.neo4j.internal.id.indexed.HeaderReader;
import org.neo4j.internal.id.indexed.HeaderWriter;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IdRangeLayout;
import org.neo4j.internal.id.indexed.IdRangeMarker;
import org.neo4j.internal.id.indexed.IdRangeMerger;
import org.neo4j.internal.id.indexed.SpmcLongQueue;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.util.FeatureToggles;

public class IndexedIdGenerator
implements IdGenerator {
    public static final Monitor NO_MONITOR = new Monitor(){

        @Override
        public void opened(long highestWrittenId, long highId) {
        }

        @Override
        public void allocatedFromHigh(long allocatedId) {
        }

        @Override
        public void allocatedFromReused(long allocatedId) {
        }

        @Override
        public void cached(long cachedId) {
        }

        @Override
        public void markedAsUsed(long markedId) {
        }

        @Override
        public void markedAsDeleted(long markedId) {
        }

        @Override
        public void markedAsFree(long markedId) {
        }

        @Override
        public void markedAsReserved(long markedId) {
        }

        @Override
        public void markedAsUnreserved(long markedId) {
        }

        @Override
        public void markedAsDeletedAndFree(long markedId) {
        }

        @Override
        public void markSessionDone() {
        }

        @Override
        public void normalized(long idRange) {
        }

        @Override
        public void bridged(long bridgedId) {
        }

        @Override
        public void checkpoint(long highestWrittenId, long highId) {
        }

        @Override
        public void clearingCache() {
        }

        @Override
        public void clearedCache() {
        }

        @Override
        public void close() {
        }
    };
    private static final boolean STRICTLY_PRIORITIZE_FREELIST_DEFAULT = false;
    public static final String STRICTLY_PRIORITIZE_FREELIST_NAME = "strictlyPrioritizeFreelist";
    static final long NO_ID = -1L;
    static final int IDS_PER_ENTRY = 128;
    private static final int SMALL_CACHE_CAPACITY = 256;
    private static final int LARGE_CACHE_CAPACITY = 16384;
    private static final long STARTING_GENERATION = 1L;
    private final GBPTree<IdRangeKey, IdRange> tree;
    private final ConcurrentLongQueue cache;
    private final IdType idType;
    private final int idsPerEntry;
    private final int cacheOptimisticRefillThreshold;
    private final Lock commitAndReuseLock = new ReentrantLock();
    private final IdRangeLayout layout;
    private final FreeIdScanner scanner;
    private final AtomicLong highId = new AtomicLong();
    private final long maxId;
    private final AtomicBoolean atLeastOneIdOnFreelist = new AtomicBoolean();
    private final long generation;
    private final boolean needsRebuild;
    private final AtomicLong highestWrittenId = new AtomicLong();
    private final File file;
    private final boolean readOnly;
    private volatile boolean started;
    private final IdRangeMerger defaultMerger;
    private final IdRangeMerger recoveryMerger;
    private final Monitor monitor;

    public IndexedIdGenerator(PageCache pageCache, File file, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdType idType, boolean allowLargeIdCaches, LongSupplier initialHighId, long maxId, boolean readOnly, OpenOption ... openOptions) {
        this(pageCache, file, recoveryCleanupWorkCollector, idType, allowLargeIdCaches, initialHighId, maxId, readOnly, NO_MONITOR, openOptions);
    }

    public IndexedIdGenerator(PageCache pageCache, File file, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdType idType, boolean allowLargeIdCaches, LongSupplier initialHighId, long maxId, boolean readOnly, Monitor monitor, OpenOption ... openOptions) {
        this.file = file;
        this.readOnly = readOnly;
        int cacheCapacity = idType.highActivity() && allowLargeIdCaches ? 16384 : 256;
        this.idType = idType;
        this.cacheOptimisticRefillThreshold = cacheCapacity / 4;
        this.cache = new SpmcLongQueue(cacheCapacity);
        this.maxId = maxId;
        this.monitor = monitor;
        this.defaultMerger = new IdRangeMerger(false, monitor);
        this.recoveryMerger = new IdRangeMerger(true, monitor);
        Optional<HeaderReader> header = IndexedIdGenerator.readHeader(pageCache, file);
        boolean bl = this.needsRebuild = header.isEmpty() || header.get().generation == 1L;
        if (!this.needsRebuild) {
            this.highId.set(header.get().highId);
            this.highestWrittenId.set(header.get().highestWrittenId);
            this.generation = header.get().generation + 1L;
            this.idsPerEntry = header.get().idsPerEntry;
            this.atLeastOneIdOnFreelist.set(true);
        } else {
            this.highId.set(initialHighId.getAsLong());
            this.highestWrittenId.set(this.highId.get() - 1L);
            this.generation = 2L;
            this.idsPerEntry = 128;
        }
        monitor.opened(this.highestWrittenId.get(), this.highId.get());
        this.layout = new IdRangeLayout(this.idsPerEntry);
        this.tree = this.instantiateTree(pageCache, file, recoveryCleanupWorkCollector, readOnly, openOptions);
        boolean strictlyPrioritizeFreelist = FeatureToggles.flag(IndexedIdGenerator.class, (String)STRICTLY_PRIORITIZE_FREELIST_NAME, (boolean)false);
        this.scanner = readOnly ? null : new FreeIdScanner(this.idsPerEntry, this.tree, this.cache, this.atLeastOneIdOnFreelist, () -> this.lockAndInstantiateMarker(true), this.generation, strictlyPrioritizeFreelist);
    }

    private GBPTree<IdRangeKey, IdRange> instantiateTree(PageCache pageCache, File file, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, OpenOption[] openOptions) {
        try {
            HeaderWriter headerWriter = new HeaderWriter(this.highId::get, this.highestWrittenId::get, 1L, this.idsPerEntry);
            return new GBPTree(pageCache, file, (Layout)this.layout, 0, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, (Consumer)headerWriter, recoveryCleanupWorkCollector, readOnly, openOptions);
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Id generator file could not be found, most likely this database needs to be recovered, file:" + file, e);
        }
    }

    @Override
    public long nextId() {
        this.assertNotReadOnly();
        this.maintenance();
        long id = this.cache.takeOrDefault(-1L);
        if (id != -1L) {
            this.monitor.allocatedFromReused(id);
            return id;
        }
        do {
            id = this.highId.getAndIncrement();
            IdValidator.assertIdWithinMaxCapacity(this.idType, id, this.maxId);
        } while (IdValidator.isReservedId(id));
        this.monitor.allocatedFromHigh(id);
        return id;
    }

    @Override
    public org.neo4j.internal.id.IdRange nextIdBatch(int size) {
        long prev = -1L;
        long startOfRange = -1L;
        int rangeLength = 0;
        MutableLongList other = null;
        for (int i = 0; i < size; ++i) {
            long id = this.nextId();
            if (other != null) {
                other.add(id);
                continue;
            }
            if (i == 0) {
                prev = id;
                startOfRange = id;
                rangeLength = 1;
                continue;
            }
            if (id == prev + 1L) {
                prev = id;
                ++rangeLength;
                continue;
            }
            other = LongLists.mutable.empty();
            other.add(id);
        }
        return new org.neo4j.internal.id.IdRange(other != null ? other.toArray() : ArrayUtils.EMPTY_LONG_ARRAY, startOfRange, rangeLength);
    }

    @Override
    public IdGenerator.Marker marker() {
        if (!this.started && this.needsRebuild) {
            return NOOP_MARKER;
        }
        return this.lockAndInstantiateMarker(true);
    }

    IdRangeMarker lockAndInstantiateMarker(boolean bridgeIdGaps) {
        this.assertNotReadOnly();
        this.commitAndReuseLock.lock();
        try {
            return new IdRangeMarker(this.idsPerEntry, (Layout<IdRangeKey, IdRange>)this.layout, (Writer<IdRangeKey, IdRange>)this.tree.writer(), this.commitAndReuseLock, this.started ? this.defaultMerger : this.recoveryMerger, this.started, this.atLeastOneIdOnFreelist, this.generation, this.highestWrittenId, bridgeIdGaps, this.monitor);
        }
        catch (Exception e) {
            this.commitAndReuseLock.unlock();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.scanner, this.tree, this.monitor});
    }

    @Override
    public long getHighId() {
        return this.highId.get();
    }

    @Override
    public void setHighId(long newHighId) {
        long expect;
        this.assertNotReadOnly();
        while (newHighId > (expect = this.highId.get()) && !this.highId.compareAndSet(expect, newHighId)) {
        }
    }

    @Override
    public void start(FreeIds freeIdsForRebuild) throws IOException {
        if (this.needsRebuild) {
            this.assertNotReadOnly();
            try (IdRangeMarker idRangeMarker = this.lockAndInstantiateMarker(false);){
                long highestFreeId = freeIdsForRebuild.accept(id -> {
                    idRangeMarker.markDeleted(id);
                    idRangeMarker.markFree(id);
                });
                this.highId.set(highestFreeId + 1L);
                this.highestWrittenId.set(highestFreeId);
            }
            this.checkpoint(IOLimiter.UNLIMITED);
            this.atLeastOneIdOnFreelist.set(true);
        }
        this.started = true;
        this.maintenance();
    }

    @Override
    public void checkpoint(IOLimiter ioLimiter) {
        this.tree.checkpoint(ioLimiter, (Consumer)new HeaderWriter(this.highId::get, this.highestWrittenId::get, this.generation, this.idsPerEntry));
        this.monitor.checkpoint(this.highestWrittenId.get(), this.highId.get());
    }

    @Override
    public void maintenance() {
        if (!this.readOnly && this.cache.size() < this.cacheOptimisticRefillThreshold) {
            this.scanner.tryLoadFreeIdsIntoCache();
        }
    }

    @Override
    public void clearCache() {
        if (!this.readOnly) {
            this.monitor.clearingCache();
            this.scanner.clearCache();
            this.monitor.clearedCache();
        }
    }

    @Override
    public long getHighestPossibleIdInUse() {
        return this.getHighId() - 1L;
    }

    @Override
    public long getNumberOfIdsInUse() {
        return this.getHighId();
    }

    @Override
    public long getDefragCount() {
        return this.cache.size();
    }

    @Override
    public void markHighestWrittenAtHighId() {
        this.assertNotReadOnly();
        this.highestWrittenId.set(this.highId.get() - 1L);
    }

    public File file() {
        return this.file;
    }

    private static Optional<HeaderReader> readHeader(PageCache pageCache, File file) {
        try {
            HeaderReader headerReader = new HeaderReader();
            GBPTree.readHeader((PageCache)pageCache, (File)file, (Header.Reader)headerReader);
            return Optional.of(headerReader);
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void dump(PageCache pageCache, File file) throws IOException {
        HeaderReader header = IndexedIdGenerator.readHeader(pageCache, file).orElseThrow(() -> new NoSuchFileException(file.getAbsolutePath()));
        IdRangeLayout layout = new IdRangeLayout(header.idsPerEntry);
        try (GBPTree tree = new GBPTree(pageCache, file, (Layout)layout, 0, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.immediate(), true, new OpenOption[0]);){
            tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<IdRangeKey, IdRange>(){
                private IdRangeKey key;

                public void key(IdRangeKey key, boolean isLeaf) {
                    this.key = key;
                }

                public void value(IdRange value) {
                    System.out.println(String.format("%s [%d]", value.toString(), this.key.getIdRangeIdx()));
                }
            });
            System.out.println(header);
        }
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor<IdRangeKey>)((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class)));
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor<IdRangeKey> visitor) {
        try {
            return this.tree.consistencyCheck(visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void assertNotReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can not write to id generator while in read only mode.");
        }
    }

    static interface ReservedMarker
    extends AutoCloseable {
        public void markReserved(long var1);

        public void markUnreserved(long var1);

        @Override
        public void close();
    }

    public static interface Monitor
    extends AutoCloseable {
        public void opened(long var1, long var3);

        @Override
        public void close();

        public void allocatedFromHigh(long var1);

        public void allocatedFromReused(long var1);

        public void cached(long var1);

        public void markedAsUsed(long var1);

        public void markedAsDeleted(long var1);

        public void markedAsFree(long var1);

        public void markedAsReserved(long var1);

        public void markedAsUnreserved(long var1);

        public void markedAsDeletedAndFree(long var1);

        public void markSessionDone();

        public void normalized(long var1);

        public void bridged(long var1);

        public void checkpoint(long var1, long var3);

        public void clearingCache();

        public void clearedCache();
    }
}

