/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdRange;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;

public interface IdGenerator
extends IdSequence,
Closeable,
ConsistencyCheckable {
    public static final Marker NOOP_MARKER = new Marker(){

        @Override
        public void markFree(long id) {
        }

        @Override
        public void markUsed(long id) {
        }

        @Override
        public void markDeleted(long id) {
        }

        @Override
        public void close() {
        }
    };

    public void setHighId(long var1);

    public void markHighestWrittenAtHighId();

    public long getHighId();

    public long getHighestPossibleIdInUse();

    public Marker marker(PageCursorTracer var1);

    @Override
    public void close();

    public long getNumberOfIdsInUse();

    public long getDefragCount();

    public void checkpoint(IOLimiter var1, PageCursorTracer var2);

    public void maintenance(PageCursorTracer var1);

    public void start(FreeIds var1, PageCursorTracer var2) throws IOException;

    public void clearCache(PageCursorTracer var1);

    public static class Delegate
    implements IdGenerator {
        private final IdGenerator delegate;

        public Delegate(IdGenerator delegate) {
            this.delegate = delegate;
        }

        @Override
        public long nextId(PageCursorTracer cursorTracer) {
            return this.delegate.nextId(cursorTracer);
        }

        @Override
        public IdRange nextIdBatch(int size, PageCursorTracer cursorTracer) {
            return this.delegate.nextIdBatch(size, cursorTracer);
        }

        @Override
        public void setHighId(long id) {
            this.delegate.setHighId(id);
        }

        @Override
        public void markHighestWrittenAtHighId() {
            this.delegate.markHighestWrittenAtHighId();
        }

        @Override
        public long getHighId() {
            return this.delegate.getHighId();
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.delegate.getHighestPossibleIdInUse();
        }

        @Override
        public Marker marker(PageCursorTracer cursorTracer) {
            return this.delegate.marker(cursorTracer);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public long getNumberOfIdsInUse() {
            return this.delegate.getNumberOfIdsInUse();
        }

        @Override
        public long getDefragCount() {
            return this.delegate.getDefragCount();
        }

        @Override
        public void checkpoint(IOLimiter ioLimiter, PageCursorTracer cursorTracer) {
            this.delegate.checkpoint(ioLimiter, cursorTracer);
        }

        @Override
        public void maintenance(PageCursorTracer cursorTracer) {
            this.delegate.maintenance(cursorTracer);
        }

        @Override
        public void start(FreeIds freeIdsForRebuild, PageCursorTracer cursorTracer) throws IOException {
            this.delegate.start(freeIdsForRebuild, cursorTracer);
        }

        @Override
        public void clearCache(PageCursorTracer cursorTracer) {
            this.delegate.clearCache(cursorTracer);
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, PageCursorTracer cursorTracer) {
            return this.delegate.consistencyCheck(reporterFactory, cursorTracer);
        }
    }

    public static interface Marker
    extends AutoCloseable {
        public void markUsed(long var1);

        public void markDeleted(long var1);

        public void markFree(long var1);

        @Override
        public void close();
    }
}

