/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.internal.id.BufferingIdGenerator;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class BufferingIdGeneratorFactory
implements IdGeneratorFactory {
    private final BufferingIdGenerator[] overriddenIdGenerators = new BufferingIdGenerator[IdType.values().length];
    private Supplier<IdController.ConditionSnapshot> boundaries;
    private final Predicate<IdController.ConditionSnapshot> safeThreshold;
    private final IdGeneratorFactory delegate;

    public BufferingIdGeneratorFactory(IdGeneratorFactory delegate) {
        this.delegate = delegate;
        this.safeThreshold = IdController.ConditionSnapshot::conditionMet;
    }

    public void initialize(Supplier<IdController.ConditionSnapshot> conditionSnapshotSupplier) {
        this.boundaries = conditionSnapshotSupplier;
    }

    @Override
    public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, boolean readOnly, PageCursorTracer cursorTracer, ImmutableSet<OpenOption> openOptions) {
        assert (this.boundaries != null) : "Factory needs to be initialized before usage";
        IdGenerator generator = this.delegate.open(pageCache, filename, idType, highIdScanner, maxId, readOnly, cursorTracer, openOptions);
        return this.wrapAndKeep(idType, generator);
    }

    @Override
    public IdGenerator create(PageCache pageCache, Path filename, IdType idType, long highId, boolean throwIfFileExists, long maxId, boolean readOnly, PageCursorTracer cursorTracer, ImmutableSet<OpenOption> openOptions) {
        IdGenerator idGenerator = this.delegate.create(pageCache, filename, idType, highId, throwIfFileExists, maxId, readOnly, cursorTracer, openOptions);
        return this.wrapAndKeep(idType, idGenerator);
    }

    @Override
    public IdGenerator get(IdType idType) {
        BufferingIdGenerator generator = this.overriddenIdGenerators[idType.ordinal()];
        return generator != null ? generator : this.delegate.get(idType);
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
        Stream.of(this.overriddenIdGenerators).forEach(visitor);
    }

    @Override
    public void clearCache(PageCursorTracer cursorTracer) {
        this.delegate.clearCache(cursorTracer);
    }

    @Override
    public Collection<Path> listIdFiles() {
        return this.delegate.listIdFiles();
    }

    private IdGenerator wrapAndKeep(IdType idType, IdGenerator generator) {
        BufferingIdGenerator bufferingGenerator = new BufferingIdGenerator(generator);
        bufferingGenerator.initialize(this.boundaries, this.safeThreshold);
        this.overriddenIdGenerators[idType.ordinal()] = bufferingGenerator;
        return bufferingGenerator;
    }

    public void maintenance(boolean awaitOngoing, PageCursorTracer pageCursorTracer) {
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.maintenance(awaitOngoing, pageCursorTracer);
        }
    }

    public void clear() {
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.clear();
        }
    }
}

